/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public class PrivateRegistry {
    private static final String DATA_NAME = "dimdoors_private_pockets";
    protected BiMap<UUID, PocketInfo> privatePocketMap = HashBiMap.create();

    public void fromNbt(class_2487 nbt) {
        this.privatePocketMap.clear();
        class_2487 privatePocketMapNbt = nbt.method_10562("private_pocket_map");
        CompletableFuture<Map> futurePrivatePocketMap = CompletableFuture.supplyAsync(() -> ((Stream)((Stream)privatePocketMapNbt.method_10541().stream().unordered()).map(key -> {
            class_2487 pocketInfoNbt = privatePocketMapNbt.method_10562(key);
            return CompletableFuture.supplyAsync(() -> new Pair((Object)UUID.fromString(key), (Object)PocketInfo.fromNbt(pocketInfoNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond)));
        this.privatePocketMap.putAll(futurePrivatePocketMap.join());
    }

    public class_2487 toNbt(class_2487 nbt) {
        CompletableFuture<class_2487> futurePrivatePocketMapNbt = StreamUtils.supplyAsync(() -> {
            Map privatePocketNbtMap = ((Stream)this.privatePocketMap.entrySet().parallelStream().unordered()).collect(Collectors.toConcurrentMap(entry -> ((UUID)entry.getKey()).toString(), entry -> PocketInfo.toNbt((PocketInfo)entry.getValue())));
            class_2487 privatePocketMapNbt = new class_2487();
            privatePocketNbtMap.forEach((arg_0, arg_1) -> ((class_2487)privatePocketMapNbt).method_10566(arg_0, arg_1));
            return privatePocketMapNbt;
        });
        nbt.method_10566("private_pocket_map", (class_2520)futurePrivatePocketMapNbt.join());
        return nbt;
    }

    public PrivatePocket getPrivatePocket(UUID playerUUID) {
        PocketInfo pocket = (PocketInfo)this.privatePocketMap.get((Object)playerUUID);
        if (pocket == null) {
            return null;
        }
        return DimensionalRegistry.getPocketDirectory(pocket.world).getPocket(pocket.id, PrivatePocket.class);
    }

    public void setPrivatePocketID(UUID playerUUID, Pocket pocket) {
        this.privatePocketMap.put((Object)playerUUID, (Object)new PocketInfo(pocket.getWorld(), pocket.getId()));
    }

    public UUID getPrivatePocketOwner(Pocket pocket) {
        return (UUID)this.privatePocketMap.inverse().get((Object)new PocketInfo(pocket.getWorld(), pocket.getId()));
    }

    protected static class PocketInfo {
        public final class_5321<class_1937> world;
        public final int id;

        public PocketInfo(class_5321<class_1937> world, int id) {
            this.world = world;
            this.id = id;
        }

        public static class_2487 toNbt(PocketInfo info) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("world", info.world.method_29177().toString());
            nbt.method_10569("id", info.id);
            return nbt;
        }

        public static PocketInfo fromNbt(class_2487 nbt) {
            return new PocketInfo((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(nbt.method_10558("world"))), nbt.method_10550("id"));
        }
    }
}

