/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.math.GridUtil;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.IdReferencePocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jetbrains.annotations.TestOnly;

public class PocketDirectory {
    int gridSize;
    int privatePocketSize;
    int publicPocketSize;
    Map<Integer, AbstractPocket<?>> pockets;
    private SortedMap<Integer, Integer> nextIDMap;
    class_5321<class_1937> worldKey;

    public PocketDirectory(class_5321<class_1937> worldKey) {
        this.gridSize = DimensionalDoors.getConfig().getPocketsConfig().pocketGridSize;
        this.worldKey = worldKey;
        this.nextIDMap = new TreeMap<Integer, Integer>();
        this.pockets = new HashMap();
    }

    @TestOnly
    public PocketDirectory(class_5321<class_1937> worldKey, int gridSize) {
        this.gridSize = gridSize;
        this.worldKey = worldKey;
        this.nextIDMap = new TreeMap<Integer, Integer>();
        this.pockets = new HashMap();
    }

    public static PocketDirectory readFromNbt(String id, class_2487 nbt) {
        PocketDirectory directory = new PocketDirectory((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(id)));
        directory.gridSize = nbt.method_10550("grid_size");
        directory.privatePocketSize = nbt.method_10550("private_pocket_size");
        directory.publicPocketSize = nbt.method_10550("public_pocket_size");
        class_2487 nextIdMapNbt = nbt.method_10562("next_id_map");
        directory.nextIDMap.putAll(nextIdMapNbt.method_10541().stream().collect(Collectors.toMap(Integer::parseInt, arg_0 -> ((class_2487)nextIdMapNbt).method_10550(arg_0))));
        class_2487 pocketsNbt = nbt.method_10562("pockets");
        directory.pockets = ((Stream)((Stream)pocketsNbt.method_10541().stream().unordered()).map(key -> {
            class_2487 pocketNbt = pocketsNbt.method_10562(key);
            return CompletableFuture.supplyAsync(() -> new Pair((Object)Integer.parseInt(key), AbstractPocket.deserialize(pocketNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond));
        return directory;
    }

    public class_2487 writeToNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("grid_size", this.gridSize);
        nbt.method_10569("private_pocket_size", this.privatePocketSize);
        nbt.method_10569("public_pocket_size", this.publicPocketSize);
        class_2487 nextIdMapNbt = new class_2487();
        this.nextIDMap.forEach((key, value) -> nextIdMapNbt.method_10569(key.toString(), value.intValue()));
        nbt.method_10566("next_id_map", (class_2520)nextIdMapNbt);
        class_2487 pocketsNbt = new class_2487();
        ((Stream)((Stream)this.pockets.entrySet().parallelStream().unordered()).map(entry -> CompletableFuture.supplyAsync(() -> new Pair((Object)((Integer)entry.getKey()).toString(), (Object)((AbstractPocket)entry.getValue()).toNbt(new class_2487())))).map(CompletableFuture::join).sequential()).forEach(pair -> pocketsNbt.method_10566((String)pair.getFirst(), (class_2520)pair.getSecond()));
        nbt.method_10566("pockets", (class_2520)pocketsNbt);
        return nbt;
    }

    public <T extends Pocket> T newPocket(Pocket.PocketBuilder<?, T> builder) {
        int base3Size;
        class_2382 size = builder.getExpectedSize();
        int longest = Math.max(Math.max(size.method_10263(), size.method_10260()), 1);
        longest = Math.floorDiv(longest - 1, this.gridSize * 16) + 1;
        for (base3Size = 1; longest > base3Size; base3Size *= 3) {
        }
        int squaredSize = base3Size * base3Size;
        int cursor = this.nextIDMap.headMap(base3Size + 1).values().stream().mapToInt(num -> num).max().orElse(0);
        cursor -= Math.floorMod(cursor, squaredSize);
        Pocket pocketAt = this.getPocket(cursor);
        while (pocketAt != null) {
            int pocketBase3Size;
            size = pocketAt.getSize();
            longest = Math.max(size.method_10263(), size.method_10260());
            longest = longest / (this.gridSize * 16) + 1;
            for (pocketBase3Size = 1; longest > pocketBase3Size; pocketBase3Size *= 3) {
            }
            pocketAt = this.getPocket(cursor += Math.max(squaredSize, pocketBase3Size * pocketBase3Size));
        }
        cursor = cursor + squaredSize - 1;
        AbstractPocket pocket = ((Pocket.PocketBuilder)((Pocket.PocketBuilder)((Pocket.PocketBuilder)((Pocket.PocketBuilder)builder.id(cursor)).world(this.worldKey)).range(squaredSize)).offsetOrigin((class_2382)this.idToCenteredPos(cursor, base3Size, builder.getExpectedSize()))).build();
        this.nextIDMap.put(base3Size, cursor + squaredSize);
        this.addPocket(pocket);
        IdReferencePocket.IdReferencePocketBuilder idReferenceBuilder = IdReferencePocket.builder();
        for (int i = 1; i < squaredSize; ++i) {
            this.addPocket(((IdReferencePocket.IdReferencePocketBuilder)((IdReferencePocket.IdReferencePocketBuilder)idReferenceBuilder.id(cursor - i)).world(this.worldKey)).referencedId(cursor).build());
        }
        return (T)pocket;
    }

    private void addPocket(AbstractPocket<?> pocket) {
        this.pockets.put(pocket.getId(), pocket);
    }

    public void removePocket(int id) {
        this.pockets.remove(id);
    }

    public Pocket getPocket(int id) {
        AbstractPocket<?> pocket = this.pockets.get(id);
        return pocket == null ? null : pocket.getReferencedPocket(this);
    }

    public <P extends Pocket> P getPocket(int id, Class<P> clazz) {
        Pocket pocket = this.getPocket(id);
        if (clazz.isInstance(pocket)) {
            return (P)((Pocket)clazz.cast(pocket));
        }
        return null;
    }

    public GridUtil.GridPos idToGridPos(int id) {
        return GridUtil.idToGridPos(id);
    }

    public int gridPosToID(GridUtil.GridPos pos) {
        return GridUtil.gridPosToID(pos);
    }

    public class_2338 idToPos(int id) {
        GridUtil.GridPos pos = this.idToGridPos(id);
        return new class_2338(pos.x * this.gridSize * 16, 0, pos.z * this.gridSize * 16);
    }

    public class_2338 idToCenteredPos(int id, int base3Size, class_2382 expectedSize) {
        GridUtil.GridPos pos = this.idToGridPos(id);
        return new class_2338(pos.x * this.gridSize * 16 + (base3Size * this.gridSize - expectedSize.method_10263() / 16) / 2 * 16, 0, pos.z * this.gridSize * 16 + (base3Size * this.gridSize - expectedSize.method_10260() / 16) / 2 * 16);
    }

    public int posToID(class_2338 pos) {
        return this.gridPosToID(new GridUtil.GridPos(Math.floorDiv(pos.method_10263(), this.gridSize * 16), Math.floorDiv(pos.method_10260(), this.gridSize * 16)));
    }

    public Pocket getPocketAt(class_2338 pos) {
        return this.getPocket(this.posToID(pos));
    }

    public boolean isWithinPocketBounds(class_2338 pos) {
        Pocket pocket = this.getPocketAt(pos);
        return pocket != null && pocket.isInBounds(pos);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPrivatePocketSize() {
        return this.privatePocketSize;
    }

    public int getPublicPocketSize() {
        return this.publicPocketSize;
    }

    public Map<Integer, AbstractPocket<?>> getPockets() {
        return this.pockets;
    }
}

