/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.level.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.rift.registry.RiftRegistry;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.RiftSchemas;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.PrivateRegistry;

public class DimensionalRegistry {
    public static final int RIFT_DATA_VERSION = 1;
    private static Map<class_5321<class_1937>, PocketDirectory> pocketRegistry = new HashMap<class_5321<class_1937>, PocketDirectory>();
    private static RiftRegistry riftRegistry = new RiftRegistry();
    private static PrivateRegistry privateRegistry = new PrivateRegistry();

    public static void readFromNbt(class_2487 nbt) {
        int riftDataVersion = nbt.method_10550("RiftDataVersion");
        if (riftDataVersion < 1) {
            nbt = RiftSchemas.update(riftDataVersion, nbt);
        } else if (1 < riftDataVersion) {
            throw new UnsupportedOperationException("Downgrading is not supported!");
        }
        class_2487 pocketRegistryNbt = nbt.method_10562("pocket_registry");
        CompletableFuture<Map> futurePocketRegistry = CompletableFuture.supplyAsync(() -> ((Stream)pocketRegistryNbt.method_10541().stream().map(key -> {
            class_2487 pocketDirectoryNbt = pocketRegistryNbt.method_10562(key);
            return CompletableFuture.supplyAsync(() -> new Pair((Object)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)key)), (Object)PocketDirectory.readFromNbt(key, pocketDirectoryNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond)));
        class_2487 privateRegistryNbt = nbt.method_10562("private_registry");
        CompletableFuture<PrivateRegistry> futurePrivateRegistry = CompletableFuture.supplyAsync(() -> {
            PrivateRegistry privateRegistry = new PrivateRegistry();
            privateRegistry.fromNbt(privateRegistryNbt);
            return privateRegistry;
        });
        pocketRegistry = futurePocketRegistry.join();
        class_2487 riftRegistryNbt = nbt.method_10562("rift_registry");
        CompletableFuture<RiftRegistry> futureRiftRegistry = CompletableFuture.supplyAsync(() -> RiftRegistry.fromNbt(pocketRegistry, riftRegistryNbt));
        riftRegistry = futureRiftRegistry.join();
        privateRegistry = futurePrivateRegistry.join();
    }

    public static void writeToNbt(class_2487 nbt) {
        CompletableFuture<class_2520> futurePocketRegistryNbt = StreamUtils.supplyAsync(() -> {
            ArrayList futurePocketRegistryNbts = new ArrayList();
            pocketRegistry.forEach((key, value) -> futurePocketRegistryNbts.add(CompletableFuture.supplyAsync(() -> new Pair((Object)key.method_29177().toString(), (Object)value.writeToNbt()))));
            class_2487 pocketRegistryNbt = new class_2487();
            ((Stream)futurePocketRegistryNbts.parallelStream().unordered()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond)).forEach((arg_0, arg_1) -> ((class_2487)pocketRegistryNbt).method_10566(arg_0, arg_1));
            return pocketRegistryNbt;
        });
        CompletableFuture<class_2520> futureRiftRegistryNbt = StreamUtils.supplyAsync(riftRegistry::toNbt);
        CompletableFuture<class_2520> futurePrivateRegistryNbt = CompletableFuture.supplyAsync(() -> privateRegistry.toNbt(new class_2487()));
        nbt.method_10566("pocket_registry", futurePocketRegistryNbt.join());
        nbt.method_10566("rift_registry", futureRiftRegistryNbt.join());
        nbt.method_10566("private_registry", futurePrivateRegistryNbt.join());
        nbt.method_10569("RiftDataVersion", 1);
    }

    public static RiftRegistry getRiftRegistry() {
        return riftRegistry;
    }

    public static PrivateRegistry getPrivateRegistry() {
        return privateRegistry;
    }

    public static PocketDirectory getPocketDirectory(class_5321<class_1937> key) {
        if (!ModDimensions.isPocketDimension(key)) {
            throw new UnsupportedOperationException("PocketRegistry is only available for pocket dimensions!");
        }
        return pocketRegistry.computeIfAbsent(key, PocketDirectory::new);
    }

    public static boolean isValidWorld(class_1937 level) {
        return level != null && level.method_27983() != null && level.method_27983().equals(class_1937.field_25179);
    }
}

