/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.level.component;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_2487;
import net.minecraft.class_2818;
import org.dimdev.dimdoors.world.level.component.fabric.ChunkLazilyGeneratedComponentImpl;

public class ChunkLazilyGeneratedComponent {
    private boolean hasBeenLazyGenned = false;

    public boolean hasBeenLazyGenned() {
        return this.hasBeenLazyGenned;
    }

    public void setGenned() {
        if (this.hasBeenLazyGenned) {
            throw new UnsupportedOperationException("This chunk seems to have already been lazily generated!");
        }
        this.hasBeenLazyGenned = true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ChunkLazilyGeneratedComponent get(class_2818 chunk) {
        return ChunkLazilyGeneratedComponentImpl.get(chunk);
    }

    public void readFromNbt(class_2487 nbt) {
        if (nbt.method_10573("has_been_lazy_genned", 3)) {
            this.hasBeenLazyGenned = nbt.method_10550("has_been_lazy_genned") == 1;
        }
    }

    public void writeToNbt(class_2487 nbt) {
        if (this.hasBeenLazyGenned) {
            nbt.method_10569("has_been_lazy_genned", 1);
        }
    }
}

