/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.conditions;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.dimdev.dimdoors.world.decay.DecayCondition;
import org.dimdev.dimdoors.world.decay.DecaySource;

public abstract class GenericDecayCondition<T>
implements DecayCondition {
    private final TagOrElementLocation<T> tagOrElementLocation;
    private final boolean invert;

    public static <T extends GenericDecayCondition<?>, V> Codec<T> createCodec(BiFunction<TagOrElementLocation<V>, Boolean, T> function, class_5321<class_2378<V>> key) {
        Codec codec = Codec.STRING.comapFlatMap(string -> string.startsWith("#") ? class_2960.method_29186((String)string.substring(1)).map(resourceLocation -> new TagOrElementLocation((class_2960)resourceLocation, true, key)) : class_2960.method_29186((String)string).map(resourceLocation -> new TagOrElementLocation((class_2960)resourceLocation, false, key)), TagOrElementLocation::decoratedId);
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("entry").forGetter(t -> t.getTagOrElementLocation()), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(GenericDecayCondition::invert)).apply((Applicative)instance, function));
    }

    public GenericDecayCondition(TagOrElementLocation<T> tagOrElementLocation, boolean invert) {
        this.tagOrElementLocation = tagOrElementLocation;
        this.invert = invert;
    }

    public TagOrElementLocation<T> getTagOrElementLocation() {
        return this.tagOrElementLocation;
    }

    @Override
    public boolean test(class_1937 world, class_2338 pos, class_2680 origin, class_2680 targetBlock, class_3610 targetFluid, DecaySource source) {
        return this.tagOrElementLocation.test(this.getHolder(world, pos, origin, targetBlock, targetFluid, source));
    }

    public abstract class_6880<T> getHolder(class_1937 var1, class_2338 var2, class_2680 var3, class_2680 var4, class_3610 var5, DecaySource var6);

    public boolean invert() {
        return this.invert;
    }

    public static final class TagOrElementLocation<T> {
        private class_6862<T> tag;
        private class_5321<T> key;

        public static <T> TagOrElementLocation<T> of(class_6862<T> tag, class_5321<class_2378<T>> registry) {
            return new TagOrElementLocation<T>(tag.comp_327(), true, registry);
        }

        public static <T> TagOrElementLocation<T> of(class_5321<T> tag, class_5321<class_2378<T>> registry) {
            return new TagOrElementLocation<T>(tag.method_29177(), false, registry);
        }

        public TagOrElementLocation(class_2960 id, boolean tag, class_5321<class_2378<T>> registryResourceKey) {
            if (tag) {
                this.tag = class_6862.method_40092(registryResourceKey, (class_2960)id);
            } else {
                this.key = class_5321.method_29179(registryResourceKey, (class_2960)id);
            }
        }

        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag != null ? "#" + String.valueOf(this.tag.comp_327()) : this.key.method_29177().toString();
        }

        public boolean test(class_6880<T> holder) {
            return this.tag != null && holder.method_40220(this.tag) || holder.method_40225(this.key);
        }

        public Set<class_5321<T>> getValues(class_2378<T> registry) {
            return this.key != null ? Set.of(this.key) : Streams.stream((Iterable)registry.method_40286(this.tag)).map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
    }
}

