/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.world.decay.DecayCondition;
import org.dimdev.dimdoors.world.decay.DecayResult;
import org.dimdev.dimdoors.world.decay.DecaySource;

public record DecayPattern(List<DecayCondition> conditions, DecayResult result) {
    public static Codec<DecayPattern> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DecayCondition.LIST_CODEC.fieldOf("conditions").forGetter(DecayPattern::conditions), (App)DecayResult.CODEC.fieldOf("result").forGetter(DecayPattern::result)).apply((Applicative)instance, DecayPattern::new));
    public static final Event<EntropyEvent> ENTROPY_EVENT = EventFactory.of(entropyEvents -> (world, pos, entorpy) -> {
        for (EntropyEvent event : entropyEvents) {
            event.entropy(world, pos, entorpy);
        }
    });

    public boolean test(class_1937 world, class_2338 pos, class_2680 origin, class_2680 targetBlock, class_3610 targetFluid, DecaySource source) {
        return this.conditions.stream().allMatch(condition -> condition.test(world, pos, origin, targetBlock, targetFluid, source));
    }

    public void process(class_1937 world, class_2338 pos, class_2680 origin, class_2680 targetBlock, class_3610 targetFluid, DecaySource source) {
        ((EntropyEvent)ENTROPY_EVENT.invoker()).entropy(world, pos, this.result.process(world, pos, origin, targetBlock, targetFluid, source));
    }

    public Set<class_5321<class_2248>> constructApplicableBlocks() {
        return this.conditions.stream().flatMap(a -> a.constructApplicableBlocks().stream()).collect(Collectors.toSet());
    }

    public Set<class_5321<class_3611>> constructApplicableFluids() {
        return this.conditions.stream().flatMap(a -> a.constructApplicableFluids().stream()).collect(Collectors.toSet());
    }

    public Object willBecome(Object prior) {
        return this.result.produces(prior);
    }

    public boolean shouldDropThread(class_3218 world, class_2338 pos) {
        return world.method_8409().method_43057() < this.result.worldThreadChance();
    }

    private static interface EntropyEvent {
        public void entropy(class_1937 var1, class_2338 var2, int var3);
    }
}

