/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.decay.DecayPattern;
import org.dimdev.dimdoors.world.decay.DecaySource;

public final class Decay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_5321<class_1937>, Set<DecayTask>> DECAY_QUEUE = new HashMap<class_5321<class_1937>, Set<DecayTask>>();

    public static void applySpreadDecay(class_3218 world, class_2338 pos, class_5819 random, DecaySource source) {
        if (random.method_43058() < DimensionalDoors.getConfig().getDecayConfig().decaySpreadChance) {
            class_2680 origin = world.method_8320(pos);
            int decayAmount = random.method_43048(5) + 1;
            ArrayList<class_2350> directions = new ArrayList<class_2350>(Arrays.asList(class_2350.values()));
            for (int i = 0; i < decayAmount; ++i) {
                Decay.decayBlock(world, pos.method_10093((class_2350)directions.remove(random.method_43048(5 - i))), origin, source);
            }
        }
    }

    public static void decayBlock(class_3218 world, class_2338 pos, class_2680 origin, DecaySource source) {
        class_2680 targetState = world.method_8320(pos);
        class_3610 fluidState = world.method_8316(pos);
        Collection<DecayPattern> patterns = DecayLoader.getInstance().getPatterns(targetState.method_41520().method_40230().get());
        if (patterns.isEmpty()) {
            patterns = DecayLoader.getInstance().getPatterns((class_5321<class_3611>)fluidState.method_15772().method_40178().method_40237());
        }
        if (patterns.isEmpty()) {
            return;
        }
        for (DecayPattern pattern : patterns) {
            if (!world.method_39999(pos) || !pattern.test((class_1937)world, pos, origin, targetState, fluidState, source)) continue;
            world.method_18766(class_1301.method_5909((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.field_13987).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(pos, 5)));
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_3414)ModSoundEvents.TEARING.get(), class_3419.field_15245, 0.5f, 1.0f);
            Decay.queueDecay(world, pos, origin, pattern, source, DimensionalDoors.getConfig().getDecayConfig().decayDelay);
            break;
        }
    }

    public static void queueDecay(class_3218 world, class_2338 pos, class_2680 origin, DecayPattern pattern, DecaySource source, int delay) {
        DecayTask task = new DecayTask(pos, origin, pattern, source, delay);
        if (delay <= 0) {
            task.process(world);
        } else {
            DECAY_QUEUE.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new HashSet()).add(task);
        }
    }

    public static void tick(class_3218 world) {
        class_5321 key = world.method_27983();
        if (DECAY_QUEUE.containsKey(key)) {
            Set<DecayTask> tasks = DECAY_QUEUE.get(key);
            Set<DecayTask> tasksToRun = tasks.stream().filter(DecayTask::reduceDelayIsDone).collect(Collectors.toSet());
            tasks.removeAll(tasksToRun);
            tasksToRun.forEach(task -> task.process(world));
        }
    }

    public static class DecayLoader
    implements class_4013 {
        private static final Logger LOGGER = LogManager.getLogger();
        private static final DecayLoader INSTANCE = new DecayLoader();
        private final Map<class_5321<class_2248>, List<DecayPattern>> blockPatterns = new HashMap<class_5321<class_2248>, List<DecayPattern>>();
        private final Map<class_5321<class_3611>, List<DecayPattern>> fluidPatterns = new HashMap<class_5321<class_3611>, List<DecayPattern>>();

        private DecayLoader() {
        }

        public static DecayLoader getInstance() {
            return INSTANCE;
        }

        public void method_14491(class_3300 manager) {
            this.blockPatterns.clear();
            CompletableFuture futurePatternList = ResourceUtil.loadResourcePathToCollection(manager, "decay_patterns", ".json", new ArrayList(), ResourceUtil.JSON_READER.andThenReader(this::loadPattern));
            for (DecayPattern pattern : (List)futurePatternList.join()) {
                for (class_5321<class_2248> class_53212 : pattern.constructApplicableBlocks()) {
                    this.blockPatterns.computeIfAbsent(class_53212, b -> new ArrayList());
                    this.blockPatterns.get(class_53212).add(pattern);
                }
                for (class_5321<class_2248> class_53213 : pattern.constructApplicableFluids()) {
                    this.fluidPatterns.computeIfAbsent(class_53213, b -> new ArrayList());
                    this.fluidPatterns.get(class_53213).add(pattern);
                }
            }
        }

        private DecayPattern loadPattern(JsonElement json, class_2960 ignored) {
            return (DecayPattern)((Pair)((DataResult)JsonOps.INSTANCE.withDecoder(DecayPattern.CODEC).apply(json)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))).getFirst();
        }

        public Collection<DecayPattern> getPatterns(Object object) {
            if (object instanceof class_5321) {
                class_5321 key = (class_5321)object;
                if (key.method_31163(class_7924.field_41254) && this.blockPatterns.containsKey(key)) {
                    return this.blockPatterns.get(key);
                }
                if (key.method_31163(class_7924.field_41270) && this.fluidPatterns.containsKey(key)) {
                    return this.fluidPatterns.get(key);
                }
            }
            return Collections.emptyList();
        }

        public Collection<DecayPattern> getPatterns(class_5321<class_3611> fluid) {
            return this.fluidPatterns.getOrDefault(fluid, Collections.emptyList());
        }

        public Map<class_5321<class_2248>, List<DecayPattern>> getBlockPatterns() {
            return this.blockPatterns;
        }
    }

    private static class DecayTask {
        private final class_2338 pos;
        private final class_2680 origin;
        private final DecayPattern processor;
        private final DecaySource source;
        private int delay;

        public DecayTask(class_2338 pos, class_2680 origin, DecayPattern processor, DecaySource source, int delay) {
            this.pos = pos;
            this.origin = origin;
            this.processor = processor;
            this.source = source;
            this.delay = delay;
        }

        public boolean reduceDelayIsDone() {
            return --this.delay <= 0;
        }

        public void process(class_3218 world) {
            class_2680 targetBlock = world.method_8320(this.pos);
            class_3610 targetFluid = world.method_8316(this.pos);
            world.method_18766(class_1301.method_5909((double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.field_13987).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(this.pos, -1)));
            world.method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), targetBlock.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1.0f);
            if (this.source.decayIntoWorldThread()) {
                if (DimensionalDoors.getConfig().getDecayConfig().decaysIntoAir) {
                    world.method_8501(this.pos, class_2246.field_10124.method_9564());
                } else {
                    this.processor.process((class_1937)world, this.pos, this.origin, targetBlock, targetFluid, this.source);
                }
            } else {
                this.processor.process((class_1937)world, this.pos, this.origin, targetBlock, targetFluid, this.source);
            }
        }
    }
}

