/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.Objects;
import java.util.OptionalLong;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1992;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.BlankChunkGenerator;

public final class ModDimensions {
    public static final class_5321<class_1937> LIMBO = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionalDoors.id("limbo"));
    public static final class_5321<class_1937> PERSONAL = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionalDoors.id("personal_pockets"));
    public static final class_5321<class_1937> PUBLIC = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionalDoors.id("public_pockets"));
    public static final class_5321<class_1937> DUNGEON = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DimensionalDoors.id("dungeon_pockets"));
    public static final class_5321<class_5363> LIMBO_STEM = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)DimensionalDoors.id("limbo"));
    public static final class_5321<class_5363> PERSONAL_STEM = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)DimensionalDoors.id("person"));
    public static final class_5321<class_5363> PUBLIC_STEM = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)DimensionalDoors.id("public"));
    public static final class_5321<class_5363> DUNGEON_STEM = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)DimensionalDoors.id("dungeon"));
    public static final class_5321<class_2874> LIMBO_TYPE_KEY = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)DimensionalDoors.id("limbo"));
    public static final class_5321<class_2874> POCKET_TYPE_KEY = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)DimensionalDoors.id("pocket"));
    public static class_2874 LIMBO_TYPE;
    public static class_2874 POCKET_TYPE;
    public static class_3218 LIMBO_DIMENSION;
    public static class_3218 PERSONAL_POCKET_DIMENSION;
    public static class_3218 PUBLIC_POCKET_DIMENSION;
    public static class_3218 DUNGEON_POCKET_DIMENSION;

    public static boolean isPocketDimension(class_1937 world) {
        return ModDimensions.isPocketDimension((class_5321<class_1937>)world.method_27983());
    }

    public static boolean isPrivatePocketDimension(class_1937 world) {
        return world != null && world == PERSONAL_POCKET_DIMENSION;
    }

    public static boolean isPocketDimension(class_5321<class_1937> type) {
        return Objects.equals(type, PERSONAL) || Objects.equals(type, PUBLIC) || Objects.equals(type, DUNGEON);
    }

    public static boolean isDungeonDimension(class_5321<class_1937> type) {
        return Objects.equals(type, PERSONAL) || Objects.equals(type, PUBLIC) || Objects.equals(type, DUNGEON);
    }

    public static boolean isLimboDimension(class_1937 world) {
        return world != null && world.method_27983().equals(LIMBO);
    }

    public static void init() {
        LifecycleEvent.SERVER_STARTED.register(server -> {
            LIMBO_TYPE = (class_2874)server.method_30611().method_30530(class_7924.field_41241).method_29107(LIMBO_TYPE_KEY);
            POCKET_TYPE = (class_2874)server.method_30611().method_30530(class_7924.field_41241).method_29107(POCKET_TYPE_KEY);
            LIMBO_DIMENSION = server.method_3847(LIMBO);
            PERSONAL_POCKET_DIMENSION = server.method_3847(PERSONAL);
            PUBLIC_POCKET_DIMENSION = server.method_3847(PUBLIC);
            DUNGEON_POCKET_DIMENSION = server.method_3847(DUNGEON);
        });
        DeferredRegister deffered = DeferredRegister.create((String)"dimdoors", (class_5321)class_7924.field_41260);
        deffered.register("blank", () -> BlankChunkGenerator.CODEC);
        deffered.register();
    }

    public static void bootstrap(class_7891<class_2874> entries) {
        entries.method_46838(LIMBO_TYPE_KEY, (Object)new class_2874(OptionalLong.of(6000L), true, false, false, false, 4.0, false, true, 0, 256, 256, class_3481.field_25588, DimensionalDoors.id("limbo"), 0.1f, new class_2874.class_7512(false, false, (class_6017)class_6019.method_35017((int)0, (int)7), 0)));
        entries.method_46838(POCKET_TYPE_KEY, (Object)new class_2874(OptionalLong.of(6000L), true, false, false, false, 4.0, false, true, 0, 256, 256, class_3481.field_25588, DimensionalDoors.id("dungeon"), 0.1f, new class_2874.class_7512(false, false, (class_6017)class_6019.method_35017((int)0, (int)7), 0)));
    }

    private static class_5363 createPocketStem(class_6880<class_2874> dimensionType, class_6880<class_1959> biome) {
        return new class_5363(dimensionType, (class_2794)BlankChunkGenerator.of((class_1966)new class_1992(biome)));
    }
}

