/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.util.schematic;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_3264;
import org.dimdev.dimdoors.util.schematic.RelativeBlockSample;
import org.dimdev.dimdoors.util.schematic.SchematicBlockPalette;
import org.dimdev.dimdoors.util.schematic.SchematicMetadata;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;

public class Schematic {
    private static final Consumer<String> PRINT_TO_STDERR = System.err::println;
    public static final Codec<Schematic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("Version").forGetter(Schematic::getVersion), (App)Codec.INT.optionalFieldOf("Data Version", (Object)class_155.method_16673().method_48017(class_3264.field_14190)).forGetter(Schematic::getDataVersion), (App)SchematicMetadata.CODEC.optionalFieldOf("Metadata", (Object)SchematicMetadata.EMPTY).forGetter(Schematic::getMetadata), (App)Codec.SHORT.fieldOf("Width").forGetter(Schematic::getWidth), (App)Codec.SHORT.fieldOf("Height").forGetter(Schematic::getHeight), (App)Codec.SHORT.fieldOf("Length").forGetter(Schematic::getLength), (App)class_2382.field_25123.fieldOf("Offset").forGetter(Schematic::getOffset), (App)Codec.INT.fieldOf("PaletteMax").forGetter(Schematic::getPaletteMax), (App)SchematicBlockPalette.CODEC.fieldOf("Palette").forGetter(Schematic::getBlockPalette), (App)Codec.BYTE_BUFFER.fieldOf("BlockData").forGetter(Schematic::getBlockData), (App)Codec.list((Codec)class_2487.field_25128).optionalFieldOf("BlockEntities", (Object)ImmutableList.of()).forGetter(Schematic::getBlockEntities), (App)Codec.list((Codec)class_2487.field_25128).optionalFieldOf("Entities", (Object)ImmutableList.of()).forGetter(Schematic::getEntities)).apply((Applicative)instance, Schematic::new));
    private final int version;
    private final int dataVersion;
    private final SchematicMetadata metadata;
    private final short width;
    private final short height;
    private final short length;
    private final class_2382 offset;
    private final int paletteMax;
    private final BiMap<class_2680, Integer> blockPalette;
    private final ByteBuffer blockData;
    private List<class_2487> blockEntities;
    private List<class_2487> entities;
    private RelativeBlockSample cachedBlockSample = null;

    public Schematic(int version, int dataVersion, SchematicMetadata metadata, short width, short height, short length, class_2382 offset, int paletteMax, Map<class_2680, Integer> blockPalette, ByteBuffer blockData, List<class_2487> blockEntities, List<class_2487> entities) {
        this.version = version;
        this.dataVersion = dataVersion;
        this.metadata = metadata;
        this.width = width;
        this.height = height;
        this.length = length;
        this.offset = offset;
        this.paletteMax = paletteMax;
        this.blockPalette = HashBiMap.create(blockPalette);
        this.blockData = blockData;
        this.blockEntities = blockEntities;
        this.entities = entities;
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public class_2382 getOffset() {
        return this.offset;
    }

    public int getPaletteMax() {
        return this.paletteMax;
    }

    public BiMap<class_2680, Integer> getBlockPalette() {
        return this.blockPalette;
    }

    public ByteBuffer getBlockData() {
        return this.blockData;
    }

    public List<class_2487> getBlockEntities() {
        return this.blockEntities;
    }

    public void setBlockEntities(List<class_2487> blockEntities) {
        this.blockEntities = blockEntities.stream().map(SchematicPlacer::fixEntityId).collect(Collectors.toList());
    }

    public void setEntities(Collection<? extends class_1297> entities) {
        this.setEntities(entities.stream().map(e -> {
            class_2487 nbt = new class_2487();
            e.method_5786(nbt);
            return nbt;
        }).collect(Collectors.toList()));
    }

    public List<class_2487> getEntities() {
        return this.entities;
    }

    public void setEntities(List<class_2487> entities) {
        this.entities = entities;
    }

    public static RelativeBlockSample getBlockSample(Schematic schem) {
        if (schem.cachedBlockSample == null) {
            schem.cachedBlockSample = new RelativeBlockSample(schem);
            return schem.cachedBlockSample;
        }
        return schem.cachedBlockSample;
    }

    public static Schematic fromNbt(class_2487 nbt) {
        return (Schematic)((Pair)CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow(false, PRINT_TO_STDERR)).getFirst();
    }

    public static class_2487 toNbt(Schematic schem) {
        return (class_2487)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)schem).getOrThrow(false, PRINT_TO_STDERR);
    }

    public static Schematic fromJson(JsonObject json) {
        return (Schematic)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, PRINT_TO_STDERR)).getFirst();
    }

    public static JsonObject toJson(Schematic schem) {
        return (JsonObject)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)schem).getOrThrow(false, PRINT_TO_STDERR);
    }

    public static <T> Schematic fromDynamic(Dynamic<T> dynamic) {
        return (Schematic)CODEC.parse(dynamic).getOrThrow(false, PRINT_TO_STDERR);
    }

    public static <T> Dynamic<T> toDynamic(Schematic schem, DynamicOps<T> ops) {
        return new Dynamic(ops, CODEC.encodeStart(ops, (Object)schem).getOrThrow(false, PRINT_TO_STDERR));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("dataVersion", this.dataVersion).add("metadata", (Object)this.metadata).add("width", (int)this.width).add("height", (int)this.height).add("length", (int)this.length).add("offset", (Object)this.offset).add("paletteMax", this.paletteMax).add("blockPalette", this.blockPalette).add("blockData", (Object)this.blockData).add("blockEntities", this.blockEntities).add("entities", this.entities).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schematic schematic = (Schematic)o;
        return this.version == schematic.version && this.dataVersion == schematic.dataVersion && this.width == schematic.width && this.height == schematic.height && this.length == schematic.length && this.paletteMax == schematic.paletteMax && Objects.equals(this.metadata, schematic.metadata) && Objects.equals(this.offset, schematic.offset) && Objects.equals(this.blockPalette, schematic.blockPalette) && Objects.equals(this.blockData, schematic.blockData) && Objects.equals(this.blockEntities, schematic.blockEntities) && Objects.equals(this.entities, schematic.entities);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.dataVersion, this.metadata, this.width, this.height, this.length, this.offset, this.paletteMax, this.blockPalette, this.blockData, this.blockEntities, this.entities);
    }
}

