/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EscapeTarget
extends VirtualTarget
implements EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    private static class_5321<class_1937> targetWorldResourceKey;
    public static final Codec<EscapeTarget> CODEC;
    protected final boolean canEscapeLimbo;

    public EscapeTarget(boolean canEscapeLimbo) {
        this.canEscapeLimbo = canEscapeLimbo;
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity, Location location2) {
        if (!ModDimensions.isPocketDimension(entity.method_37908()) && !ModDimensions.isLimboDimension(entity.method_37908())) {
            return false;
        }
        if (ModDimensions.isLimboDimension(entity.method_37908()) && !this.canEscapeLimbo) {
            return false;
        }
        if (entity.method_37908().field_9236) {
            return false;
        }
        UUID uuid = entity.method_5667();
        if (uuid != null) {
            Location destLoc;
            if (entity.method_37908().method_18470(uuid) == null) {
                LOGGER.log(Level.ERROR, "Tried to get player for escape target from uuid, but player does not exist, uh oh");
                return false;
            }
            if (((class_3222)entity.method_37908().method_18470(uuid)).method_26280() != null && DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld == null && !DimensionalDoors.getConfig().getLimboConfig().escapeToWorldSpawn) {
                LOGGER.log(Level.INFO, "Sending player from limbo to their spawnpoint, good luck!");
                destLoc = new Location((class_5321<class_1937>)((class_3222)entity.method_37908().method_18470(uuid)).method_26281(), ((class_3222)entity.method_37908().method_18470(uuid)).method_26280());
            } else if (DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld != null && !DimensionalDoors.getConfig().getLimboConfig().escapeToWorldSpawn) {
                targetWorldResourceKey = DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld;
                if (DimensionalDoors.getWorld(targetWorldResourceKey) != null) {
                    LOGGER.log(Level.INFO, "Sending player from limbo to the exit dimension, good luck!");
                    destLoc = new Location(DimensionalDoors.getWorld(targetWorldResourceKey), new class_2338(entity.method_24515().method_10263(), DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorldYSpawn, entity.method_24515().method_10260()));
                } else {
                    LOGGER.log(Level.INFO, "Target dimension defined in config does not exist.  Use /forge dimensions for a list!");
                    LOGGER.log(Level.INFO, "Sending player from limbo to worldspawn, good luck!");
                    destLoc = new Location(DimensionalDoors.getServer().method_30002(), DimensionalDoors.getServer().method_30002().method_43126());
                }
            } else {
                LOGGER.log(Level.INFO, "sending player from limbo to worldspawn, good luck!");
                destLoc = new Location(DimensionalDoors.getServer().method_30002(), DimensionalDoors.getServer().method_30002().method_43126());
            }
            destLoc = EscapeTarget.randomizeLimboReturn(destLoc, DimensionalDoors.getConfig().getLimboConfig().limboReturnDistance);
            if (destLoc != null && this.canEscapeLimbo) {
                Location location = destLoc;
                entity = TeleportUtil.teleport(entity, (class_1937)location.getWorld(), location.getBlockPos(), relativeAngle, relativeVelocity);
                entity.field_6017 = -500.0f;
                location.getWorld().method_8501(location.getBlockPos(), class_2246.field_10124.method_9564());
                location.getWorld().method_8501(location.getBlockPos().method_10069(0, 1, 0), class_2246.field_10124.method_9564());
                class_5819 random = class_5819.method_43047();
                class_2338.method_25996((class_2338)location.pos.method_10069(0, -3, 0), (int)3, (int)2, (int)3).forEach(pos1 -> {
                    if (random.method_43057() < 1.0f / (float)location.pos.method_10262((class_2382)pos1) * DimensionalDoors.getConfig().getLimboConfig().limboBlocksCorruptingExitWorldAmount) {
                        class_2248 block = location.getWorld().method_8320(pos1).method_26204();
                        if (UnravelUtil.unravelBlocksMap.containsKey(block)) {
                            location.getWorld().method_8501(pos1, UnravelUtil.unravelBlocksMap.get(block).method_9564());
                        } else if (UnravelUtil.whitelistedBlocksForLimboRemoval.contains(block)) {
                            location.getWorld().method_8501(pos1, ((class_2248)ModBlocks.UNRAVELLED_FABRIC.get()).method_9564());
                        }
                    }
                });
            } else {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (class_2561)class_2561.method_43471((String)"rifts.destinations.escape.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (class_2561)class_2561.method_43471((String)"rifts.destinations.escape.rift_has_closed"));
                }
                if (ModDimensions.LIMBO_DIMENSION != null) {
                    entity = TeleportUtil.teleport(entity, (class_1937)ModDimensions.LIMBO_DIMENSION, new class_2338(this.location.getX(), this.location.getY(), this.location.getZ()), relativeAngle, relativeVelocity);
                    entity.field_6017 = -500.0f;
                }
            }
            return true;
        }
        return false;
    }

    public VirtualTarget.VirtualTargetType getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.ESCAPE.get();
    }

    @Override
    public VirtualTarget copy() {
        return new EscapeTarget(this.canEscapeLimbo);
    }

    public static Location randomizeLimboReturn(Location playerSpawn, int range) {
        return new Location(playerSpawn.getWorld(), EscapeTarget.randomizeCoord(playerSpawn.getX(), range), playerSpawn.getY(), EscapeTarget.randomizeCoord(playerSpawn.getZ(), range));
    }

    public static int randomizeCoord(int coord, int range) {
        Random random = new Random();
        int offset = random.nextInt(range + 1);
        boolean isPositive = random.nextBoolean();
        return isPositive ? coord + offset : coord - offset;
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canEscapeLimbo").forGetter(target -> target.canEscapeLimbo)).apply((Applicative)instance, EscapeTarget::new));
    }
}

