/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.GraphUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.PlayerRiftPointer;
import org.dimdev.dimdoors.rift.registry.PocketEntrancePointer;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.registry.RiftPlaceholder;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class RiftRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_NAME = "rifts";
    protected DefaultDirectedGraph<RegistryVertex, DefaultEdge> graph = new DefaultDirectedGraph(DefaultEdge.class);
    protected Map<Location, Rift> locationMap = new HashMap<Location, Rift>();
    protected Map<Pocket, PocketEntrancePointer> pocketEntranceMap = new HashMap<Pocket, PocketEntrancePointer>();
    protected Map<UUID, RegistryVertex> uuidMap = new HashMap<UUID, RegistryVertex>();
    protected Map<UUID, PlayerRiftPointer> lastPrivatePocketEntrances = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, PlayerRiftPointer> lastPrivatePocketExits = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, PlayerRiftPointer> overworldRifts = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, Location> overworldLocations = new HashMap<UUID, Location>();

    public static RiftRegistry fromNbt(Map<class_5321<class_1937>, PocketDirectory> pocketRegistry, class_2487 nbt) {
        RiftRegistry riftRegistry = new RiftRegistry();
        class_2499 riftsNBT = nbt.method_10554(DATA_NAME, 10);
        String riftTypeId = RegistryVertex.REGISTRY.getId((Object)((RegistryVertex.RegistryVertexType)RegistryVertex.RegistryVertexType.RIFT.get())).toString();
        CompletableFuture<List> futureRifts = StreamUtils.supplyAsync(() -> ((Stream)riftsNBT.parallelStream().unordered()).map(class_2487.class::cast).filter(nbtCompound -> nbtCompound.method_10558("type").equals(riftTypeId)).map(Rift::fromNbt).collect(Collectors.toList()));
        class_2499 pocketsNBT = nbt.method_10554("pockets", 10);
        CompletableFuture<List> futurePockets = StreamUtils.supplyAsync(() -> pocketsNBT.stream().map(class_2487.class::cast).map(PocketEntrancePointer::fromNbt).collect(Collectors.toList()));
        futureRifts.join().forEach(rift -> {
            riftRegistry.graph.addVertex(rift);
            riftRegistry.uuidMap.put(rift.id, (RegistryVertex)rift);
            riftRegistry.locationMap.put(rift.getLocation(), (Rift)rift);
        });
        futurePockets.join().forEach(pocket -> {
            riftRegistry.graph.addVertex(pocket);
            riftRegistry.uuidMap.put(pocket.id, (RegistryVertex)pocket);
            riftRegistry.pocketEntranceMap.put(((PocketDirectory)pocketRegistry.get(pocket.getWorld())).getPocket(pocket.getPocketId()), (PocketEntrancePointer)pocket);
        });
        class_2499 linksNBT = nbt.method_10554("links", 10);
        for (class_2520 linkNBT : linksNBT) {
            RegistryVertex from = riftRegistry.uuidMap.get(((class_2487)linkNBT).method_25926("from"));
            RegistryVertex to = riftRegistry.uuidMap.get(((class_2487)linkNBT).method_25926("to"));
            if (from == null || to == null) continue;
            riftRegistry.graph.addEdge((Object)from, (Object)to);
        }
        riftRegistry.lastPrivatePocketEntrances = riftRegistry.readPlayerRiftPointers(nbt.method_10554("last_private_pocket_entrances", 10));
        riftRegistry.lastPrivatePocketExits = riftRegistry.readPlayerRiftPointers(nbt.method_10554("last_private_pocket_exits", 10));
        riftRegistry.overworldRifts = riftRegistry.readPlayerRiftPointers(nbt.method_10554("overworld_rifts", 10));
        return riftRegistry;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        CompletableFuture<Pair> futureRiftsAndPocketsNBT = StreamUtils.supplyAsync(() -> {
            Map<Boolean, List<RegistryVertex>> vertices = ((Stream)this.graph.vertexSet().parallelStream().unordered()).filter(vertex -> vertex instanceof Rift || vertex instanceof PocketEntrancePointer).collect(Collectors.partitioningBy(Rift.class::isInstance));
            CompletableFuture<List> futureRiftsNBT = StreamUtils.supplyAsync(() -> ((List)vertices.get(true)).parallelStream().map(RegistryVertex::toNbt).collect(Collectors.toList()));
            CompletableFuture<List> futurePocketsNBT = StreamUtils.supplyAsync(() -> ((List)vertices.get(false)).parallelStream().map(RegistryVertex::toNbt).collect(Collectors.toList()));
            class_2499 riftsNBT = new class_2499();
            class_2499 pocketsNBT = new class_2499();
            riftsNBT.addAll((Collection)futureRiftsNBT.join());
            pocketsNBT.addAll((Collection)futurePocketsNBT.join());
            return new Pair((Object)riftsNBT, (Object)pocketsNBT);
        });
        CompletableFuture<class_2499> futureLinksNBT = CompletableFuture.supplyAsync(() -> {
            class_2499 linksNBT = new class_2499();
            for (DefaultEdge edge : this.graph.edgeSet()) {
                RegistryVertex from = (RegistryVertex)this.graph.getEdgeSource((Object)edge);
                RegistryVertex to = (RegistryVertex)this.graph.getEdgeTarget((Object)edge);
                class_2487 linkNBT = new class_2487();
                linkNBT.method_25927("from", from.id);
                linkNBT.method_25927("to", to.id);
                linksNBT.add((Object)linkNBT);
            }
            return linksNBT;
        });
        nbt.method_10566("last_private_pocket_entrances", (class_2520)this.writePlayerRiftPointers(this.lastPrivatePocketEntrances));
        nbt.method_10566("last_private_pocket_exits", (class_2520)this.writePlayerRiftPointers(this.lastPrivatePocketExits));
        nbt.method_10566("overworld_rifts", (class_2520)this.writePlayerRiftPointers(this.overworldRifts));
        Pair riftsAndPocketsNBT = futureRiftsAndPocketsNBT.join();
        nbt.method_10566(DATA_NAME, (class_2520)riftsAndPocketsNBT.getFirst());
        nbt.method_10566("pockets", (class_2520)riftsAndPocketsNBT.getSecond());
        nbt.method_10566("links", (class_2520)futureLinksNBT.join());
        return nbt;
    }

    private Map<UUID, PlayerRiftPointer> readPlayerRiftPointers(class_2499 nbt) {
        HashMap<UUID, PlayerRiftPointer> pointerMap = new HashMap<UUID, PlayerRiftPointer>();
        for (class_2520 entryNBT : nbt) {
            UUID player = ((class_2487)entryNBT).method_25926("player");
            UUID rift = ((class_2487)entryNBT).method_25926("rift");
            PlayerRiftPointer pointer = new PlayerRiftPointer(player);
            pointerMap.put(player, pointer);
            this.uuidMap.put(pointer.id, pointer);
            this.graph.addVertex((Object)pointer);
            this.graph.addEdge((Object)pointer, (Object)this.uuidMap.get(rift));
        }
        return pointerMap;
    }

    private class_2499 writePlayerRiftPointers(Map<UUID, PlayerRiftPointer> playerRiftPointerMap) {
        class_2499 pointers = new class_2499();
        for (Map.Entry<UUID, PlayerRiftPointer> entry : playerRiftPointerMap.entrySet()) {
            class_2487 entryNBT = new class_2487();
            entryNBT.method_25927("player", entry.getKey());
            int count = 0;
            for (DefaultEdge edge : this.graph.outgoingEdgesOf((Object)entry.getValue())) {
                entryNBT.method_25927("rift", ((RegistryVertex)this.graph.getEdgeTarget((Object)edge)).id);
                ++count;
            }
            if (count != 1) {
                throw new RuntimeException("PlayerRiftPointer points to more than one rift");
            }
            pointers.add((Object)entryNBT);
        }
        return pointers;
    }

    public boolean isRiftAt(Location location) {
        Rift possibleRift = this.locationMap.get(location);
        return possibleRift != null && !(possibleRift instanceof RiftPlaceholder);
    }

    public Rift getRift(Location location) {
        Rift rift = this.locationMap.get(location);
        if (rift == null) {
            throw new IllegalArgumentException("There is no rift registered at " + String.valueOf(location));
        }
        return rift;
    }

    private Rift getRiftOrPlaceholder(Location location) {
        Rift rift = this.locationMap.get(location);
        if (rift == null) {
            LOGGER.debug("Creating a rift placeholder at " + String.valueOf(location));
            rift = new RiftPlaceholder();
            rift.setWorld(location.world);
            rift.setLocation(location);
            this.locationMap.put(location, rift);
            this.uuidMap.put(rift.id, rift);
            this.graph.addVertex((Object)rift);
        }
        return rift;
    }

    public void addRift(Location location) {
        Rift rift;
        LOGGER.debug("Adding rift at " + String.valueOf(location));
        RegistryVertex currentRift = this.locationMap.get(location);
        if (currentRift instanceof RiftPlaceholder) {
            LOGGER.info("Converting a rift placeholder at " + String.valueOf(location) + " into a rift");
            rift = new Rift(location);
            rift.id = currentRift.id;
            GraphUtils.replaceVertex(this.graph, currentRift, rift);
        } else if (currentRift == null) {
            rift = new Rift(location);
            this.graph.addVertex((Object)rift);
        } else {
            throw new IllegalArgumentException("There is already a rift registered at " + String.valueOf(location));
        }
        this.uuidMap.put(rift.id, rift);
        this.locationMap.put(location, rift);
        rift.markDirty();
    }

    public void removeRift(Location location) {
        LOGGER.debug("Removing rift at " + String.valueOf(location));
        Rift rift = this.getRift(location);
        Set incomingEdges = this.graph.incomingEdgesOf((Object)rift);
        Set outgoingEdges = this.graph.outgoingEdgesOf((Object)rift);
        this.graph.removeVertex((Object)rift);
        this.locationMap.remove(location);
        this.uuidMap.remove(rift.id);
        for (DefaultEdge edge : incomingEdges) {
            ((RegistryVertex)this.graph.getEdgeSource((Object)edge)).targetGone(rift);
        }
        for (DefaultEdge edge : outgoingEdges) {
            ((RegistryVertex)this.graph.getEdgeTarget((Object)edge)).sourceGone(rift);
        }
    }

    private void addEdge(RegistryVertex from, RegistryVertex to) {
        this.graph.addEdge((Object)from, (Object)to);
        if (from instanceof Rift) {
            ((Rift)from).markDirty();
        }
        if (to instanceof Rift) {
            ((Rift)to).markDirty();
        }
    }

    private void removeEdge(RegistryVertex from, RegistryVertex to) {
        this.graph.removeEdge((Object)from, (Object)to);
    }

    public void addLink(Location locationFrom, Location locationTo) {
        LOGGER.debug("Adding link " + String.valueOf(locationFrom) + " -> " + String.valueOf(locationTo));
        Rift from = this.getRiftOrPlaceholder(locationFrom);
        Rift to = this.getRiftOrPlaceholder(locationTo);
        this.addEdge(from, to);
        if (!(from instanceof RiftPlaceholder) && !(to instanceof RiftPlaceholder)) {
            from.targetAdded(to);
            to.sourceAdded(from);
        }
    }

    public void removeLink(Location locationFrom, Location locationTo) {
        LOGGER.debug("Removing link " + String.valueOf(locationFrom) + " -> " + String.valueOf(locationTo));
        Rift from = this.getRift(locationFrom);
        Rift to = this.getRift(locationTo);
        this.removeEdge(from, to);
        from.targetGone(to);
        to.sourceGone(from);
    }

    public void setProperties(Location location, LinkProperties properties) {
        LOGGER.debug("Setting DungeonLinkProperties for rift at " + String.valueOf(location) + " to " + String.valueOf(properties));
        Rift rift = this.getRift(location);
        rift.setProperties(properties);
        rift.markDirty();
    }

    public Set<Location> getPocketEntrances(Pocket pocket) {
        PocketEntrancePointer pointer = this.pocketEntranceMap.get(pocket);
        if (pointer == null) {
            return Collections.emptySet();
        }
        return this.graph.outgoingEdgesOf((Object)pointer).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(Rift.class::cast).map(Rift::getLocation).collect(Collectors.toSet());
    }

    public Location getPocketEntrance(Pocket pocket) {
        Set<Location> entrances = this.getPocketEntrances(pocket);
        return entrances.stream().findFirst().orElse(null);
    }

    public void addPocketEntrance(Pocket pocket, Location location) {
        LOGGER.debug("Adding pocket entrance for pocket " + pocket.getId() + " in dimension " + String.valueOf(pocket.getWorld()) + " at " + String.valueOf(location));
        this.addEdge(this.pocketEntranceMap.computeIfAbsent(pocket, p -> {
            PocketEntrancePointer pointer = new PocketEntrancePointer(pocket.getWorld(), pocket.getId());
            pointer.setWorld(pocket.getWorld());
            this.graph.addVertex((Object)pointer);
            this.uuidMap.put(pointer.id, pointer);
            return pointer;
        }), this.getRift(location));
    }

    public Location getPrivatePocketEntrance(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.lastPrivatePocketEntrances.get(playerUUID);
        Rift entrance = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        if (entrance != null) {
            return entrance.getLocation();
        }
        return this.getPocketEntrance(DimensionalRegistry.getPrivateRegistry().getPrivatePocket(playerUUID));
    }

    private void setPlayerRiftPointer(UUID playerUUID, Location rift, Map<UUID, PlayerRiftPointer> map) {
        PlayerRiftPointer pointer = map.get(playerUUID);
        if (pointer != null) {
            this.graph.removeVertex((Object)pointer);
            map.remove(playerUUID);
            this.uuidMap.remove(pointer.id);
        }
        if (rift != null) {
            pointer = new PlayerRiftPointer(playerUUID);
            this.graph.addVertex((Object)pointer);
            map.put(playerUUID, pointer);
            this.uuidMap.put(pointer.id, pointer);
            this.addEdge(pointer, this.getRift(rift));
        }
    }

    public void setLastPrivatePocketEntrance(UUID playerUUID, Location rift) {
        LOGGER.debug("Setting last used private pocket entrance for " + String.valueOf(playerUUID) + " at " + String.valueOf(rift));
        this.setPlayerRiftPointer(playerUUID, rift, this.lastPrivatePocketEntrances);
    }

    public Location getPrivatePocketExit(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.lastPrivatePocketExits.get(playerUUID);
        Rift entrance = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        return entrance != null ? entrance.getLocation() : null;
    }

    public void setLastPrivatePocketExit(UUID playerUUID, Location rift) {
        LOGGER.debug("Setting last used private pocket exit for " + String.valueOf(playerUUID) + " at " + String.valueOf(rift));
        this.setPlayerRiftPointer(playerUUID, rift, this.lastPrivatePocketExits);
    }

    public Location getOverworldRift(UUID playerUUID) {
        return this.overworldLocations.get(playerUUID);
    }

    public void setOverworldRift(UUID playerUUID, Location rift) {
        this.overworldLocations.put(playerUUID, rift);
    }

    public Collection<Rift> getRifts() {
        return this.locationMap.values();
    }

    public Set<Location> getTargets(Location location) {
        return this.graph.outgoingEdgesOf((Object)this.getRift(location)).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(Rift.class::cast).map(rift -> rift.getLocation()).collect(Collectors.toSet());
    }

    public Set<Location> getSources(Location location) {
        return this.graph.incomingEdgesOf((Object)this.getRift(location)).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(Rift.class::cast).map(Rift::getLocation).collect(Collectors.toSet());
    }
}

