/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;

public class Rift
extends RegistryVertex {
    private static final Logger LOGGER = LogManager.getLogger();
    private Location location;
    private boolean isDetached;
    private LinkProperties properties;

    public Rift(Location location) {
        this.location = location;
        this.setWorld(location.getWorldId());
    }

    public Rift(Location location, boolean isDetached, LinkProperties properties) {
        this.location = location;
        this.isDetached = isDetached;
        this.properties = properties;
    }

    public Rift(UUID id, Location location, boolean isDetached, LinkProperties properties) {
        this.location = location;
        this.isDetached = isDetached;
        this.properties = properties;
        this.id = id;
    }

    public Rift() {
    }

    @Override
    public void sourceGone(RegistryVertex source) {
        super.sourceGone(source);
        RiftBlockEntity riftTileEntity = (RiftBlockEntity)this.location.getBlockEntity();
        if (source instanceof Rift) {
            riftTileEntity.handleSourceGone(((Rift)source).location);
        }
    }

    @Override
    public void targetGone(RegistryVertex target) {
        super.targetGone(target);
        class_2586 class_25862 = this.location.getBlockEntity();
        if (class_25862 instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)class_25862;
            if (target instanceof Rift) {
                riftBlockEntity.handleTargetGone(((Rift)target).location);
            }
            riftBlockEntity.updateColor();
        }
    }

    public void targetChanged(RegistryVertex target) {
        LOGGER.debug("Rift " + String.valueOf(this) + " notified of target " + String.valueOf(target) + " having changed. Updating color.");
        class_2586 class_25862 = this.location.getBlockEntity();
        if (class_25862 instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)class_25862;
            riftBlockEntity.updateColor();
        }
    }

    public void markDirty() {
        class_2586 class_25862 = this.location.getBlockEntity();
        if (class_25862 instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)class_25862;
            riftBlockEntity.updateColor();
        }
        for (Location location : DimensionalRegistry.getRiftRegistry().getSources(this.location)) {
            DimensionalRegistry.getRiftRegistry().getRift(location).targetChanged(this);
        }
    }

    private void updateColor() {
        class_2586 class_25862 = this.location.getBlockEntity();
        if (class_25862 instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)class_25862;
            riftBlockEntity.updateColor();
        }
    }

    @Override
    public RegistryVertex.RegistryVertexType<? extends RegistryVertex> getType() {
        return (RegistryVertex.RegistryVertexType)RegistryVertex.RegistryVertexType.RIFT.get();
    }

    public static class_2487 toNbt(Rift rift) {
        class_2487 nbt = new class_2487();
        nbt.method_25927("id", rift.id);
        nbt.method_10566("location", (class_2520)Location.toNbt(rift.location));
        nbt.method_10556("isDetached", rift.isDetached);
        if (rift.properties != null) {
            nbt.method_10566("properties", (class_2520)LinkProperties.toNbt(rift.properties));
        }
        return nbt;
    }

    public static Rift fromNbt(class_2487 nbt) {
        Rift rift = new Rift();
        rift.id = nbt.method_25926("id");
        rift.location = Location.fromNbt(nbt.method_10562("location"));
        rift.isDetached = nbt.method_10577("isDetached");
        if (nbt.method_10545("properties")) {
            rift.properties = LinkProperties.fromNbt(nbt.method_10562("properties"));
        }
        return rift;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    public void setDetached(boolean detached) {
        this.isDetached = detached;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    public void setProperties(LinkProperties properties) {
        this.properties = properties;
    }
}

