/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.rift.registry.PlayerRiftPointer;
import org.dimdev.dimdoors.rift.registry.PocketEntrancePointer;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.registry.RiftPlaceholder;

public abstract class RegistryVertex {
    public static final Registrar<RegistryVertexType<?>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("registry_vertex"), (Object[])new RegistryVertexType[0]).build();
    private class_5321<class_1937> world;
    protected UUID id = UUID.randomUUID();

    public void sourceGone(RegistryVertex source) {
    }

    public void targetGone(RegistryVertex target) {
    }

    public void sourceAdded(RegistryVertex source) {
    }

    public void targetAdded(RegistryVertex target) {
    }

    public abstract RegistryVertexType<? extends RegistryVertex> getType();

    public String toString() {
        return "RegistryVertex(dim=" + String.valueOf(this.world) + ", id=" + String.valueOf(this.id) + ")";
    }

    public static RegistryVertex fromNbt(class_2487 nbt) {
        return Objects.requireNonNull((RegistryVertexType)REGISTRY.get(new class_2960(nbt.method_10558("type")))).fromNbt(nbt);
    }

    public static class_2487 toNbt(RegistryVertex registryVertex) {
        String type = REGISTRY.getId(registryVertex.getType()).toString();
        class_2487 nbt = registryVertex.getType().toNbt(registryVertex);
        nbt.method_10582("type", type);
        return nbt;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    protected class_5321<class_1937> getWorld() {
        return this.world;
    }

    protected void setWorld(class_5321<class_1937> world) {
        this.world = world;
    }

    public static interface RegistryVertexType<T extends RegistryVertex> {
        public static final RegistrySupplier<RegistryVertexType<PlayerRiftPointer>> PLAYER = RegistryVertexType.register("player", PlayerRiftPointer::fromNbt, PlayerRiftPointer::toNbt);
        public static final RegistrySupplier<RegistryVertexType<Rift>> RIFT = RegistryVertexType.register("rift", Rift::fromNbt, Rift::toNbt);
        public static final RegistrySupplier<RegistryVertexType<PocketEntrancePointer>> ENTRANCE = RegistryVertexType.register("entrance", PocketEntrancePointer::fromNbt, PocketEntrancePointer::toNbt);
        public static final RegistrySupplier<RegistryVertexType<RiftPlaceholder>> RIFT_PLACEHOLDER = RegistryVertexType.register("rift_placeholder", RiftPlaceholder::fromNbt, RiftPlaceholder::toNbt);

        public static void register() {
        }

        public T fromNbt(class_2487 var1);

        public class_2487 toNbt(RegistryVertex var1);

        public static <T extends RegistryVertex> RegistrySupplier<RegistryVertexType<T>> register(String id, final Function<class_2487, T> fromNbt, final Function<T, class_2487> toNbt) {
            return REGISTRY.register(DimensionalDoors.id(id), () -> new RegistryVertexType<T>(){

                @Override
                public T fromNbt(class_2487 nbt) {
                    return (RegistryVertex)fromNbt.apply(nbt);
                }

                @Override
                public class_2487 toNbt(RegistryVertex registryVertex) {
                    return (class_2487)toNbt.apply(registryVertex);
                }
            });
        }
    }
}

