/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.dimdev.dimdoors.block.entity.TesselatingLoomBlockEntity;
import org.dimdev.dimdoors.recipe.ModRecipeSerializers;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.recipe.ShapedTesselatingRecipe;
import org.dimdev.dimdoors.recipe.TesselatingRecipe;

public class TesselatingShapelessRecipe
implements TesselatingRecipe {
    final class_2371<class_1856> ingredients;
    private final class_2960 id;
    final class_1799 result;
    final String group;
    final boolean showNotification;
    private final int weavingTime;

    public TesselatingShapelessRecipe(class_2960 id, String group, class_1799 result, class_2371<class_1856> ingredients, int weavingTime, boolean showNotification) {
        this.id = id;
        this.group = group;
        this.result = result;
        this.ingredients = ingredients;
        this.weavingTime = weavingTime;
        this.showNotification = showNotification;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRecipeSerializers.SHAPELESS_TESSELATING.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.SHAPELESS_TESSELATING.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @Override
    public boolean matches(TesselatingLoomBlockEntity inv, class_1937 level) {
        class_1662 stackedContents = new class_1662();
        int i = 0;
        for (int j = 0; j < inv.method_5439(); ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            stackedContents.method_20478(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.method_7402((class_1860)this, null);
    }

    @Override
    public int weavingTime() {
        return this.weavingTime;
    }

    public class_1799 assemble(TesselatingLoomBlockEntity container, class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements class_1865<TesselatingShapelessRecipe> {
        public TesselatingShapelessRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String string = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> nonNullList = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            class_1799 itemStack = ShapedTesselatingRecipe.itemStackFromJson(class_3518.method_15296((JsonObject)json, (String)"result"));
            int weavingTime = class_3518.method_15282((JsonObject)json, (String)"weavingtime", (int)200);
            boolean bl = class_3518.method_15258((JsonObject)json, (String)"show_notification", (boolean)true);
            return new TesselatingShapelessRecipe(recipeId, string, itemStack, nonNullList, weavingTime, bl);
        }

        private static class_2371<class_1856> itemsFromJson(JsonArray ingredientArray) {
            class_2371 nonNullList = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.method_8103()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public TesselatingShapelessRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String string = buffer.method_19772();
            int i = buffer.method_10816();
            class_2371 nonNullList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            nonNullList.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 itemStack = buffer.method_10819();
            int weavingTime = buffer.readInt();
            boolean bl = buffer.readBoolean();
            return new TesselatingShapelessRecipe(recipeId, string, itemStack, (class_2371<class_1856>)nonNullList, weavingTime, bl);
        }

        public void toNetwork(class_2540 buffer, TesselatingShapelessRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.result);
            buffer.writeInt(recipe.weavingTime);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

