/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractLazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.util.schematic.SchematicBlockPalette;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class ShellModifier
extends AbstractLazyModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "shell";
    private final List<Layer> layers = new ArrayList<Layer>();
    private class_3341 boxToDrawAround;

    @Override
    public class_2487 toNbtInternal(class_2487 nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        class_2499 layersNbt = new class_2499();
        for (Layer layer : this.layers) {
            layersNbt.add((Object)layer.toNbt());
        }
        nbt.method_10566("layers", (class_2520)layersNbt);
        if (this.boxToDrawAround != null) {
            nbt.method_10566("box_to_draw_around", (class_2520)BlockBoxUtil.toNbt(this.boxToDrawAround));
        }
        return nbt;
    }

    @Override
    public void applyToChunk(LazyGenerationPocket pocket, class_2791 chunk) {
        int boxExpansion = 0;
        for (Layer layer : this.layers) {
            int thickness = layer.getThickness(pocket.toVariableMap(new HashMap<String, Double>()));
            class_2680 blockState = layer.getBlockState();
            class_3341 chunkBox = BlockBoxUtil.getBox(chunk);
            class_3341 temp = class_3341.method_34390((class_2382)new class_2382(this.boxToDrawAround.method_35418() + 1 + boxExpansion, this.boxToDrawAround.method_35416() - thickness - boxExpansion, this.boxToDrawAround.method_35417() - thickness - boxExpansion), (class_2382)new class_2382(this.boxToDrawAround.method_35418() + thickness + boxExpansion, this.boxToDrawAround.method_35419() + thickness + boxExpansion, this.boxToDrawAround.method_35420() + thickness + boxExpansion));
            if (temp.method_14657(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                class_2338.method_23627((class_3341)temp).forEach(blockPos -> {
                    if (chunk.method_8320(blockPos).method_26215()) {
                        chunk.method_12010(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = class_3341.method_34390((class_2382)new class_2382(this.boxToDrawAround.method_35415() - 1 - boxExpansion, this.boxToDrawAround.method_35416() - thickness - boxExpansion, this.boxToDrawAround.method_35417() - thickness - boxExpansion), (class_2382)new class_2382(this.boxToDrawAround.method_35415() - thickness - boxExpansion, this.boxToDrawAround.method_35419() + thickness + boxExpansion, this.boxToDrawAround.method_35420() + thickness + boxExpansion))).method_14657(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                class_2338.method_23627((class_3341)temp).forEach(blockPos -> {
                    if (chunk.method_8320(blockPos).method_26215()) {
                        chunk.method_12010(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = class_3341.method_34390((class_2382)new class_2382(this.boxToDrawAround.method_35415() - boxExpansion, this.boxToDrawAround.method_35419() + 1 + boxExpansion, this.boxToDrawAround.method_35417() - thickness - boxExpansion), (class_2382)new class_2382(this.boxToDrawAround.method_35418() + boxExpansion, this.boxToDrawAround.method_35419() + thickness + boxExpansion, this.boxToDrawAround.method_35420() + thickness + boxExpansion))).method_14657(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                class_2338.method_23627((class_3341)temp).forEach(blockPos -> {
                    if (chunk.method_8320(blockPos).method_26204() instanceof class_2189) {
                        chunk.method_12010(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = class_3341.method_34390((class_2382)new class_2382(this.boxToDrawAround.method_35415() - boxExpansion, this.boxToDrawAround.method_35416() - 1 - boxExpansion, this.boxToDrawAround.method_35417() - thickness - boxExpansion), (class_2382)new class_2382(this.boxToDrawAround.method_35418() + boxExpansion, this.boxToDrawAround.method_35416() - thickness - boxExpansion, this.boxToDrawAround.method_35420() + thickness + boxExpansion))).method_14657(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                class_2338.method_23627((class_3341)temp).forEach(blockPos -> {
                    if (chunk.method_8320(blockPos).method_26215()) {
                        chunk.method_12010(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = class_3341.method_34390((class_2382)new class_2382(this.boxToDrawAround.method_35415() - boxExpansion, this.boxToDrawAround.method_35416() - boxExpansion, this.boxToDrawAround.method_35417() - 1 - boxExpansion), (class_2382)new class_2382(this.boxToDrawAround.method_35418() + boxExpansion, this.boxToDrawAround.method_35419() + boxExpansion, this.boxToDrawAround.method_35417() - thickness - boxExpansion))).method_14657(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                class_2338.method_23627((class_3341)temp).forEach(blockPos -> {
                    if (chunk.method_8320(blockPos).method_26215()) {
                        chunk.method_12010(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = class_3341.method_34390((class_2382)new class_2382(this.boxToDrawAround.method_35415() - boxExpansion, this.boxToDrawAround.method_35416() - boxExpansion, this.boxToDrawAround.method_35420() + 1 + boxExpansion), (class_2382)new class_2382(this.boxToDrawAround.method_35418() + boxExpansion, this.boxToDrawAround.method_35419() + boxExpansion, this.boxToDrawAround.method_35420() + thickness + boxExpansion))).method_14657(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                class_2338.method_23627((class_3341)temp).forEach(blockPos -> {
                    if (chunk.method_8320(blockPos).method_26215()) {
                        chunk.method_12010(blockPos, blockState, false);
                    }
                });
            }
            boxExpansion += thickness;
        }
    }

    @Override
    public Modifier fromNbt(class_2487 nbt, class_3300 manager) {
        for (class_2520 layerNbt : nbt.method_10554("layers", 10)) {
            class_2487 nbtCompound = (class_2487)layerNbt;
            try {
                Layer layer = Layer.fromNbt(nbtCompound);
                this.layers.add(layer);
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("could not parse Layer: " + String.valueOf(nbtCompound), (Throwable)e);
            }
        }
        if (nbt.method_10573("box_to_draw_around", 11)) {
            int[] box = nbt.method_10561("box_to_draw_around");
            this.boxToDrawAround = class_3341.method_34390((class_2382)new class_2382(box[0], box[1], box[2]), (class_2382)new class_2382(box[3], box[4], box[5]));
        }
        return this;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.SHELL_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Pocket pocket = manager.getPocket();
        if (pocket instanceof LazyGenerationPocket) {
            Map<String, Double> variableMap = pocket.toVariableMap(new HashMap<String, Double>());
            class_3341 pocketBox = pocket.getBox();
            this.boxToDrawAround = class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35415(), pocketBox.method_35416(), pocketBox.method_35417()), (class_2382)new class_2382(pocketBox.method_35418(), pocketBox.method_35419(), pocketBox.method_35420()));
            this.layers.forEach(layer -> pocket.expand(layer.getThickness(variableMap)));
        } else {
            this.layers.forEach(layer -> this.drawLayer((Layer)layer, manager.getPocket(), parameters.world()));
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        for (Layer layer : this.layers) {
            int thickness = layer.getThickness(variableMap);
            builder.expandExpected(new class_2382(2 * thickness, 2 * thickness, 2 * thickness));
            builder.offsetOrigin(new class_2382(thickness, thickness, thickness));
        }
    }

    private void drawLayer(Layer layer, Pocket pocket, class_3218 world) {
        int thickness = layer.getThickness(pocket.toVariableMap(new HashMap<String, Double>()));
        class_2680 blockState = layer.getBlockState();
        class_3341 pocketBox = pocket.getBox();
        class_2338.method_23627((class_3341)class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35418() + 1, pocketBox.method_35416() - thickness, pocketBox.method_35417() - thickness), (class_2382)new class_2382(pocketBox.method_35418() + thickness, pocketBox.method_35419() + thickness, pocketBox.method_35420() + thickness))).forEach(blockPos -> world.method_8501(blockPos, blockState));
        class_2338.method_23627((class_3341)class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35415() - 1, pocketBox.method_35416() - thickness, pocketBox.method_35417() - thickness), (class_2382)new class_2382(pocketBox.method_35415() - thickness, pocketBox.method_35419() + thickness, pocketBox.method_35420() + thickness))).forEach(blockPos -> world.method_8501(blockPos, blockState));
        class_2338.method_23627((class_3341)class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35415(), pocketBox.method_35419() + 1, pocketBox.method_35417() - thickness), (class_2382)new class_2382(pocketBox.method_35418(), pocketBox.method_35419() + thickness, pocketBox.method_35420() + thickness))).forEach(blockPos -> world.method_8501(blockPos, blockState));
        class_2338.method_23627((class_3341)class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35415(), pocketBox.method_35416() - 1, pocketBox.method_35417() - thickness), (class_2382)new class_2382(pocketBox.method_35418(), pocketBox.method_35416() - thickness, pocketBox.method_35420() + thickness))).forEach(blockPos -> world.method_8501(blockPos, blockState));
        class_2338.method_23627((class_3341)class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35415(), pocketBox.method_35416(), pocketBox.method_35417() - 1), (class_2382)new class_2382(pocketBox.method_35418(), pocketBox.method_35419(), pocketBox.method_35417() - thickness))).forEach(blockPos -> world.method_8501(blockPos, blockState));
        class_2338.method_23627((class_3341)class_3341.method_34390((class_2382)new class_2382(pocketBox.method_35415(), pocketBox.method_35416(), pocketBox.method_35420() + 1), (class_2382)new class_2382(pocketBox.method_35418(), pocketBox.method_35419(), pocketBox.method_35420() + thickness))).forEach(blockPos -> world.method_8501(blockPos, blockState));
        pocket.expand(thickness);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("layers", this.layers).toString();
    }

    public static class Layer {
        private final String blockStateString;
        private final String thickness;
        private Equation thicknessEquation;
        private final class_2680 blockState;

        public Layer(String blockStateString, String thickness) {
            this.blockStateString = blockStateString;
            this.thickness = thickness;
            try {
                this.thicknessEquation = Equation.parse(thickness);
            }
            catch (Equation.EquationParseException e) {
                LOGGER.error("Could not parse layer thickness equation. Defaulting to 1");
                this.thicknessEquation = Equation.newEquation(variableMap -> 1.0, stringBuilder -> stringBuilder.append(thickness));
            }
            this.blockState = (class_2680)SchematicBlockPalette.Entry.to(blockStateString).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        }

        public class_2680 getBlockState() {
            return this.blockState;
        }

        public int getThickness(Map<String, Double> variableMap) {
            return (int)this.thicknessEquation.apply(variableMap);
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("block_state", this.blockStateString);
            nbt.method_10582("thickness", this.thickness);
            return nbt;
        }

        public static Layer fromNbt(class_2487 nbt) throws CommandSyntaxException {
            return new Layer(nbt.method_10558("block_state"), nbt.method_10558("thickness"));
        }
    }
}

