/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3542;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.LocalReference;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RelativeReferenceModifier
extends AbstractModifier {
    public static final String KEY = "relative";
    private int point_a;
    private int point_b;
    private ConnectionType connection = ConnectionType.BOTH;

    @Override
    public Modifier fromNbt(class_2487 nbt, class_3300 manager) {
        this.point_a = nbt.method_10550("point_a");
        this.point_b = nbt.method_10550("point_b");
        this.connection = nbt.method_10545("connection") ? ConnectionType.fromString(nbt.method_10558("connection")) : ConnectionType.BOTH;
        return this;
    }

    @Override
    public class_2487 toNbtInternal(class_2487 nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.method_10569("point_a", this.point_a);
        nbt.method_10569("point_b", this.point_b);
        nbt.method_10582("connection", this.connection.method_15434());
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.RELATIVE_REFERENCE_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Optional<Location> riftA = manager.get(this.point_a).map(rift -> new Location((class_3218)rift.method_10997(), rift.method_11016()));
        Optional<Location> riftB = manager.get(this.point_b).map(rift -> new Location((class_3218)rift.method_10997(), rift.method_11016()));
        if (riftA.isPresent() && riftB.isPresent()) {
            RiftReference link1 = LocalReference.tryMakeRelative(riftA.get(), riftB.get());
            RiftReference link2 = LocalReference.tryMakeRelative(riftB.get(), riftA.get());
            manager.consume(this.point_a, rift -> this.addLink((RiftBlockEntity)rift, link1));
            if (this.connection == ConnectionType.BOTH) {
                manager.consume(this.point_b, rift -> this.addLink((RiftBlockEntity)rift, link2));
            }
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("point_a", this.point_a).add("point_b", this.point_b).add("connection", (Object)this.connection.method_15434()).toString();
    }

    private boolean addLink(RiftBlockEntity rift, RiftReference link) {
        rift.setDestination(link);
        return true;
    }

    public static enum ConnectionType implements class_3542
    {
        BOTH("both"),
        ONE_WAY("one_way");

        private String id;

        private ConnectionType(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        public static ConnectionType fromString(String name) {
            return "one_way".equalsIgnoreCase(name) ? ONE_WAY : BOTH;
        }
    }
}

