/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import com.google.common.collect.Multimap;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.api.util.Weighted;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.pockets.generator.ChunkGenerator;
import org.dimdev.dimdoors.pockets.generator.SchematicGenerator;
import org.dimdev.dimdoors.pockets.generator.VoidGenerator;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class PocketGenerator
implements Weighted<PocketGenerationContext>,
ReferenceSerializable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Registrar<PocketGeneratorType<? extends PocketGenerator>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("pocket_generator_type"), (Object[])new PocketGeneratorType[0]).build();
    public static final String RESOURCE_STARTING_PATH = "pockets/generator";
    private static final String defaultWeightEquation = "5";
    private static final int fallbackWeight = 5;
    protected final List<Modifier> modifierList = new ArrayList<Modifier>();
    private String resourceKey = null;
    private class_2487 builderNbt;
    protected String weight = "5";
    protected Equation weightEquation;
    protected Boolean setupLoot;
    private final List<String> tags = new ArrayList<String>();

    public PocketGenerator() {
    }

    public PocketGenerator(String weight) {
        this.weight = weight;
        this.parseWeight();
    }

    public static PocketGenerator deserialize(class_2520 nbt, class_3300 manager) {
        return switch (nbt.method_10711()) {
            case 10 -> PocketGenerator.deserialize((class_2487)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, RESOURCE_STARTING_PATH, nbt.method_10714(), ResourceUtil.NBT_READER.andThenComposable(Tag -> PocketGenerator.deserialize(Tag, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.method_23258()));
        };
    }

    public static PocketGenerator deserialize(class_2520 nbt) {
        return PocketGenerator.deserialize(nbt, null);
    }

    public static PocketGenerator deserialize(class_2487 nbt, class_3300 manager) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("type"));
        PocketGeneratorType type = (PocketGeneratorType)REGISTRY.get(id);
        if (type == null) {
            LOGGER.error("Could not deserialize PocketGenerator: " + nbt.toString());
            return null;
        }
        return type.fromNbt(nbt, manager);
    }

    public static PocketGenerator deserialize(class_2487 nbt) {
        return PocketGenerator.deserialize(nbt, null);
    }

    public static class_2520 serialize(PocketGenerator pocketGenerator, boolean allowReference) {
        return pocketGenerator.toNbt(new class_2487(), allowReference);
    }

    public static class_2520 serialize(PocketGenerator pocketGenerator) {
        return PocketGenerator.serialize(pocketGenerator, false);
    }

    private void parseWeight() {
        try {
            this.weightEquation = Equation.parse(this.weight);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error("Could not parse weight equation \"" + this.weight + "\", defaulting to default weight equation \"5\"", (Throwable)e);
            try {
                this.weightEquation = Equation.newEquation(Equation.parse(defaultWeightEquation)::apply, stringBuilder -> stringBuilder.append(this.weight));
            }
            catch (Equation.EquationParseException equationParseException) {
                LOGGER.error("Could not parse default weight equation \"5\", defaulting to fallback weight \"5\"", (Throwable)equationParseException);
                this.weightEquation = Equation.newEquation(stringDoubleMap -> 5.0, stringBuilder -> stringBuilder.append(this.weight));
            }
        }
    }

    public PocketGenerator fromNbt(class_2487 nbt, class_3300 manager) {
        int i;
        class_2499 modifiersNbt;
        if (nbt.method_10573("builder", 10)) {
            this.builderNbt = nbt.method_10562("builder");
        }
        this.weight = nbt.method_10545("weight") ? nbt.method_10558("weight") : defaultWeightEquation;
        this.parseWeight();
        if (nbt.method_10545("setup_loot")) {
            this.setupLoot = nbt.method_10577("setup_loot");
        }
        if (nbt.method_10545("modifiers")) {
            modifiersNbt = nbt.method_10554("modifiers", 10);
            for (i = 0; i < modifiersNbt.size(); ++i) {
                this.modifierList.add(Modifier.deserialize(modifiersNbt.method_10602(i), manager));
            }
        }
        if (nbt.method_10545("modifier_references")) {
            modifiersNbt = nbt.method_10554("modifier_references", 8);
            for (class_2520 Tag : modifiersNbt) {
                this.modifierList.add(Modifier.deserialize(Tag, manager));
            }
        }
        if (nbt.method_10545("tags")) {
            class_2499 nbtList = nbt.method_10554("tags", 8);
            for (i = 0; i < nbtList.size(); ++i) {
                this.tags.add(nbtList.method_10608(i));
            }
        }
        return this;
    }

    public PocketGenerator fromNbt(class_2487 nbt) {
        return this.fromNbt(nbt, null);
    }

    public class_2520 toNbt(class_2487 nbt, boolean allowReference) {
        if (allowReference && this.resourceKey != null) {
            return class_2519.method_23256((String)this.resourceKey);
        }
        return this.toNbtInternal(nbt, allowReference);
    }

    protected class_2487 toNbtInternal(class_2487 nbt, boolean allowReference) {
        this.getType().toNbt(nbt);
        if (this.builderNbt != null) {
            nbt.method_10566("builder", (class_2520)this.builderNbt);
        }
        if (!this.weight.equals(defaultWeightEquation)) {
            nbt.method_10582("weight", this.weight);
        }
        if (this.setupLoot != null) {
            nbt.method_10556("setup_loot", this.setupLoot.booleanValue());
        }
        class_2499 modifiersNbt = new class_2499();
        class_2499 modifierReferences = new class_2499();
        block4: for (Modifier modifier : this.modifierList) {
            class_2520 modNbt = modifier.toNbt(new class_2487(), allowReference);
            switch (modNbt.method_10711()) {
                case 10: {
                    modifiersNbt.add((Object)modNbt);
                    continue block4;
                }
                case 8: {
                    modifierReferences.add((Object)modNbt);
                    continue block4;
                }
            }
            throw new RuntimeException(String.format("Unexpected NbtType %d!", modNbt.method_23258()));
        }
        if (modifiersNbt.size() > 0) {
            nbt.method_10566("modifiers", (class_2520)modifiersNbt);
        }
        if (modifierReferences.size() > 0) {
            nbt.method_10566("modifier_references", (class_2520)modifierReferences);
        }
        if (this.tags.size() > 0) {
            class_2499 nbtList = new class_2499();
            for (String nbtStr : this.tags) {
                nbtList.add((Object)class_2519.method_23256((String)nbtStr));
            }
            nbt.method_10566("tags", (class_2520)nbtList);
        }
        return nbt;
    }

    public class_2520 toNbt(class_2487 nbt) {
        return this.toNbt(nbt, false);
    }

    @Override
    public void processFlags(Multimap<String, String> flags) {
        Collection reference = flags.get((Object)"reference");
        if (reference.stream().findFirst().map(string -> string.equals("local") || string.equals("global")).orElse(false).booleanValue()) {
            this.resourceKey = flags.get((Object)"resource_key").stream().findFirst().orElse(null);
        }
    }

    public abstract Pocket prepareAndPlacePocket(PocketGenerationContext var1, Pocket.PocketBuilder<?, ?> var2);

    public abstract PocketGeneratorType<? extends PocketGenerator> getType();

    public abstract String getKey();

    @Override
    public double getWeight(PocketGenerationContext parameters) {
        return this.weightEquation.apply(parameters.toVariableMap(new HashMap<String, Double>()));
    }

    public boolean isSetupLoot() {
        return this.setupLoot != null && this.setupLoot != false;
    }

    public void applyModifiers(PocketGenerationContext parameters, RiftManager manager) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, manager);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, builder);
        }
    }

    public void setup(Pocket pocket, RiftManager manager, PocketGenerationContext parameters, boolean setupLootTables) {
        class_3218 world = parameters.world();
        if (!(pocket instanceof LazyGenerationPocket) && setupLootTables) {
            pocket.getBlockEntities().forEach((blockPos, blockEntity) -> {
                class_1263 inventory;
                if (blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5442() && (blockEntity instanceof class_2595 || blockEntity instanceof class_2601)) {
                    TemplateUtils.setupLootTable(world, blockEntity, inventory, LOGGER);
                    if (inventory.method_5442()) {
                        LOGGER.error(", however Inventory is: empty!");
                    }
                }
            });
        }
        manager.getRifts().forEach(rift -> rift.getDestination().setLocation(new Location(world, rift.method_11016())));
        TemplateUtils.registerRifts(manager.getRifts(), parameters.linkTo(), parameters.linkProperties(), pocket);
    }

    public RiftManager getRiftManager(Pocket pocket) {
        return new RiftManager(pocket);
    }

    public boolean checkTags(List<String> required, List<String> blackList, boolean exact) {
        if (exact && required.size() != this.tags.size()) {
            return false;
        }
        if (required != null) {
            for (String req : required) {
                if (this.tags.contains(req)) continue;
                return false;
            }
        }
        if (blackList != null) {
            for (String black : blackList) {
                if (!this.tags.contains(black)) continue;
                return false;
            }
        }
        return true;
    }

    public Pocket.PocketBuilder<?, ?> pocketBuilder(PocketGenerationContext parameters) {
        if (this.builderNbt == null) {
            return Pocket.builder().expand(this.getSize(parameters));
        }
        AbstractPocket.AbstractPocketBuilder<?, ?> abstractBuilder = AbstractPocket.deserializeBuilder(this.builderNbt);
        if (!(abstractBuilder instanceof Pocket.PocketBuilder)) {
            return Pocket.builder().expand(this.getSize(parameters));
        }
        Pocket.PocketBuilder builder = (Pocket.PocketBuilder)abstractBuilder;
        return builder.expand(this.getSize(parameters));
    }

    public abstract class_2382 getSize(PocketGenerationContext var1);

    public static interface PocketGeneratorType<T extends PocketGenerator> {
        public static final RegistrySupplier<PocketGeneratorType<PocketGenerator>> SCHEMATIC = PocketGeneratorType.register(DimensionalDoors.id("schematic"), SchematicGenerator::new);
        public static final RegistrySupplier<PocketGeneratorType<ChunkGenerator>> CHUNK = PocketGeneratorType.register(DimensionalDoors.id("chunk"), ChunkGenerator::new);
        public static final RegistrySupplier<PocketGeneratorType<VoidGenerator>> VOID = PocketGeneratorType.register(DimensionalDoors.id("void"), VoidGenerator::new);

        public PocketGenerator fromNbt(class_2487 var1, class_3300 var2);

        public class_2487 toNbt(class_2487 var1);

        public static void register() {
        }

        public static <U extends PocketGenerator> RegistrySupplier<PocketGeneratorType<U>> register(final class_2960 id, final Supplier<U> constructor) {
            return REGISTRY.register(id, () -> new PocketGeneratorType<U>(){

                @Override
                public PocketGenerator fromNbt(class_2487 nbt, class_3300 manager) {
                    return ((PocketGenerator)constructor.get()).fromNbt(nbt, manager);
                }

                @Override
                public class_2487 toNbt(class_2487 nbt) {
                    nbt.method_10582("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

