/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class PocketTemplate {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean replacingPlaceholders = false;
    private final Schematic schematic;
    private final class_2960 id;

    public PocketTemplate(Schematic schematic, class_2960 id) {
        this.schematic = schematic;
        this.id = id;
    }

    public void place(Pocket pocket, BlockPlacementType placementType) {
        pocket.setSize(this.schematic.getWidth(), this.schematic.getHeight(), this.schematic.getLength());
        class_3218 world = DimensionalDoors.getWorld(pocket.getWorld());
        class_2338 origin = pocket.getOrigin();
        SchematicPlacer.place(this.schematic, (class_5281)world, origin, placementType);
    }

    public Map<class_2338, RiftBlockEntity> getAbsoluteRifts(Pocket pocket) {
        pocket.setSize(this.schematic.getWidth(), this.schematic.getHeight(), this.schematic.getLength());
        Map<class_2338, RiftBlockEntity> absoluteRifts = SchematicPlacer.getAbsoluteRifts(this.schematic, pocket.getOrigin());
        class_3218 world = DimensionalDoors.getWorld(pocket.getWorld());
        absoluteRifts.values().forEach(rift -> rift.setWorld((class_1937)world));
        return absoluteRifts;
    }

    public void place(LazyGenerationPocket pocket, class_2791 chunk, class_2338 originalOrigin, BlockPlacementType placementType) {
        SchematicPlacer.place(this.schematic, DimensionalDoors.getWorld(pocket.getWorld()), chunk, originalOrigin, placementType);
    }

    public static boolean isReplacingPlaceholders() {
        return false;
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    public class_2960 getId() {
        return this.id;
    }
}

