/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.virtual.reference.PocketGeneratorReference;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public final class PocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 ALL_DUNGEONS = DimensionalDoors.id("dungeon");
    public static final class_2960 NETHER_DUNGEONS = DimensionalDoors.id("nether");
    public static final class_2960 RUINS_DUNGEONS = DimensionalDoors.id("ruins");
    public static final class_2960 ATLANTIS_DUNGEONS = DimensionalDoors.id("atlantis");
    public static final class_2960 JUNGLE_DUNGEONS = DimensionalDoors.id("jungle");
    public static final class_2960 SNOW_DUNGEONS = DimensionalDoors.id("snow");
    public static final class_2960 PYRAMID_DUNGEONS = DimensionalDoors.id("pyramid");
    public static final class_2960 END_DUNGEONS = DimensionalDoors.id("end");

    public static Pocket generatePrivatePocketV2(VirtualLocation virtualLocation) {
        return PocketGenerator.generateFromPocketGroupV2(DimensionalDoors.getWorld(ModDimensions.PERSONAL), DimensionalDoors.id("private"), virtualLocation, null, null);
    }

    public static Pocket generatePublicPocketV2(VirtualLocation virtualLocation, VirtualTarget linkTo, LinkProperties linkProperties) {
        return PocketGenerator.generateFromPocketGroupV2(DimensionalDoors.getWorld(ModDimensions.PUBLIC), DimensionalDoors.id("public"), virtualLocation, linkTo, linkProperties);
    }

    public static Pocket generateFromPocketGroupV2(class_3218 world, class_2960 group, VirtualLocation virtualLocation, VirtualTarget linkTo, LinkProperties linkProperties) {
        PocketGenerationContext context = new PocketGenerationContext(world, virtualLocation, linkTo, linkProperties);
        return PocketGenerator.generatePocketV2(PocketLoader.getInstance().getGroup(group).getNextPocketGeneratorReference(context), context);
    }

    public static Pocket generateFromVirtualPocket(class_3218 world, class_2960 id, VirtualLocation virtualLocation, VirtualTarget linkTo, LinkProperties linkProperties) {
        PocketGenerationContext context = new PocketGenerationContext(world, virtualLocation, linkTo, linkProperties);
        LOGGER.info("Generating virtual target: " + String.valueOf(id));
        return PocketGenerator.generatePocketV2(PocketLoader.getInstance().getVirtual(id).getNextPocketGeneratorReference(context), context);
    }

    public static Pocket generatePocketV2(PocketGeneratorReference pocketGeneratorReference, PocketGenerationContext context) {
        return pocketGeneratorReference.prepareAndPlacePocket(context);
    }

    public static Pocket generateDungeonPocketV2(VirtualLocation virtualLocation, VirtualTarget linkTo, LinkProperties linkProperties) {
        return PocketGenerator.generateFromPocketGroupV2(DimensionalDoors.getWorld(ModDimensions.DUNGEON), DimensionalDoors.id("dungeon"), virtualLocation, linkTo, linkProperties);
    }

    public static Pocket generateDungeonPocketV2(VirtualLocation virtualLocation, VirtualTarget linkTo, LinkProperties linkProperties, class_2960 group) {
        return PocketGenerator.generateFromPocketGroupV2(DimensionalDoors.getWorld(ModDimensions.DUNGEON), group, virtualLocation, linkTo, linkProperties);
    }
}

