/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.DungeonTarget;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.rift.targets.RandomTarget;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;

public interface DefaultDungeonDestinations {
    public static final LinkProperties POCKET_LINK_PROPERTIES = LinkProperties.builder().groups(new HashSet<Integer>(Arrays.asList(0, 1))).linksRemaining(1).build();
    public static final LinkProperties OVERWORLD_LINK_PROPERTIES = LinkProperties.builder().groups(new HashSet<Integer>(Arrays.asList(0, 1))).entranceWeight(50.0f).linksRemaining(1).build();

    public static VirtualTarget getDeeperDungeonDestination() {
        return RandomTarget.builder().acceptedGroups(Collections.singleton(0)).coordFactor(1.0).negativeDepthFactor(10000.0).positiveDepthFactor(80.0).weightMaximum(100.0).noLink(false).noLinkBack(false).newRiftWeight(1.0f).build();
    }

    public static VirtualTarget getShallowerDungeonDestination() {
        return RandomTarget.builder().acceptedGroups(Collections.singleton(0)).coordFactor(1.0).negativeDepthFactor(160.0).positiveDepthFactor(10000.0).weightMaximum(100.0).newRiftWeight(1.0f).build();
    }

    public static VirtualTarget getOverworldDestination() {
        return RandomTarget.builder().acceptedGroups(Collections.singleton(0)).coordFactor(1.0).negativeDepthFactor(1.0E-11).positiveDepthFactor(Double.POSITIVE_INFINITY).weightMaximum(100.0).newRiftWeight(1.0f).build();
    }

    public static VirtualTarget getTwoWayPocketEntrance() {
        return PocketEntranceMarker.builder().weight(1.0f).ifDestination(new PocketEntranceMarker()).otherwiseDestination(RandomTarget.builder().acceptedGroups(Collections.singleton(0)).coordFactor(1.0).negativeDepthFactor(80.0).positiveDepthFactor(10000.0).weightMaximum(100.0).newRiftWeight(1.0f).build()).build();
    }

    public static VirtualTarget getGateway() {
        return DefaultDungeonDestinations.getGateway(PocketGenerator.ALL_DUNGEONS);
    }

    public static VirtualTarget getGateway(class_2960 resourceLocation) {
        return ((DungeonTarget.DungeonTargetBuilder)DungeonTarget.builder().dungeonGroup(resourceLocation).acceptedGroups((Set)Collections.singleton(0))).coordFactor(1.0).negativeDepthFactor(Double.POSITIVE_INFINITY).positiveDepthFactor(160.0).weightMaximum(300.0).newRiftWeight(1.0f).build();
    }
}

