/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network.client;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_703;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.client.CustomBreakBlockHandler;
import org.dimdev.dimdoors.mixin.client.accessor.WorldRendererAccessor;
import org.dimdev.dimdoors.network.client.ClientPacketListener;
import org.dimdev.dimdoors.network.client.ExtendedClientPlayNetworkHandler;
import org.dimdev.dimdoors.network.packet.s2c.MonolithAggroParticlesPacket;
import org.dimdev.dimdoors.network.packet.s2c.MonolithTeleportParticlesPacket;
import org.dimdev.dimdoors.network.packet.s2c.PlayerInventorySlotUpdateS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.SyncPocketAddonsS2CPacket;
import org.dimdev.dimdoors.particle.client.MonolithParticle;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler
implements ClientPacketListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_634 networkHandler;
    private static final class_5819 clientRandom = class_5819.method_43047();
    private class_5321<class_1937> pocketWorld;
    private int gridSize = 1;
    private int pocketId = Integer.MIN_VALUE;
    private int pocketRange = 1;
    private List<AutoSyncedAddon> addons = new ArrayList<AutoSyncedAddon>();

    public static void init() {
        DimensionalDoors.NETWORK.register(PlayerInventorySlotUpdateS2CPacket.class, PlayerInventorySlotUpdateS2CPacket::write, PlayerInventorySlotUpdateS2CPacket::new, PlayerInventorySlotUpdateS2CPacket::apply);
        DimensionalDoors.NETWORK.register(SyncPocketAddonsS2CPacket.class, SyncPocketAddonsS2CPacket::write, SyncPocketAddonsS2CPacket::new, SyncPocketAddonsS2CPacket::apply);
        DimensionalDoors.NETWORK.register(MonolithAggroParticlesPacket.class, MonolithAggroParticlesPacket::write, MonolithAggroParticlesPacket::new, MonolithAggroParticlesPacket::apply);
        DimensionalDoors.NETWORK.register(MonolithTeleportParticlesPacket.class, MonolithTeleportParticlesPacket::write, MonolithTeleportParticlesPacket::new, MonolithTeleportParticlesPacket::apply);
        DimensionalDoors.NETWORK.register(RenderBreakBlockS2CPacket.class, RenderBreakBlockS2CPacket::write, RenderBreakBlockS2CPacket::new, RenderBreakBlockS2CPacket::apply);
    }

    public static <T> boolean sendPacket(T packet) {
        try {
            DimensionalDoors.NETWORK.sendToServer(packet);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public ClientPacketHandler(class_634 networkHandler) {
        this.networkHandler = networkHandler;
    }

    public static ClientPacketHandler getHandler() {
        return ((ExtendedClientPlayNetworkHandler)class_310.method_1551().method_1562()).getDimDoorsPacketHandler();
    }

    public class_5321<class_1937> getPocketWorld() {
        return this.pocketWorld;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPocketId() {
        return this.pocketId;
    }

    public int getPocketRange() {
        return this.pocketRange;
    }

    public List<AutoSyncedAddon> getAddons() {
        return this.addons;
    }

    @Override
    public void onPlayerInventorySlotUpdate(PlayerInventorySlotUpdateS2CPacket packet) {
        class_310.method_1551().execute(() -> {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_31548().method_5447(packet.getSlot(), packet.getStack());
            }
        });
    }

    @Override
    public void onSyncPocketAddons(SyncPocketAddonsS2CPacket packet) {
        this.pocketWorld = packet.getWorld();
        this.gridSize = packet.getGridSize();
        this.pocketId = packet.getPocketId();
        this.pocketRange = packet.getPocketRange();
        this.addons = packet.getAddons();
    }

    @Override
    public void onMonolithAggroParticles(MonolithAggroParticlesPacket packet) {
        class_310.method_1551().execute(() -> ClientPacketHandler.spawnParticles(packet.getAggro()));
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnParticles(int aggro) {
        class_746 player = class_310.method_1551().field_1724;
        if (aggro < 120) {
            return;
        }
        int count = 10 * aggro / 250;
        for (int i = 1; i < count; ++i) {
            player.method_37908().method_8406((class_2394)class_2398.field_11214, player.method_23317() + (clientRandom.method_43058() - 0.5) * 3.0, player.method_23318() + clientRandom.method_43058() * (double)player.method_17682() - 0.75, player.method_23321() + (clientRandom.method_43058() - 0.5) * (double)player.method_17681(), (clientRandom.method_43058() - 0.5) * 2.0, -clientRandom.method_43058(), (clientRandom.method_43058() - 0.5) * 2.0);
        }
    }

    @Override
    public void onMonolithTeleportParticles(MonolithTeleportParticlesPacket packet) {
        class_310 client = class_310.method_1551();
        client.execute(() -> client.field_1713.method_3058((class_703)new MonolithParticle(client.field_1687, client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321())));
    }

    @Override
    public void onRenderBreakBlock(RenderBreakBlockS2CPacket packet) {
        CustomBreakBlockHandler.customBreakBlock(packet.getPos(), packet.getStage(), ((WorldRendererAccessor)class_310.method_1551().field_1769).getTicks());
    }
}

