/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.item.ExtendedItem;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.network.ServerPacketListener;
import org.dimdev.dimdoors.network.packet.c2s.HitBlockWithItemC2SPacket;
import org.dimdev.dimdoors.network.packet.c2s.NetworkHandlerInitializedC2SPacket;
import org.dimdev.dimdoors.network.packet.s2c.PlayerInventorySlotUpdateS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.SyncPocketAddonsS2CPacket;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;

public class ServerPacketHandler
implements ServerPacketListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_3244 networkHandler;
    private final Set<class_2960> registeredChannels = new HashSet<class_2960>();
    private boolean initialized = false;
    private class_5321<class_1937> lastSyncedPocketWorld;
    private int lastSyncedPocketId = Integer.MIN_VALUE;
    private boolean pocketSyncDirty = true;

    public static void init() {
        DimensionalDoors.NETWORK.register(NetworkHandlerInitializedC2SPacket.class, NetworkHandlerInitializedC2SPacket::write, NetworkHandlerInitializedC2SPacket::new, NetworkHandlerInitializedC2SPacket::apply);
        DimensionalDoors.NETWORK.register(HitBlockWithItemC2SPacket.class, HitBlockWithItemC2SPacket::write, HitBlockWithItemC2SPacket::new, HitBlockWithItemC2SPacket::apply);
    }

    public static ServerPacketHandler get(class_3222 player) {
        return ServerPacketHandler.get(player.field_13987);
    }

    public static ServerPacketHandler get(class_3244 networkHandler) {
        return ((ExtendedServerPlayNetworkHandler)networkHandler).getDimDoorsPacketHandler();
    }

    public static <T> boolean sendPacket(class_3222 player, T packet) {
        try {
            DimensionalDoors.NETWORK.sendToPlayer(player, packet);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public <T> boolean sendPacket(T packet) {
        return ServerPacketHandler.sendPacket(this.getPlayer(), packet);
    }

    public ServerPacketHandler(class_3244 networkHandler) {
        this.networkHandler = networkHandler;
    }

    private void unregisterReceiver(class_2960 channelName) {
        this.registeredChannels.remove(channelName);
    }

    public void unregister() {
        new HashSet<class_2960>(this.registeredChannels).forEach(this::unregisterReceiver);
    }

    public MinecraftServer getServer() {
        return ((ExtendedServerPlayNetworkHandler)this.networkHandler).dimdoorsGetServer();
    }

    public class_3222 getPlayer() {
        return this.networkHandler.field_14140;
    }

    public void syncPocketAddonsIfNeeded(class_1937 world, class_2338 pos) {
        if (!ModDimensions.isPocketDimension(world)) {
            return;
        }
        PocketDirectory directory = DimensionalRegistry.getPocketDirectory((class_5321<class_1937>)world.method_27983());
        Pocket pocket = directory.getPocketAt(pos);
        if (pocket == null) {
            return;
        }
        if (this.pocketSyncDirty || pocket.getId() != this.lastSyncedPocketId || !world.method_27983().method_29177().equals((Object)this.lastSyncedPocketWorld.method_29177())) {
            this.pocketSyncDirty = false;
            this.lastSyncedPocketId = pocket.getId();
            this.lastSyncedPocketWorld = world.method_27983();
            ServerPacketHandler.sendPacket(this.getPlayer(), new SyncPocketAddonsS2CPacket((class_5321<class_1937>)world.method_27983(), directory.getGridSize(), pocket.getId(), pocket.getRange(), pocket.getAddonsInstanceOf(AutoSyncedAddon.class)));
        }
    }

    public void markPocketSyncDirty(int id) {
        if (this.lastSyncedPocketId == id) {
            this.pocketSyncDirty = true;
        }
    }

    public void sync(class_1799 stack, class_1268 hand) {
        if (hand == class_1268.field_5810) {
            this.sendPacket(new PlayerInventorySlotUpdateS2CPacket(45, stack));
        } else {
            this.sendPacket(new PlayerInventorySlotUpdateS2CPacket(this.getPlayer().method_31548().field_7545, stack));
        }
    }

    @Override
    public void onAttackBlock(HitBlockWithItemC2SPacket packet) {
        this.getServer().execute(() -> {
            class_1792 item = this.getPlayer().method_5998(packet.getHand()).method_7909();
            if (item instanceof ExtendedItem) {
                ((ExtendedItem)item).onAttackBlock(this.getPlayer().method_37908(), (class_1657)this.getPlayer(), packet.getHand(), packet.getPos(), packet.getDirection());
            }
        });
    }

    @Override
    public void onNetworkHandlerInitialized(NetworkHandlerInitializedC2SPacket packet) {
        this.syncPocketAddonsIfNeeded(this.getPlayer().method_37908(), this.getPlayer().method_24515());
    }
}

