/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3300;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_7654;
import net.minecraft.class_7871;
import org.dimdev.dimdoors.api.util.SchematicStructureTemplate;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3485.class})
public abstract class StructureTemplateManagerMixin {
    private static final class_7654 SCHEM_LISTER = new class_7654("structures", ".schem");
    @Shadow
    private class_3300 field_25189;
    @Shadow
    @Final
    private static Logger field_15514;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList$Builder;add(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;", ordinal=2, shift=At.Shift.AFTER, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addFabricTemplateProvider(class_3300 resourceManager, class_32.class_5143 session, DataFixer dataFixer, class_7871<class_2248> blockLookup, CallbackInfo ci, ImmutableList.Builder<class_3485.class_7514> builder) {
        builder.add((Object)new class_3485.class_7514(this::loadSchemFromResource, this::listSchemResources));
    }

    private Optional<class_3499> loadSchemFromResource(class_2960 id) {
        class_2960 resourceLocation = SCHEM_LISTER.method_45112(id);
        return this.loadSchem(() -> this.field_25189.open(resourceLocation), throwable -> field_15514.error("Couldn't load structure {}", (Object)id, throwable));
    }

    private Stream<class_2960> listSchemResources() {
        return SCHEM_LISTER.method_45113(this.field_25189).keySet().stream().map(arg_0 -> ((class_7654)SCHEM_LISTER).method_45115(arg_0));
    }

    private Optional<class_3499> loadSchem(class_3485.class_7513 inputStream, Consumer<Throwable> onError) {
        Optional<class_3499> optional;
        InputStream is = null;
        try {
            is = inputStream.open();
            optional = Optional.of(this.readSchematic(is));
        }
        catch (Throwable e) {
            try {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        e.addSuppressed(throwable);
                    }
                }
                throw e;
            }
            catch (IOException ex) {
                onError.accept(ex);
                return Optional.empty();
            }
        }
        return optional;
    }

    private SchematicStructureTemplate readSchematic(InputStream is) throws IOException {
        class_2487 compoundTag = class_2507.method_10629((InputStream)is);
        return new SchematicStructureTemplate(compoundTag);
    }
}

