/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3441;
import net.minecraft.class_3445;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.UnravelledFabricBlock;
import org.dimdev.dimdoors.criteria.ModCriteria;
import org.dimdev.dimdoors.entity.limbo.LimboEntranceSource;
import org.dimdev.dimdoors.entity.stat.ModStats;
import org.dimdev.dimdoors.mixin.PlayerEntityMixin;
import org.dimdev.dimdoors.world.ModDimensions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class}, priority=900)
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin {
    @Shadow
    @Final
    private class_3441 field_13996;
    private static final float RANDOM_ACTION_CHANCE = 0.1f;
    private static final float CHANCE_TO_MAKE_LIMBO_LIKE_OTHER_DIMENSIONS = 0.1f;
    private static final int CHUNK_SIZES = 25;
    private static final int POSITION_AWAY = 50;
    private static final float RANDOM_LIQUID_CHANCE = 0.7f;
    @Unique
    class_5819 dimdoors_random = class_5819.method_43047();

    @Shadow
    public abstract void method_5749(class_2487 var1);

    @Shadow
    public abstract void method_7342(class_3445<?> var1, int var2);

    public ServerPlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void playerTickMixin(CallbackInfo ci) {
        if (this.dimdoors_random.method_43057() <= 0.1f && ModDimensions.isLimboDimension(((class_1657)this).method_37908())) {
            this.tryMakingLimboLikeOtherDimensions((class_1657)this);
        }
    }

    private boolean isValidBlockToReplace(class_1937 world, class_2338 pos) {
        return world.method_8320(pos.method_10084()).method_26215() && world.method_8320(pos).method_26204() instanceof UnravelledFabricBlock;
    }

    private void makeLimboLikeOverworld(class_1657 player) {
    }

    private void makeLimboLikeEnd(class_1657 player) {
    }

    private void makeSpotOfLiquid(class_1937 world, class_2338 pos, class_2680 state, int range) {
        class_2338.method_25996((class_2338)pos, (int)this.dimdoors_random.method_43048(range), (int)this.dimdoors_random.method_43048(range), (int)this.dimdoors_random.method_43048(range)).forEach(blockPos -> {
            if (this.isValidBlockToReplace(world, (class_2338)blockPos)) {
                world.method_8501(blockPos, state);
            }
        });
    }

    private void makeLimboLikeNether(class_1657 player) {
    }

    private void tryMakingLimboLikeOtherDimensions(class_1657 player) {
        if (this.dimdoors_random.method_43057() > 0.1f) {
            return;
        }
        switch (this.dimdoors_random.method_43048(3)) {
            case 0: {
                this.makeLimboLikeOverworld(player);
                break;
            }
            case 1: {
                this.makeLimboLikeNether(player);
                break;
            }
            case 2: {
                this.makeLimboLikeEnd(player);
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkDeathServer(class_1282 source, CallbackInfo ci) {
        this.doOnDeathStuff(source, ci);
        if (ci.isCancelled()) {
            if (ModDimensions.isPocketDimension(this.method_37908())) {
                this.method_7281(ModStats.DEATHS_IN_POCKETS);
            }
            this.method_7281(ModStats.TIMES_SENT_TO_LIMBO);
            TeleportUtil.teleportRandom(this, (class_1937)ModDimensions.LIMBO_DIMENSION, 512.0);
            LimboEntranceSource.ofDamageSource(source).broadcast((class_1657)this, this.method_5682());
        }
    }

    @Inject(method={"setRespawnPosition"}, at={@At(value="TAIL")})
    public void onSpawnPointSet(class_5321<class_1937> dimension, class_2338 pos, float angle, boolean spawnPointSet, boolean bl, CallbackInfo ci) {
        if (ModDimensions.isPocketDimension(dimension)) {
            ModCriteria.POCKET_SPAWN_POINT_SET.trigger((class_3222)this);
        }
    }
}

