/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.tag.ModBlockTags;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.decay.DecayCondition;
import org.dimdev.dimdoors.world.decay.DecayPattern;
import org.dimdev.dimdoors.world.decay.DecayResult;
import org.dimdev.dimdoors.world.decay.conditions.DimensionDecayCondition;
import org.dimdev.dimdoors.world.decay.conditions.FluidDecayCondition;
import org.dimdev.dimdoors.world.decay.conditions.SimpleDecayCondition;
import org.dimdev.dimdoors.world.decay.results.BlockDecayImplResult;
import org.dimdev.dimdoors.world.decay.results.DoubleBlockDecayResult;
import org.dimdev.dimdoors.world.decay.results.FluidDecayResult;
import org.dimdev.dimdoors.world.decay.results.NoneDecayResult;
import org.dimdev.dimdoors.world.decay.results.SelfDecayResult;
import org.slf4j.Logger;

public class LimboDecayProvider
implements class_2405 {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_7784.class_7489 decayPatternPathResolver;
    private float DEFAULT = 0.01f;

    public LimboDecayProvider(class_7784 output) {
        this.decayPatternPathResolver = output.method_45973(class_7784.class_7490.field_39367, "decay_patterns");
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        HashSet generatedDecayPatterns = Sets.newHashSet();
        ArrayList list = new ArrayList();
        BiConsumer<class_2960, JsonObject> consumer = (resourceLocation, json) -> {
            Path outputPath = this.decayPatternPathResolver.method_44107(resourceLocation);
            list.add(class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)outputPath));
        };
        this.generatePatterns(consumer);
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected void generatePatterns(BiConsumer<class_2960, JsonObject> consumer) {
        this.createPatterData(DimensionalDoors.id("air"), ModBlockTags.DECAY_TO_AIR, class_2246.field_10124).run(consumer);
        this.createPatterData(DimensionalDoors.id("gritty_stone"), ModBlockTags.DECAY_TO_GRITTY_STONE, ModBlocks.GRITTY_STONE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("leak"), class_3612.field_15910, ModBlocks.LEAK.get()).run(consumer);
        new DecayPatternData(DimensionalDoors.id("solid_static"), new DecayPattern(List.of(DimensionDecayCondition.of(ModDimensions.LIMBO_TYPE_KEY), SimpleDecayCondition.of(ModBlockTags.DECAY_TO_SOLID_STATIC)), new BlockDecayImplResult(1, this.DEFAULT, (class_2248)ModBlocks.SOLID_STATIC.get()))).run(consumer);
        new DecayPatternData(DimensionalDoors.id("black_ancient_fabric"), new DecayPattern(List.of(DimensionDecayCondition.of(ModDimensions.LIMBO_TYPE_KEY, true), SimpleDecayCondition.of((class_5321<class_2248>)class_2246.field_9987.method_40142().method_40237())), new BlockDecayImplResult(1, this.DEFAULT, (class_2248)ModBlocks.BLACK_ANCIENT_FABRIC.get()))).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_fabric"), ModBlockTags.DECAY_TO_UNRAVELED_FABRIC, ModBlocks.UNRAVELLED_FABRIC.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_fence"), ModBlockTags.DECAY_UNRAVELED_FENCE, ModBlocks.UNRAVELED_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_gate"), ModBlocks.UNRAVELED_GATE, ModBlocks.UNRAVELED_GATE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_button"), ModBlockTags.DECAY_UNRAVELED_BUTTON, ModBlocks.UNRAVELED_BUTTON.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_slab"), ModBlockTags.DECAY_UNRAVELED_SLAB, ModBlocks.UNRAVELED_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_stairs"), ModBlockTags.DECAY_UNRAVELED_STAIRS, ModBlocks.UNRAVELED_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("cobweb"), class_3481.field_15481, class_2246.field_10343).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_leaves"), class_3481.field_15503, ModBlocks.DRIFTWOOD_LEAVES.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_sapling"), class_3481.field_15462, ModBlocks.DRIFTWOOD_SAPLING.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("glass_pane"), ModBlockTags.DECAY_TO_GLASS_PANE, class_2246.field_10285).run(consumer);
        this.createPatterData(DimensionalDoors.id("moss_carpet"), class_3481.field_15479, class_2246.field_28680).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_trapdoor"), class_3481.field_15491, ModBlocks.DRIFTWOOD_TRAPDOOR.get()).run(consumer);
        this.createDoublePattern(DimensionalDoors.id("driftwood_trapdoor_door"), ModBlocks.DRIFTWOOD_DOOR.get(), (class_2248)ModBlocks.DRIFTWOOD_TRAPDOOR.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("rail"), ModBlockTags.DECAY_TO_RAIL, class_2246.field_10167).run(consumer);
        this.createPatterData(DimensionalDoors.id("rust"), ModBlockTags.DECAY_TO_RUST, ModBlocks.RUST.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("unraveled_spike"), ModBlockTags.DECAY_TO_UNRAVELED_SPIKE, ModBlocks.UNRAVELED_SPIKE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("wither_rose"), ModBlockTags.DECAY_TO_WITHER_ROSE, class_2246.field_10606).run(consumer);
        this.createPatterData(DimensionalDoors.id("water"), class_2246.field_10477, class_3612.field_15910).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay"), ModBlockTags.DECAY_TO_CLAY, class_2246.field_10460).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay_fence"), ModBlockTags.DECAY_CLAY_FENCE, ModBlocks.CLAY_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay_gate"), ModBlocks.MUD_GATE, ModBlocks.CLAY_GATE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay_wall"), class_2246.field_10269, ModBlocks.CLAY_WALL).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay_button"), ModBlocks.CLAY_BUTTON, ModBlocks.CLAY_BUTTON.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay_slab"), ModBlocks.CLAY_SLAB, ModBlocks.CLAY_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("clay_stairs"), ModBlockTags.DECAY_CLAY_STAIRS, ModBlocks.CLAY_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_sand"), ModBlockTags.DECAY_TO_DARK_SAND, ModBlocks.DARK_SAND.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_sand_fence"), ModBlocks.GRAVEL_FENCE, ModBlocks.DARK_SAND_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_sand_button"), ModBlockTags.DECAY_DARK_SAND_BUTTON, ModBlocks.DARK_SAND_BUTTON.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_sand_slab"), ModBlockTags.DECAY_DARK_SAND_SLAB, ModBlocks.DARK_SAND_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_sand_stairs"), ModBlockTags.DECAY_DARK_SAND_STAIRS, ModBlocks.DARK_SAND_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("wool"), class_2246.field_22422, class_2246.field_10446).run(consumer);
        this.createDoublePattern(DimensionalDoors.id("wool_bed"), class_3481.field_16443, class_2246.field_10446).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_door"), ModBlockTags.DECAY_TO_DRIFTWOOD_DOOR, ModBlocks.DRIFTWOOD_DOOR.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("amalgam"), ModBlockTags.DECAY_TO_AMALGAM, ModBlocks.AMALGAM_BLOCK.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("amalgam_slab"), class_2246.field_27132, ModBlocks.AMALGAM_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("amalgam_stairs"), class_2246.field_27128, ModBlocks.AMALGAM_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("mud"), ModBlockTags.DECAY_TO_MUD, class_2246.field_37576).run(consumer);
        this.createPatterData(DimensionalDoors.id("mud_fence"), ModBlockTags.DECAY_TO_MUD_FENCE, ModBlocks.MUD_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("mud_gate"), ModBlockTags.DECAY_TO_MUD_GATE, ModBlocks.MUD_GATE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("mud_button"), ModBlockTags.DECAY_TO_MUD_BUTTON, ModBlocks.MUD_BUTTON.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("mud_slab"), ModBlockTags.DECAY_TO_MUD_SLAB, ModBlocks.MUD_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("mud_stairs"), ModBlockTags.DECAY_TO_MUD_STAIRS, ModBlocks.MUD_STAIRS.get()).run(consumer);
        Stream.of(class_1767.values()).map(class_1767::method_15434).forEach(name -> {
            this.createPatterData(DimensionalDoors.id(name + "_terracotta"), this.getBlock(class_2960.method_12829((String)(name + "_glazed_terracotta"))), this.getBlock(class_2960.method_12829((String)(name + "_terracotta")))).run(consumer);
            this.createPatterData(DimensionalDoors.id(name + "_concrete_powder"), this.getBlock(class_2960.method_12829((String)(name + "_concrete_powder"))), this.getBlock(class_2960.method_12829((String)(name + "_concrete")))).run(consumer);
        });
        this.createPatterData(DimensionalDoors.id("glass"), ModBlockTags.DECAY_TO_GLASS, class_2246.field_10033).run(consumer);
        this.createPatterData(DimensionalDoors.id("gravel"), ModBlockTags.DECAY_TO_GRAVEL, class_2246.field_10255).run(consumer);
        this.createPatterData(DimensionalDoors.id("gravel_fence"), ModBlockTags.DECAY_TO_GRAVEL_FENCE, ModBlocks.GRAVEL_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("gravel_button"), ModBlockTags.DECAY_TO_GRAVEL_BUTTON, ModBlocks.GRAVEL_BUTTON.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("gravel_slab"), ModBlockTags.DECAY_TO_GRAVEL_SLAB, ModBlocks.GRAVEL_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("gravel_stairs"), ModBlockTags.DECAY_TO_GRAVEL_STAIRS, ModBlocks.GRAVEL_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("gravel_wall"), ModBlockTags.DECAY_TO_GRAVEL_WALL, ModBlocks.GRAVEL_WALL.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("red_sand"), class_2246.field_10344, class_2246.field_10534).run(consumer);
        this.createPatterData(DimensionalDoors.id("red_sand_slab"), ModBlockTags.DECAY_TO_RED_SAND_SLAB, ModBlocks.RED_SAND_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("red_sand_stairs"), ModBlockTags.DECAY_TO_RED_SAND_STAIRS, ModBlocks.RED_SAND_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("red_sand_wall"), ModBlockTags.DECAY_TO_RED_SAND_WALL, ModBlocks.RED_SAND_WALL.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("sand"), ModBlockTags.DECAY_TO_SAND, class_2246.field_10102).run(consumer);
        this.createPatterData(DimensionalDoors.id("sand_slab"), ModBlockTags.DECAY_TO_SAND_SLAB, ModBlocks.SAND_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("sand_stairs"), ModBlockTags.DECAY_TO_SAND_STAIRS, ModBlocks.SAND_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("sand_wall"), ModBlockTags.DECAY_TO_SAND_WALL, ModBlocks.SAND_WALL.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("soul_sand"), class_2246.field_22090, class_2246.field_10114).run(consumer);
        this.createSimplePattern(DimensionalDoors.id("ice"), class_2246.field_10225, class_2246.field_10295).run(consumer);
        this.createSimplePattern(DimensionalDoors.id("iron_block"), class_2246.field_10535, class_2246.field_10085).run(consumer);
        this.createOxidizationChain(class_2246.field_27119, class_2246.field_27118, class_2246.field_27117, class_2246.field_27116, consumer);
        this.createOxidizationChain(class_2246.field_27124, class_2246.field_27123, class_2246.field_27122, class_2246.field_27121, consumer);
        this.createOxidizationChain(class_2246.field_27132, class_2246.field_27131, class_2246.field_27130, class_2246.field_27129, consumer);
        this.createOxidizationChain(class_2246.field_27128, class_2246.field_27127, class_2246.field_27126, class_2246.field_27125, consumer);
        this.createPatterData(DimensionalDoors.id("ancient_debris"), class_2246.field_22108, class_2246.field_22109).run(consumer);
        this.createPatterData(DimensionalDoors.id("dirt"), ModBlockTags.DECAY_TO_DIRT, class_2246.field_10566).run(consumer);
        this.createPatterData(DimensionalDoors.id("crimson_nylium"), class_2246.field_22113, class_2246.field_22120).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_plank"), ModBlockTags.DECAY_TO_DRIFTWOOD_PLANK, ModBlocks.DRIFTWOOD_PLANKS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_fence"), ModBlockTags.DECAY_TO_DRIFTWOOD_FENCE, ModBlocks.DRIFTWOOD_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_gate"), ModBlockTags.DECAY_TO_DRIFTWOOD_GATE, ModBlocks.DRIFTWOOD_GATE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_button"), ModBlockTags.DECAY_TO_DRIFTWOOD_BUTTON, ModBlocks.DRIFTWOOD_BUTTON.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_slab"), ModBlockTags.DECAY_TO_DRIFTWOOD_SLAB, ModBlocks.DRIFTWOOD_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_stairs"), ModBlockTags.DECAY_TO_DRIFTWOOD_STAIRS, ModBlocks.DRIFTWOOD_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("composter"), class_2246.field_16328, class_2246.field_17563).run(consumer);
        this.createPatterData(DimensionalDoors.id("chest"), ModBlockTags.DECAY_TO_CHEST, class_2246.field_10034).run(consumer);
        this.createPatterData(DimensionalDoors.id("bone_block"), class_2246.field_10502, class_2246.field_10166).run(consumer);
        this.createPatterData(DimensionalDoors.id("skeleton_skull"), ModBlockTags.DECAY_TO_SKELETON_SKULL, class_2246.field_10481).run(consumer);
        this.createPatterData(DimensionalDoors.id("skeleton_wall_skull"), ModBlockTags.DECAY_TO_SKELETON_WALL_SKULL, class_2246.field_10388).run(consumer);
        this.createPatterData(DimensionalDoors.id("bamboo"), class_2246.field_16492, class_2246.field_10211).run(consumer);
        this.createPatterData(DimensionalDoors.id("pumpkin"), class_2246.field_10147, class_2246.field_10261).run(consumer);
        this.createPatterData(DimensionalDoors.id("slime_block"), class_2246.field_21211, class_2246.field_10030).run(consumer);
        this.createPatterData(DimensionalDoors.id("honeycomb_block"), class_2246.field_10258, class_2246.field_21212).run(consumer);
        this.createPatterData(DimensionalDoors.id("lectern"), class_2246.field_10504, class_2246.field_16330).run(consumer);
        this.createPatterData(DimensionalDoors.id("piston"), class_2246.field_10615, class_2246.field_10560).run(consumer);
        this.createPatterData(DimensionalDoors.id("netherwart_block"), ModBlockTags.DECAY_TO_NETHERWART_BLOCK, class_2246.field_10541).run(consumer);
        this.createPatterData(DimensionalDoors.id("redstone_lamp"), class_2246.field_10327, class_2246.field_10524).run(consumer);
        this.createPatterData(DimensionalDoors.id("amalgam_ore"), ModBlockTags.DECAY_TO_AMALGAM_ORE, ModBlocks.AMALGAM_ORE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("clod_ore"), ModBlockTags.DECAY_TO_CLOD_ORE, ModBlocks.CLOD_ORE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("cobblestone"), ModBlockTags.DECAY_TO_COBBLESTONE, class_2246.field_10445).run(consumer);
        this.createPatterData(DimensionalDoors.id("cobblestone_slab"), ModBlockTags.DECAY_TO_COBBLESTONE_SLAB, class_2246.field_10351).run(consumer);
        this.createPatterData(DimensionalDoors.id("cobblestone_stairs"), ModBlockTags.DECAY_TO_COBBLESTONE_STAIRS, class_2246.field_10596).run(consumer);
        this.createPatterData(DimensionalDoors.id("cobblestone_wall"), ModBlockTags.DECAY_TO_COBBLESTONE_WALL, class_2246.field_10625).run(consumer);
        this.createPatterData(DimensionalDoors.id("red_sandstone"), ModBlockTags.DECAY_TO_RED_SANDSTONE, class_2246.field_10344).run(consumer);
        this.createPatterData(DimensionalDoors.id("red_sandstone"), ModBlockTags.DECAY_TO_SANDSTONE, class_2246.field_9979).run(consumer);
        this.createPatterData(DimensionalDoors.id("packed_ice"), class_2246.field_10384, class_2246.field_10225).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_wood"), ModBlockTags.DECAY_TO_DRIFTWOOD_WOOD, ModBlocks.DRIFTWOOD_WOOD.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("driftwood_log"), ModBlockTags.DECAY_TO_DRIFTWOOD_LOG, ModBlocks.DRIFTWOOD_LOG.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("barrel"), class_2246.field_20422, class_2246.field_16328).run(consumer);
        this.createPatterData(DimensionalDoors.id("carved_pumpkin"), class_2246.field_10009, class_2246.field_10147).run(consumer);
        this.createPatterData(DimensionalDoors.id("sponge"), class_2246.field_10562, class_2246.field_10258).run(consumer);
        this.createPatterData(DimensionalDoors.id("coal_ore"), class_2246.field_10442, class_2246.field_10418).run(consumer);
        this.createPatterData(DimensionalDoors.id("andesite"), class_2246.field_10093, class_2246.field_10115).run(consumer);
        this.createPatterData(DimensionalDoors.id("andesite_slab"), class_2246.field_10322, class_2246.field_10016).run(consumer);
        this.createPatterData(DimensionalDoors.id("andesite_stairs"), class_2246.field_9994, class_2246.field_10386).run(consumer);
        this.createPatterData(DimensionalDoors.id("basalt"), ModBlockTags.DECAY_TO_BASALT, class_2246.field_22091).run(consumer);
        this.createPatterData(DimensionalDoors.id("basalt_lava"), class_3612.field_15908, class_2246.field_22091).run(consumer);
        this.createPatterData(DimensionalDoors.id("blackstone"), ModBlockTags.DECAY_TO_BLACKSTONE, class_2246.field_23869).run(consumer);
        this.createPatterData(DimensionalDoors.id("blackstone_slab"), ModBlockTags.DECAY_TO_BLACKSTONE_SLAB, class_2246.field_23872).run(consumer);
        this.createPatterData(DimensionalDoors.id("blackstone_stairs"), ModBlockTags.DECAY_TO_BLACKSTONE_STAIRS, class_2246.field_23870).run(consumer);
        this.createPatterData(DimensionalDoors.id("blackstone_wall"), ModBlockTags.DECAY_TO_BLACKSTONE_WALL, class_2246.field_23871).run(consumer);
        this.createPatterData(DimensionalDoors.id("deepslate"), ModBlockTags.DECAY_TO_DEEPSLATE, class_2246.field_28888).run(consumer);
        this.createPatterData(DimensionalDoors.id("deepslate_slab"), ModBlockTags.DECAY_TO_DEEPSLATE_SLAB, ModBlocks.DEEPSLATE_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("deepslate_stairs"), ModBlockTags.DECAY_TO_DEEPSLATE_STAIRS, ModBlocks.DEEPSLATE_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("deepslate_wall"), ModBlockTags.DECAY_TO_DEEPSLATE_WALL, ModBlocks.DEEPSLATE_WALL.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("diorite"), ModBlockTags.DECAY_TO_DIORITE, class_2246.field_10508).run(consumer);
        this.createPatterData(DimensionalDoors.id("diorite_slab"), ModBlockTags.DECAY_TO_DIORITE_SLAB, class_2246.field_10507).run(consumer);
        this.createPatterData(DimensionalDoors.id("diorite_stairs"), ModBlockTags.DECAY_TO_DIORITE_STAIRS, class_2246.field_10216).run(consumer);
        this.createPatterData(DimensionalDoors.id("diorite_wall"), ModBlockTags.DECAY_TO_DIORITE_WALL, class_2246.field_10517).run(consumer);
        this.createPatterData(DimensionalDoors.id("endstone"), ModBlockTags.DECAY_TO_ENDSTONE, class_2246.field_10471).run(consumer);
        this.createPatterData(DimensionalDoors.id("endstone_slab"), ModBlockTags.DECAY_TO_ENDSTONE_SLAB, ModBlocks.END_STONE_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("endstone_stairs"), ModBlockTags.DECAY_TO_ENDSTONE_STAIRS, ModBlocks.END_STONE_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("endstone_wall"), ModBlockTags.DECAY_TO_ENDSTONE_WALL, ModBlocks.END_STONE_WALL.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("furnace"), ModBlockTags.DECAY_TO_FURNACE, class_2246.field_10181).run(consumer);
        this.createPatterData(DimensionalDoors.id("granite"), ModBlockTags.DECAY_TO_GRANITE, class_2246.field_10474).run(consumer);
        this.createPatterData(DimensionalDoors.id("granite_slab"), ModBlockTags.DECAY_TO_GRANITE_SLAB, class_2246.field_10189).run(consumer);
        this.createPatterData(DimensionalDoors.id("granite_stairs"), ModBlockTags.DECAY_TO_GRANITE_STAIRS, class_2246.field_10607).run(consumer);
        this.createPatterData(DimensionalDoors.id("granite"), ModBlockTags.DECAY_TO_GRANITE, class_2246.field_10474).run(consumer);
        this.createPatterData(DimensionalDoors.id("granite_slab"), ModBlockTags.DECAY_TO_GRANITE_SLAB, class_2246.field_10189).run(consumer);
        this.createPatterData(DimensionalDoors.id("granite_stairs"), ModBlockTags.DECAY_TO_GRANITE_STAIRS, class_2246.field_10607).run(consumer);
        this.createPatterData(DimensionalDoors.id("netherrack"), ModBlockTags.NETHERRACK, class_2246.field_10515).run(consumer);
        this.createPatterData(DimensionalDoors.id("netherrack_fence"), ModBlockTags.NETHERRACK_FENCE, ModBlocks.NETHERRACK_FENCE.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("netherrack_slab"), ModBlockTags.NETHERRACK_SLAB, ModBlocks.NETHERRACK_SLAB.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("netherrack_stairs"), ModBlockTags.NETHERRACK_STAIRS, ModBlocks.NETHERRACK_STAIRS.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("netherrack_wall"), ModBlockTags.NETHERRACK_WALL, ModBlocks.NETHERRACK_WALL.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("prismarine"), ModBlockTags.DECAY_TO_PRISMARINE, class_2246.field_10135).run(consumer);
        this.createPatterData(DimensionalDoors.id("prismarine_slab"), ModBlockTags.DECAY_TO_PRISMARINE_SLAB, class_2246.field_10389).run(consumer);
        this.createPatterData(DimensionalDoors.id("prismarine_stairs"), ModBlockTags.DECAY_TO_PRISMARINE_STAIRS, class_2246.field_10350).run(consumer);
        this.createPatterData(DimensionalDoors.id("prismarine_wall"), ModBlockTags.DECAY_TO_PRISMARINE_WALL, class_2246.field_10530).run(consumer);
        this.createPatterData(DimensionalDoors.id("stone"), ModBlockTags.DECAY_TO_STONE, class_2246.field_10340).run(consumer);
        this.createPatterData(DimensionalDoors.id("lava"), class_2246.field_10092, class_3612.field_15908);
        this.createPatterData(DimensionalDoors.id("dropper"), class_2246.field_10200, class_2246.field_10228);
        this.createPatterData(DimensionalDoors.id("dark_prismarine"), ModBlockTags.DECAY_TO_DARK_PRISMARINE, class_2246.field_10297).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_prismarine_slab"), ModBlockTags.DECAY_TO_DARK_PRISMARINE_SLAB, class_2246.field_10623).run(consumer);
        this.createPatterData(DimensionalDoors.id("dark_prismarine_stairs"), ModBlockTags.DECAY_TO_DARK_PRISMARINE_STAIRS, class_2246.field_10130).run(consumer);
        this.createPatterData(DimensionalDoors.id("clod_block"), ModBlockTags.DECAY_TO_CLOD_BLOCK, ModBlocks.CLOD_BLOCK.get()).run(consumer);
        this.createPatterData(DimensionalDoors.id("cracked_stone_brick"), class_2246.field_10416, class_2246.field_10056).run(consumer);
        this.createPatterData(DimensionalDoors.id("obsidian"), ModBlockTags.DECAY_TO_OBSIDIAN, class_2246.field_10540).run(consumer);
        this.createPatterData(DimensionalDoors.id("stone_brick"), ModBlockTags.DECAY_TO_STONE_BRICKS, class_2246.field_10056).run(consumer);
        this.createPatterData(DimensionalDoors.id("stone_brick_slab"), ModBlockTags.DECAY_TOSTONE_BRICK_SLAB, class_2246.field_10131).run(consumer);
        this.createPatterData(DimensionalDoors.id("stone_brick_stairs"), ModBlockTags.DECAY_TOSTONE_BRICK_STAIRS, class_2246.field_10392).run(consumer);
        this.createPatterData(DimensionalDoors.id("stone_brick_wall"), ModBlockTags.DECAY_TOSTONE_BRICK_WALL, class_2246.field_10252).run(consumer);
        this.createPatterData(DimensionalDoors.id("crying_obsidian"), class_2246.field_23152, class_2246.field_22423).run(consumer);
    }

    public DecayPatternData createPatterData(class_2960 id, Object before, Object after) {
        return new DecayPatternData(id, new DecayPattern(List.of(this.getPredicate(before)), this.getProcessor(after)));
    }

    private DecayCondition getPredicate(Object object) {
        if (object instanceof class_6862) {
            class_6862 tag = (class_6862)object;
            if (tag.method_41007(class_7924.field_41254)) {
                return SimpleDecayCondition.of((class_6862<class_2248>)tag);
            }
            if (tag.method_41007(class_7924.field_41270)) {
                return FluidDecayCondition.of((class_6862<class_3611>)tag);
            }
            if (tag.method_41007(class_7924.field_41241)) {
                return DimensionDecayCondition.of((class_6862<class_2874>)tag);
            }
        } else if (object instanceof class_5321) {
            class_5321 key = (class_5321)object;
            if (key.method_31163(class_7924.field_41254)) {
                return SimpleDecayCondition.of((class_5321<class_2248>)key);
            }
            if (key.method_31163(class_7924.field_41270)) {
                return FluidDecayCondition.of((class_5321<class_3611>)key);
            }
            if (key.method_31163(class_7924.field_41241)) {
                return DimensionDecayCondition.of((class_5321<class_2874>)key);
            }
        }
        return DecayCondition.NONE;
    }

    private DecayResult getProcessor(Object object) {
        return this.getProcessor(object, 1);
    }

    private DecayResult getProcessor(Object object, int entropy) {
        if (object instanceof class_2248) {
            class_2248 block = (class_2248)object;
            return new BlockDecayImplResult(entropy, this.DEFAULT, block);
        }
        if (object instanceof class_3611) {
            class_3611 fluid = (class_3611)object;
            return new FluidDecayResult(entropy, this.DEFAULT, fluid);
        }
        return NoneDecayResult.instance();
    }

    private void createOxidizationChain(class_2248 regular, class_2248 exposed, class_2248 weathered, class_2248 oxidized, BiConsumer<class_2960, JsonObject> consumer) {
        Function<class_2248, class_2248> waxed = block -> {
            class_2960 id = this.getId((class_2248)block);
            return this.getBlock(new class_2960(id.method_12836(), "waxed_" + id.method_12832()));
        };
        Function<class_2248, class_2960> id = block -> new class_2960("dimdoors:" + this.getId((class_2248)block).method_12832());
        class_2248 regularWaxed = waxed.apply(regular);
        class_2248 exposedWaxed = waxed.apply(exposed);
        class_2248 weatheredWaxed = waxed.apply(weathered);
        class_2248 oxidizedWaxed = waxed.apply(oxidized);
        this.createPatterData(id.apply(weathered), oxidized, weathered).run(consumer);
        this.createPatterData(id.apply(exposed), weathered, exposed).run(consumer);
        this.createPatterData(id.apply(regular), exposed, regular).run(consumer);
        this.createPatterData(id.apply(regularWaxed), regularWaxed, regular);
        this.createPatterData(id.apply(exposedWaxed), exposedWaxed, exposed);
        this.createPatterData(id.apply(weathered), weatheredWaxed, weathered);
        this.createPatterData(id.apply(oxidizedWaxed), oxidizedWaxed, oxidized);
    }

    private class_2248 getBlock(class_2960 id) {
        return (class_2248)class_7923.field_41175.method_10223(id);
    }

    private class_2960 getId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    private DecayPatternData turnIntoSelf(class_2960 ResourceLocation, Object before) {
        return new DecayPatternData(ResourceLocation, new DecayPattern(List.of(this.getPredicate(before)), SelfDecayResult.instance()));
    }

    public String method_10321() {
        return "Limbo Decay";
    }

    private static Path getOutput(Path rootOutput, class_2960 lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.method_12836() + "/decay_patterns/" + lootTableId.method_12832() + ".json");
    }

    public DecayPatternData createSimplePattern(class_2960 id, Object before, Object after) {
        return new DecayPatternData(id, new DecayPattern(List.of(this.getPredicate(before)), this.getProcessor(after, 1)));
    }

    public DecayPatternData createDoublePattern(class_2960 id, Object before, class_2248 after) {
        return new DecayPatternData(id, new DecayPattern(List.of(this.getPredicate(before)), new DoubleBlockDecayResult(1, this.DEFAULT, after)));
    }

    public record DecayPatternData(class_2960 id, DecayPattern pattern) {
        public void run(BiConsumer<class_2960, JsonObject> consumer) {
            JsonElement object = (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder(DecayPattern.CODEC).apply(this.pattern)).getOrThrow(false, arg_0 -> ((Logger)class_2405.field_40831).error(arg_0));
            consumer.accept(this.id, object.getAsJsonObject());
        }
    }
}

