/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.compat.rei.tesselating;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.dimdev.dimdoors.compat.rei.TesselatingReiCompatClient;
import org.dimdev.dimdoors.compat.rei.tesselating.DefaultTesselatingShapedDisplay;
import org.dimdev.dimdoors.compat.rei.tesselating.DefaultTesselatingShapelessDisplay;
import org.dimdev.dimdoors.recipe.ShapedTesselatingRecipe;
import org.dimdev.dimdoors.recipe.TesselatingShapelessRecipe;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultTesselatingDisplay<C extends class_1860<?>>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<C> recipe;
    private final int weavingTime;

    public DefaultTesselatingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<C> recipe, int weavingTime) {
        this(inputs, outputs, recipe.map(class_1860::method_8114), recipe, weavingTime);
    }

    public DefaultTesselatingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, Optional<C> recipe, int weavingTime) {
        super(inputs, outputs, location);
        this.recipe = recipe;
        this.weavingTime = weavingTime;
    }

    @Nullable
    public static DefaultTesselatingDisplay<?> of(class_1860<?> recipe) {
        if (recipe instanceof TesselatingShapelessRecipe) {
            return new DefaultTesselatingShapelessDisplay((TesselatingShapelessRecipe)recipe);
        }
        if (recipe instanceof ShapedTesselatingRecipe) {
            return new DefaultTesselatingShapedDisplay((ShapedTesselatingRecipe)recipe);
        }
        return null;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return TesselatingReiCompatClient.TESSELATING;
    }

    public Optional<C> getOptionalRecipe() {
        return this.recipe;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.getOptionalRecipe().map(class_1860::method_8114);
    }

    public <T extends class_1703> List<List<class_1799>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultTesselatingDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap((Iterable)ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends class_1703> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(DefaultTesselatingDisplay.getSlotWithSize(this, i, menuWidth), (EntryIngredient)this.getInputEntries().get(i));
        }
        return list;
    }

    public boolean isShapeless() {
        return false;
    }

    public static int getSlotWithSize(DefaultTesselatingDisplay<?> display, int index, int craftingGridWidth) {
        return DefaultTesselatingDisplay.getSlotWithSize(display.getInputWidth(craftingGridWidth, 3), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        int craftingWidth = 3;
        int craftingHeight = 3;
        if (info instanceof SimpleGridMenuInfo && fill) {
            craftingWidth = ((SimpleGridMenuInfo)info).getCraftingWidth(context.getMenu());
            craftingHeight = ((SimpleGridMenuInfo)info).getCraftingHeight(context.getMenu());
        }
        return this.getInputIngredients(craftingWidth, craftingHeight);
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
        return this.getInputIngredients(3, 3);
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = this.getInputWidth(craftingWidth, craftingHeight);
        int inputHeight = this.getInputHeight(craftingWidth, craftingHeight);
        HashMap<IntIntImmutablePair, InputIngredient> grid = new HashMap<IntIntImmutablePair, InputIngredient>();
        List inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient stacks = (EntryIngredient)inputEntries.get(i);
            if (stacks.isEmpty()) continue;
            int index = DefaultTesselatingDisplay.getSlotWithSize(inputWidth, i, craftingWidth);
            int x = i % inputWidth;
            int y = i / inputWidth;
            grid.put(new IntIntImmutablePair(x, y), InputIngredient.of((int)index, (int)(3 * y + x), (List)stacks));
        }
        ArrayList list = new ArrayList(craftingWidth * craftingHeight);
        int n = craftingWidth * craftingHeight;
        for (int i = 0; i < n; ++i) {
            list.add(InputIngredient.empty((int)i));
        }
        for (int x = 0; x < craftingWidth; ++x) {
            for (int y = 0; y < craftingHeight; ++y) {
                InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                if (ingredient == null) continue;
                int index = craftingWidth * y + x;
                list.set(index, ingredient);
            }
        }
        return list;
    }

    public int getWeavingTime() {
        return this.weavingTime;
    }
}

