/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.dimdev.dimdoors.api.util.Path;
import org.dimdev.dimdoors.api.util.SimpleTree;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.PocketTemplate;

public class PocketTemplateArgumentType
implements ArgumentType<PocketTemplate> {
    public static final DynamicCommandExceptionType UNKNOWN_POCKET_TEMPLATE = new DynamicCommandExceptionType(s -> class_2561.method_43469((String)"commands.pocket.unknownPocketTemplate", (Object[])new Object[]{s}));

    public PocketTemplate parse(StringReader reader) throws CommandSyntaxException {
        String strValue = reader.readString();
        Path<String> value = Path.stringPath(strValue);
        if (!this.getPocketTemplates().containsKey(value)) {
            throw UNKNOWN_POCKET_TEMPLATE.create((Object)value.toString());
        }
        return this.getPocketTemplates().get(value);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return StreamUtils.execute(() -> this.getPocketTemplates().keySet().parallelStream().map(path -> path.reduce(String::concat)).filter(Optional::isPresent).map(Optional::get).map(id -> "\"" + id + "\"").collect(Collectors.toCollection(TreeSet::new)));
    }

    private SimpleTree<String, PocketTemplate> getPocketTemplates() {
        return PocketLoader.getInstance().getTemplates();
    }

    public static PocketTemplate getValue(CommandContext<?> context, String name) {
        return (PocketTemplate)context.getArgument(name, PocketTemplate.class);
    }
}

