/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_4588;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.client.RiftCurves;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class RiftCrackRenderer {
    public static void drawCrack(Matrix4f model, class_4588 vc, float riftRotation, RiftCurves.PolygonInfo poly, double size, long riftRandom) {
        double scale = size / (double)(poly.maxX - poly.minX);
        double offsetX = (double)(poly.maxX + poly.minX) / 2.0;
        double offsetY = (double)(poly.maxY + poly.minY) / 2.0;
        double offsetZ = 0.0;
        float motionMagnitude = 0.6f;
        float motionSpeed = 0.014f;
        int jCount = 10;
        float time = (float)((class_156.method_659() + riftRandom) % 2000000L) * motionSpeed;
        double[] jitters = new double[jCount];
        double jitterScale = DimensionalDoors.getConfig().getGraphicsConfig().riftJitter * size * size * size / 2000.0;
        double xJitter = jitterScale * Math.sin((double)(1.1f * time) * size) * Math.sin(0.8f * time);
        double yJitter = jitterScale * Math.sin((double)(1.2f * time) * size) * Math.sin(0.9f * time);
        double zJitter = jitterScale * Math.sin((double)(1.3f * time) * size) * Math.sin(0.7f * time);
        for (int i = 0; i < jCount; ++i) {
            jitters[i] = Math.sin((1.0f + (float)i / 10.0f) * time) * Math.cos(1.0f - (float)i / 10.0f * time) * (double)motionMagnitude;
        }
        ArrayList<RiftCurves.Point> points = poly.points;
        int pointsSize = points.size();
        for (int i = 0; i < pointsSize; i += 3) {
            RiftCurves.Point p = points.get(i);
            RiftCrackRenderer.renderPoint(vc, model, points.get(i + 0), jCount, offsetX, offsetY, offsetZ, xJitter, yJitter, zJitter, scale, riftRotation, jitters, false);
            RiftCrackRenderer.renderPoint(vc, model, points.get(i + 1), jCount, offsetX, offsetY, offsetZ, xJitter, yJitter, zJitter, scale, riftRotation, jitters, false);
            RiftCrackRenderer.renderPoint(vc, model, points.get(i + 2), jCount, offsetX, offsetY, offsetZ, xJitter, yJitter, zJitter, scale, riftRotation, jitters, true);
        }
    }

    public static void renderPoint(class_4588 vc, Matrix4f model, RiftCurves.Point p, int jCount, double offsetX, double offsetY, double offsetZ, double xJitter, double yJitter, double zJitter, double scale, double riftRotation, double[] jitters, boolean twice) {
        int jIndex = Math.abs((p.x + p.y) * (p.x + p.y + 1) / 2 + p.y);
        double x = ((double)p.x + jitters[(jIndex + 1) % jCount] - offsetX) * Math.cos(Math.toRadians(riftRotation)) - jitters[(jIndex + 2) % jCount] * Math.sin(Math.toRadians(riftRotation));
        double y = (double)p.y + jitters[jIndex % jCount] - offsetY;
        double z = ((double)p.x + jitters[(jIndex + 2) % jCount] - offsetZ) * Math.sin(Math.toRadians(riftRotation)) + jitters[(jIndex + 2) % jCount] * Math.cos(Math.toRadians(riftRotation));
        vc.method_22918(model, (float)((x *= scale) + xJitter), (float)((y *= scale) + yJitter), (float)((z *= scale) + zJitter)).method_22915(0.08f, 0.08f, 0.08f, 0.3f).method_22913(0.0f, 0.0f).method_22922(0).method_22916(0).method_22914(0.0f, 0.0f, 0.0f).method_1344();
        if (twice) {
            vc.method_22918(model, (float)(x + xJitter), (float)(y + yJitter), (float)(z + zJitter)).method_22915(0.08f, 0.08f, 0.08f, 0.3f).method_22913(0.0f, 0.0f).method_22922(0).method_22916(0).method_22914(0.0f, 0.0f, 0.0f).method_1344();
        }
    }
}

