/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.client.DefaultTransformation;
import org.dimdev.dimdoors.api.client.Transformer;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;
import org.dimdev.dimdoors.block.CoordinateTransformerBlock;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.item.RiftKeyItem;
import org.dimdev.dimdoors.pockets.DefaultDungeonDestinations;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EntranceRiftBlockEntity
extends RiftBlockEntity<DimensionalDoorBlock> {
    private static final EscapeTarget ESCAPE_TARGET = new EscapeTarget(true);
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean locked;

    public EntranceRiftBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends RiftBlockEntity>)((class_2591)ModBlockEntityTypes.ENTRANCE_RIFT.get()), pos, state);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.locked = nbt.method_10577("locked");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        nbt.method_10556("locked", this.locked);
        super.method_11007(nbt);
    }

    @Override
    public boolean teleport(class_1297 entity) {
        if (this.isLocked()) {
            if (entity instanceof class_1309) {
                Rift rift;
                class_1799 stack = ((class_1309)entity).method_5998(((class_1309)entity).method_6058());
                if (RiftKeyItem.has(stack, (rift = this.asRift()).getId())) {
                    return this.innerTeleport(entity);
                }
                EntityUtils.chat(entity, (class_2561)class_2561.method_43471((String)"rifts.isLocked"));
            }
            return false;
        }
        return this.innerTeleport(entity);
    }

    private boolean innerTeleport(class_1297 entity) {
        boolean status = super.teleport(entity);
        if (this.riftStateChanged && !this.data.isAlwaysDelete()) {
            this.method_5431();
        }
        return status;
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity, Location location) {
        class_2680 state = this.method_10997().method_8320(this.method_11016());
        class_2248 block = state.method_26204();
        class_243 targetPos = class_243.method_24953((class_2382)this.method_11016()).method_1019(class_243.method_24954((class_2382)this.getOrientation().method_10153().method_10163()).method_1021(DimensionalDoors.getConfig().getGeneralConfig().teleportOffset + 0.01));
        if (block instanceof CoordinateTransformerBlock) {
            CoordinateTransformerBlock transformer = (CoordinateTransformerBlock)block;
            if (transformer.isExitFlipped()) {
                TransformationMatrix3d flipper = (TransformationMatrix3d)TransformationMatrix3d.builder().rotateY(Math.PI).build();
                relativePos = flipper.transform(relativePos);
                relativeAngle = flipper.transform(relativeAngle);
                relativeVelocity = flipper.transform(relativeVelocity);
            }
            TransformationMatrix3d.TransformationMatrix3dBuilder transformationBuilder = transformer.transformationBuilder(state, this.method_11016());
            TransformationMatrix3d.TransformationMatrix3dBuilder rotatorBuilder = transformer.rotatorBuilder(state, this.method_11016());
            targetPos = transformer.transformOut(transformationBuilder, relativePos);
            relativeAngle = transformer.rotateOut(rotatorBuilder, relativeAngle);
            relativeVelocity = transformer.rotateOut(rotatorBuilder, relativeVelocity);
        }
        class_2350 direction = this.getOrientation().method_10153();
        targetPos = targetPos.method_1031((double)direction.method_10163().method_10263() / 2.0, (double)direction.method_10163().method_10264() / 2.0, (double)direction.method_10163().method_10260() / 2.0);
        TeleportUtil.teleport(entity, this.field_11863, targetPos, relativeAngle, relativeVelocity);
        return true;
    }

    public class_2350 getOrientation() {
        return Optional.of(this.field_11863.method_8320(this.field_11867)).filter(state -> state.method_28498((class_2769)class_2383.field_11177)).map(state -> (class_2350)state.method_11654((class_2769)class_2383.field_11177)).orElse(class_2350.field_11043);
    }

    @Environment(value=EnvType.CLIENT)
    public Transformer getTransformer() {
        return DefaultTransformation.fromDirection(this.getOrientation());
    }

    public boolean hasOrientation() {
        return this.field_11863 != null && this.field_11863.method_8320(this.field_11867).method_28498((class_2769)class_2383.field_11177);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isTall() {
        return ((RiftProvider)this.method_11010().method_26204()).isTall(this.method_11010());
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setPortalDestination(class_3218 world) {
        if (ModDimensions.isLimboDimension((class_1937)world)) {
            this.setDestination(ESCAPE_TARGET);
        } else {
            this.setDestination(DefaultDungeonDestinations.getGateway());
            this.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
        }
    }

    public void generateDetached(class_1937 world) {
        class_2680 blockState = this.method_11010();
        class_2338 pos = this.method_11016();
        world.method_8501(pos, (class_2680)((class_2248)ModBlocks.DETACHED_RIFT.get()).method_9564().method_11657((class_2769)WaterLoggableDoorBlock.WATERLOGGED, (Comparable)((Boolean)blockState.method_11654((class_2769)WaterLoggableDoorBlock.WATERLOGGED))));
        ((DetachedRiftBlockEntity)world.method_8321(pos)).setData(this.getData());
    }

    @Override
    protected void onClose(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof DimensionalDoorBlock) {
            DimensionalDoorBlock dimensionalDoorBlock = (DimensionalDoorBlock)block;
            class_2248 base = dimensionalDoorBlock.baseBlock();
            if (base instanceof class_2323) {
                class_2323 doorBlock = (class_2323)base;
                class_2680 newState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)doorBlock.method_9564().method_11657((class_2769)class_2323.field_10938, (Comparable)((class_2350)state.method_11654((class_2769)class_2323.field_10938)))).method_11657((class_2769)class_2323.field_10945, (Comparable)((Boolean)state.method_11654((class_2769)class_2323.field_10945)))).method_11657((class_2769)class_2323.field_10941, (Comparable)((class_2750)state.method_11654((class_2769)class_2323.field_10941)))).method_11657((class_2769)class_2323.field_10940, (Comparable)((Boolean)state.method_11654((class_2769)class_2323.field_10940)))).method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609);
                level.method_8650(pos, false);
                level.method_8501(pos.method_10084(), newState);
                level.method_8501(pos.method_10084(), (class_2680)newState.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12607));
            }
        } else if (block instanceof DimensionalPortalBlock) {
            level.method_8650(pos, false);
        }
    }

    @Override
    protected Class<DimensionalDoorBlock> blockClass() {
        return DimensionalDoorBlock.class;
    }

    @Override
    public boolean stablized() {
        return true;
    }
}

