/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.DetachedRiftBlock;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.RiftCurves;
import org.dimdev.dimdoors.world.decay.Decay;
import org.dimdev.dimdoors.world.decay.DecaySource;

public class DetachedRiftBlockEntity
extends RiftBlockEntity<DetachedRiftBlock> {
    private static final int UPDATE_PERIOD = 200;
    private static final class_5819 random = class_5819.method_43047();
    public int spawnedEndermanId = 0;
    public float riftYaw;
    public int curveID = (int)(Math.random() * (double)RiftCurves.CURVES.size());
    private boolean unregisterDisabled = false;
    @Environment(value=EnvType.CLIENT)
    public double renderAngle;

    public DetachedRiftBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends RiftBlockEntity>)((class_2591)ModBlockEntityTypes.DETACHED_RIFT.get()), pos, state);
        this.riftYaw = random.method_43048(360);
    }

    @Override
    protected Class<DetachedRiftBlock> blockClass() {
        return DetachedRiftBlock.class;
    }

    public void applySpreadDecay(class_3218 world, class_2338 pos) {
        float chance = this.size / 100.0f;
        if (random.method_43057() <= chance) {
            class_2338 selected = (class_2338)class_2338.method_34848((class_5819)world.method_8409(), (int)1, (class_2338)pos, (int)((int)chance)).iterator().next();
            Decay.decayBlock(world, selected, world.method_8320(selected), DecaySource.RIFT);
        }
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        this.method_5431();
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.method_5431();
    }

    public int getCurveID() {
        return this.curveID;
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        super.serialize(nbt);
        nbt.method_10569("spawnedEnderManId", this.spawnedEndermanId);
        nbt.method_10569("curveID", this.curveID);
        return nbt;
    }

    @Override
    public void deserialize(class_2487 nbt) {
        super.deserialize(nbt);
        this.spawnedEndermanId = nbt.method_10550("spawnedEnderManId");
        this.curveID = nbt.method_10550("curveID");
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public void unregister() {
        if (!this.unregisterDisabled) {
            super.unregister();
        }
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 velocity, Location location) {
        if (this.field_11863 instanceof class_3218) {
            TeleportUtil.teleport(entity, this.field_11863, this.field_11867, relativeAngle, velocity);
        }
        return true;
    }

    public void setUnregisterDisabled(boolean unregisterDisabled) {
        this.unregisterDisabled = unregisterDisabled;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10548("size", this.size);
        tag.method_10569("curveID", this.curveID);
        return tag;
    }

    @Override
    protected void onClose(class_1937 level, class_2338 pos) {
        level.method_8650(pos, false);
    }

    @Override
    protected void onUpdate(class_1937 level, class_2338 pos) {
        List list;
        if (level.field_9236) {
            return;
        }
        if (level.method_8469(this.spawnedEndermanId) instanceof class_1560) {
            return;
        }
        if ((double)random.method_43057() < DimensionalDoors.getConfig().getGeneralConfig().endermanSpawnChance && this.updateNearestRift() && (list = level.method_18467(class_1560.class, new class_238((double)(pos.method_10263() - 9), (double)(pos.method_10264() - 3), (double)(pos.method_10260() - 9), (double)(pos.method_10263() + 9), (double)(pos.method_10264() + 3), (double)(pos.method_10260() + 9)))).isEmpty()) {
            class_1657 player;
            class_1560 enderman = (class_1560)class_1299.field_6091.method_47821((class_3218)level, pos, class_3730.field_16474);
            enderman.method_5641((double)pos.method_10263() + 0.5, (double)(pos.method_10264() - 1), (double)pos.method_10260() + 0.5, 5.0f, 6.0f);
            if (random.method_43058() < DimensionalDoors.getConfig().getGeneralConfig().endermanAggressiveChance && (player = level.method_18460((class_1297)enderman, 50.0)) != null) {
                enderman.method_5980((class_1309)player);
            }
        }
    }

    @Override
    public void onGrowth(class_1937 level, class_2338 pos) {
        for (int n = 0; n < 10; ++n) {
            this.size = (float)((double)this.size + DimensionalDoors.getConfig().getGeneralConfig().riftGrowthSpeed / (double)(this.size + 1.0f));
        }
        if (!level.method_8608() && DimensionalDoors.getConfig().getGeneralConfig().enableRiftDecay) {
            this.applySpreadDecay((class_3218)level, pos);
        }
    }
}

