/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import java.util.Arrays;
import java.util.Vector;
import net.minecraft.class_2338;

public final class GridUtil {
    public static GridPos idToGridPos(int id) {
        if (id < 0) {
            throw new UnsupportedOperationException("Cannot get GridPos of negative id.");
        }
        GridPos out = id > 8 ? GridUtil.idToGridPos(id / 9) : new GridPos(0, 0);
        int x = out.x * 3;
        int z = out.z * 3;
        long minor = id % 9;
        x = (int)((long)x + ((minor + 1L) % 3L - 1L));
        z = (int)((long)z + ((minor / 3L + 1L) % 3L - 1L));
        out.x = x;
        out.z = z;
        return out;
    }

    public static int gridPosToID(GridPos pos) {
        return GridUtil.convToID(new Vector<Integer>(Arrays.asList(pos.x, pos.z)));
    }

    private static int convToID(Vector<Integer> vector) {
        int x = vector.get(0);
        int z = vector.get(1);
        int id = Math.floorMod(x, 3) + Math.floorMod(z, 3) * 3;
        x = Math.floorDiv(x + 1, 3);
        z = Math.floorDiv(z + 1, 3);
        if (x != 0 || z != 0) {
            vector.set(0, x);
            vector.set(1, z);
            id += 9 * GridUtil.convToID(vector);
        }
        return id;
    }

    public static final class GridPos {
        public int x;
        public int z;

        public GridPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public GridPos(class_2338 pos, int gridSize) {
            this.x = Math.floorDiv(Math.floorDiv(pos.method_10263(), gridSize), 16);
            this.z = Math.floorDiv(Math.floorDiv(pos.method_10260(), gridSize), 16);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GridPos)) {
                return false;
            }
            GridPos other = (GridPos)o;
            if (this.x != other.x) {
                return false;
            }
            return this.z == other.z;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.x;
            result = result * PRIME + this.z;
            return result;
        }

        public String toString() {
            return "GridUtils.GridPos(x=" + this.x + ", z=" + this.z + ")";
        }
    }
}

