/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.api.util.fabric.TeleportUtilImpl;
import org.dimdev.dimdoors.entity.stat.ModStats;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.world.ModDimensions;

public final class TeleportUtil {
    public static <E extends class_1297> E teleport(E entity, class_1937 world, class_2338 pos, float yaw) {
        return TeleportUtil.teleport(entity, world, class_243.method_24955((class_2382)pos), yaw);
    }

    public static <E extends class_1297> E teleport(E entity, class_1937 world, class_243 pos, float yaw) {
        return TeleportUtil.teleport(entity, world, pos, new class_2379((float)entity.method_23317(), yaw, 0.0f), entity.method_18798());
    }

    public static class_243 clampToWorldBorder(class_243 original, class_2784 border) {
        double newX = original.field_1352;
        double newZ = original.field_1350;
        double size = border.method_11965() - 1.0;
        double northBound = border.method_11958() + 1.0;
        double southBound = border.method_11977() - 1.0;
        double westBound = border.method_11976() + 1.0;
        double eastBound = border.method_11963() - 1.0;
        if (newZ < northBound) {
            newZ = northBound + Math.abs(newZ % size) + 1.0;
        } else if (newZ > southBound) {
            newZ = southBound - Math.abs(newZ % size) - 1.0;
        }
        if (newX < westBound) {
            newX = westBound + Math.abs(newX % size) + 1.0;
        } else if (newX > eastBound) {
            newX = eastBound - Math.abs(newX % size) - 1.0;
        }
        return new class_243(newX, original.field_1351, newZ);
    }

    public static <E extends class_1297> E teleport(E entity, class_1937 world, class_243 pos, class_2379 angle, class_243 velocity) {
        if (world.method_8608()) {
            throw new UnsupportedOperationException("Only supported on ServerWorld");
        }
        pos = TeleportUtil.clampToWorldBorder(pos, world.method_8621());
        float yaw = class_3532.method_15393((float)angle.method_10257());
        float pitch = class_3532.method_15363((float)class_3532.method_15393((float)angle.method_10256()), (float)-90.0f, (float)90.0f);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            class_1923 chunkPos = new class_1923(new class_2338(new class_2382((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350)));
            ((class_3218)world).method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)entity.method_5628());
            entity.method_5848();
            if (entity.method_37908().method_27983().equals(world.method_27983())) {
                serverPlayer.field_13987.method_14363(pos.method_10216(), pos.method_10214(), pos.method_10215(), yaw, pitch);
            } else {
                entity = TeleportUtil.teleport(entity, (class_3218)world, new class_5454(pos, velocity, yaw, pitch));
            }
            serverPlayer.field_13987.method_14364((class_2596)new class_2743(entity.method_5628(), velocity));
            ((ExtendedServerPlayNetworkHandler)serverPlayer.field_13987).getDimDoorsPacketHandler().syncPocketAddonsIfNeeded(world, new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
            if (world.method_27983() == ModDimensions.DUNGEON) {
                serverPlayer.method_7281(ModStats.TIMES_BEEN_TO_DUNGEON);
            }
        } else if (entity.method_37908().method_27983().equals(world.method_27983())) {
            entity.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), yaw, pitch);
        } else {
            entity = TeleportUtil.teleport(entity, (class_3218)world, new class_5454(pos, velocity, yaw, pitch));
        }
        entity.method_18799(velocity);
        return entity;
    }

    public static <E extends class_1297> E teleport(E entity, class_1937 world, class_2338 pos, class_2379 angle, class_243 velocity) {
        if (world.method_8608()) {
            throw new UnsupportedOperationException("Only supported on ServerWorld");
        }
        return TeleportUtil.teleport(entity, world, class_243.method_24955((class_2382)pos), angle, velocity);
    }

    public static class_3222 teleport(class_3222 player, Location location) {
        return TeleportUtil.teleport(player, (class_1937)DimensionalDoors.getWorld(location.world), location.pos, 0.0f);
    }

    public static class_3222 teleport(class_3222 player, RotatedLocation location) {
        return TeleportUtil.teleport(player, (class_1937)DimensionalDoors.getWorld((class_5321<class_1937>)location.world), location.pos, (float)((int)location.yaw));
    }

    public static <E extends class_1297> E teleportRandom(E entity, class_1937 world, double y) {
        double scale = ThreadLocalRandom.current().nextGaussian() * (double)ThreadLocalRandom.current().nextInt(90);
        return TeleportUtil.teleport(entity, world, entity.method_19538().method_1023(0.0, entity.method_23318(), 0.0).method_1031(0.0, y, 0.0).method_18805(scale, 1.0, scale), entity.method_36454());
    }

    public static <E extends class_1297> E teleportUntargeted(E entity, class_1937 world) {
        double actualScale = entity.method_37908().method_8597().comp_646() / world.method_8597().comp_646();
        return TeleportUtil.teleport(entity, world, entity.method_19538().method_18805(actualScale, 1.0, actualScale), entity.method_36454());
    }

    public static <E extends class_1297> E teleportUntargeted(E entity, class_1937 world, double y) {
        double actualScale = entity.method_37908().method_8597().comp_646() / world.method_8597().comp_646();
        return TeleportUtil.teleport(entity, world, entity.method_19538().method_1023(0.0, entity.method_19538().method_10214(), 0.0).method_1031(0.0, y, 0.0).method_18805(actualScale, 1.0, actualScale), entity.method_36454());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends class_1297> E teleport(E entity, class_3218 world, class_5454 portalInfo) {
        void var2_2;
        void var1_1;
        return TeleportUtilImpl.teleport(entity, (class_3218)var1_1, (class_5454)var2_2);
    }
}

