/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dimdev.dimdoors.api.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTree<K, T>
implements Map<Path<K>, T> {
    final TreeNode<K, T> entries = new TreeNode();
    final Class<K> clazz;

    public SimpleTree(Class<K> clazz) {
        this.clazz = clazz;
    }

    public Node<K, T> getNode(Path<K> path) {
        return this.entries.getNode(path.asQueue());
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Path<K> path = this.convertKeyToPath(key);
        if (path == null) {
            return false;
        }
        return this.entries.getNode(path.asQueue()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.clazz.isInstance(value)) {
            return false;
        }
        return this.values().contains(value);
    }

    @Override
    public T get(Object key) {
        Path<K> path = this.convertKeyToPath(key);
        if (path == null) {
            return null;
        }
        return this.entries.get(path.asQueue());
    }

    @Override
    public T remove(Object key) {
        Path<K> path = this.convertKeyToPath(key);
        if (path == null) {
            return null;
        }
        return this.entries.remove(path.asQueue());
    }

    private Path<K> convertKeyToPath(Object key) {
        if (!(key instanceof Path)) {
            return null;
        }
        Path pathUnknown = (Path)key;
        if (!pathUnknown.asQueue().stream().allMatch(this.clazz::isInstance)) {
            return null;
        }
        return new Path(pathUnknown.asQueue().stream().filter(this.clazz::isInstance).map(this.clazz::cast).collect(Collectors.toList()));
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    @NotNull
    public Set<Path<K>> keySet() {
        return this.entries.keySet();
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return this.entries.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<Path<K>, T>> entrySet() {
        return this.entries.entrySet();
    }

    @Override
    public void putAll(@NotNull Map<? extends Path<K>, ? extends T> m) {
        m.forEach(this::put);
    }

    @Override
    @Nullable
    public T put(Path<K> key, T value) {
        return this.entries.put(key.asQueue(), value);
    }

    private static class TreeNode<K, T>
    implements Node<K, T> {
        final Map<K, Node<K, T>> entries = new HashMap<K, Node<K, T>>();

        private TreeNode() {
        }

        @Override
        public Node<K, T> getNode(Queue<K> path) {
            if (path.peek() == null) {
                return this;
            }
            Node<K, T> node = this.entries.get(path.remove());
            if (node == null) {
                return null;
            }
            return node.getNode(path);
        }

        @Override
        public T get(Queue<K> path) {
            if (path.peek() == null) {
                return null;
            }
            Node<K, T> node = this.entries.get(path.remove());
            if (node == null) {
                return null;
            }
            return node.get(path);
        }

        @Override
        public T put(Queue<K> path, T entry) {
            K key = path.poll();
            if (key == null) {
                throw new RuntimeException("Cannot set Entry of TreeNode!");
            }
            Node<K, T> node = this.entries.get(key);
            if (node != null) {
                return node.put(path, entry);
            }
            if (path.peek() == null) {
                this.entries.put(key, new EntryNode(entry));
            } else {
                TreeNode<K, T> treeNode = new TreeNode<K, T>();
                treeNode.put(path, entry);
                this.entries.put(key, treeNode);
            }
            return null;
        }

        @Override
        public T remove(Queue<K> path) {
            if (path.peek() == null) {
                return null;
            }
            K key = path.remove();
            Node<K, T> node = this.entries.get(key);
            if (node == null) {
                return null;
            }
            T value = node.remove(path);
            if (node.isEmpty()) {
                this.entries.remove(key);
            }
            return value;
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public int size() {
            return this.entries.values().stream().mapToInt(Node::size).sum();
        }

        @Override
        public Set<Path<K>> keySet() {
            return this.entries.entrySet().stream().map(entry -> {
                Path<Object> key = new Path<Object>(entry.getKey());
                return ((Node)entry.getValue()).keySet().stream().map(key::subPath);
            }).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toSet());
        }

        @Override
        public Set<Map.Entry<Path<K>, T>> entrySet() {
            return this.entries.entrySet().stream().map(entry -> {
                Path<Object> key = new Path<Object>(entry.getKey());
                return ((Node)entry.getValue()).entrySet().stream().map(nodeEntry -> new AbstractMap.SimpleEntry(key.subPath((Path)nodeEntry.getKey()), nodeEntry.getValue()));
            }).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toSet());
        }

        @Override
        public Collection<T> values() {
            return this.entries.values().stream().map(node -> node.values().stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
        }

        public void clear() {
            this.entries.clear();
        }
    }

    public static interface Node<K, T> {
        public Node<K, T> getNode(Queue<K> var1);

        public T get(Queue<K> var1);

        public T put(Queue<K> var1, T var2);

        public T remove(Queue<K> var1);

        public boolean isEmpty();

        public int size();

        public Set<Path<K>> keySet();

        public Set<Map.Entry<Path<K>, T>> entrySet();

        public Collection<T> values();
    }

    private static class EntryNode<K, T>
    implements Node<K, T> {
        T entry;
        boolean empty = false;

        public EntryNode(T entry) {
            this.entry = entry;
        }

        @Override
        public Node<K, T> getNode(Queue<K> path) {
            if (path.isEmpty()) {
                return this;
            }
            return null;
        }

        @Override
        public T get(Queue<K> path) {
            if (path.peek() != null) {
                return null;
            }
            return this.entry;
        }

        @Override
        public T put(Queue<K> path, T entry) {
            if (path.peek() != null) {
                throw new RuntimeException("Cannot set entry further below EntryNode!");
            }
            T temp = this.entry;
            this.entry = entry;
            return temp;
        }

        @Override
        public T remove(Queue<K> path) {
            if (path.peek() != null) {
                return null;
            }
            T temp = this.entry;
            this.entry = null;
            this.empty = true;
            return temp;
        }

        @Override
        public boolean isEmpty() {
            return this.empty;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public Set<Path<K>> keySet() {
            return Collections.singleton(new Path<Object>(new Object[0]));
        }

        @Override
        public Set<Map.Entry<Path<K>, T>> entrySet() {
            return Collections.singleton(new AbstractMap.SimpleEntry<Path<Object>, T>(new Path<Object>(new Object[0]), this.entry));
        }

        @Override
        public Collection<T> values() {
            return Collections.singleton(this.entry);
        }
    }
}

