/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.ExceptionHandlingCollector;
import org.dimdev.dimdoors.api.util.Path;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;
import org.dimdev.dimdoors.api.util.StreamUtils;

public class ResourceUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    public static final BiFunction<String, class_2960, Path<String>> PATH_KEY_PROVIDER = (startingPath, id) -> Path.stringPath(id.method_12836() + ":" + id.method_12832().substring(0, id.method_12832().lastIndexOf(".")).substring(startingPath.length() + (startingPath.endsWith("/") ? 0 : 1)));
    public static final ComposableFunction<JsonElement, class_2520> JSON_TO_NBT = json -> (class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, json);
    public static final ComposableFunction<class_2520, JsonElement> NBT_TO_JSON = json -> (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, json);
    public static final ComposableFunction<InputStream, JsonElement> JSON_READER = inputStream -> (JsonElement)GSON.fromJson((Reader)new InputStreamReader((InputStream)inputStream), JsonElement.class);
    public static final ComposableFunction<InputStream, class_2520> NBT_READER = JSON_READER.andThenComposable(JSON_TO_NBT);
    public static final ComposableFunction<InputStream, class_2487> COMPRESSED_NBT_READER = inputStream -> {
        try {
            return class_2507.method_10629((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    };

    public static <R extends ReferenceSerializable> R loadReferencedResource(class_3300 manager, String startingPath, String resourceKey, Function<InputStream, R> reader) {
        String[] splitResourceKey = resourceKey.split("\\|");
        HashMultimap flags = HashMultimap.create();
        flags.put((Object)"resource_key", (Object)resourceKey);
        for (int i = 0; i < splitResourceKey.length - 1; ++i) {
            String keyValuePair = splitResourceKey[i];
            int splitIndex = keyValuePair.indexOf(58);
            if (splitIndex == -1) continue;
            flags.put((Object)keyValuePair.substring(0, splitIndex), (Object)keyValuePair.substring(splitIndex + 1));
        }
        String identifier = splitResourceKey[splitResourceKey.length - 1];
        int identifierSplitIndex = identifier.indexOf(58);
        ReferenceSerializable resource = (ReferenceSerializable)ResourceUtil.loadResource(manager, new class_2960(identifier.substring(0, identifierSplitIndex), startingPath + identifier.substring(identifierSplitIndex + 1)), reader);
        resource.processFlags((Multimap<String, String>)flags);
        return (R)resource;
    }

    public static <R> R loadResource(class_3300 manager, class_2960 resourceKey, Function<InputStream, R> reader) {
        try {
            return reader.apply(((class_3298)manager.method_14486(resourceKey).get()).method_14482());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, T, M extends Map<K, T>> CompletableFuture<M> loadResourcePathToMap(class_3300 manager, String startingPath, String extension, M map, BiFunction<InputStream, K, T> reader, BiFunction<String, class_2960, K> keyProvider) {
        Map ids = manager.method_14488(startingPath, str -> str.method_12832().endsWith(extension));
        return StreamUtils.supplyAsync(() -> {
            map.putAll((Map)((Stream)ids.entrySet().parallelStream().unordered()).collect(new ExceptionHandlingCollector(Collectors.toConcurrentMap(id -> keyProvider.apply(startingPath, (class_2960)id.getKey()), id -> {
                try {
                    return reader.apply(((class_3298)id.getValue()).method_14482(), keyProvider.apply(startingPath, (class_2960)id.getKey()));
                }
                catch (IOException | RuntimeException e) {
                    throw new RuntimeException(e);
                }
            }), (a, id, exception) -> LOGGER.error("Error loading resource: " + String.valueOf(id), (Throwable)exception))));
            return map;
        });
    }

    public static <T, M extends Collection<T>> CompletableFuture<M> loadResourcePathToCollection(class_3300 manager, String startingPath, String extension, M collection, BiFunction<InputStream, class_2960, T> reader) {
        Map ids = manager.method_14488(startingPath, str -> str.method_12832().endsWith(extension));
        return StreamUtils.supplyAsync(() -> {
            collection.addAll(((Stream)ids.entrySet().parallelStream().unordered()).map(id -> {
                try {
                    return reader.apply(((class_3298)id.getValue()).method_14482(), (class_2960)id.getKey());
                }
                catch (Exception e) {
                    LOGGER.error("Error loading resource: " + String.valueOf(id), (Throwable)e);
                    return null;
                }
            }).collect(Collectors.filtering(Objects::nonNull, Collectors.toList())));
            return collection;
        });
    }

    public static interface ComposableFunction<T, R>
    extends Function<T, R> {
        default public <K, V> BiFunction<T, K, V> andThenReader(BiFunction<R, K, V> function) {
            return (t, k) -> function.apply(this.apply(t), k);
        }

        default public <K> BiFunction<T, K, R> composeIdentity() {
            return (t, k) -> this.apply(t);
        }

        default public <V> ComposableFunction<T, V> andThenComposable(Function<? super R, ? extends V> after) {
            return t -> after.apply((R)this.apply(t));
        }
    }
}

