/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.LocationCondition;

public interface LocationValue {
    public static final Codec<LocationValue> CODEC = Codec.either(Constant.CODEC, LocationValueWithType.TYPE_CODEC).xmap(either -> (LocationValue)either.map(constant -> constant, locationValueWithType -> locationValueWithType), value -> {
        Either either;
        if (value instanceof Constant) {
            Constant constant = (Constant)value;
            either = Either.left((Object)constant);
        } else {
            either = Either.right((Object)((LocationValueWithType)value));
        }
        return either;
    });

    public float value(Location var1, class_5819 var2);

    public record Constant(float value) implements LocationValue
    {
        public static final Codec<Constant> CODEC = Codec.FLOAT.xmap(Constant::new, Constant::value);
        public static final Constant ZERO = new Constant(0.0f);

        @Override
        public float value(Location location, class_5819 source) {
            return this.value;
        }
    }

    public static interface LocationValueWithType
    extends LocationValue {
        public static final Codec<LocationValueWithType> TYPE_CODEC = LocationValueType.CODEC.dispatch("type", LocationValueWithType::type, LocationValueType::codec);

        public static void register() {
        }

        public LocationValueType<? extends LocationValueWithType> type();
    }

    public record LocationValueType<T extends LocationValueWithType>(Codec<T> codec) {
        public static final Registrar<LocationValueType<? extends LocationValue>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("location_value_type"), (Object[])new LocationValueType[0]).build();
        public static final Codec<LocationValueType<? extends LocationValue>> CODEC = class_2960.field_25139.xmap(arg_0 -> REGISTRY.get(arg_0), arg_0 -> REGISTRY.getId(arg_0));
        public static final RegistrySupplier<LocationValueType<Simple>> SIMPLE = LocationValueType.register(DimensionalDoors.id("simple"), Simple.CODEC);
        public static final RegistrySupplier<LocationValueType<Complex>> COMPLEX = LocationValueType.register(DimensionalDoors.id("complex"), Complex.CODEC);

        public static void register() {
        }

        static <T, V, U extends LocationValueWithType> RegistrySupplier<LocationValueType<U>> register(class_2960 id, Codec<U> codec) {
            return REGISTRY.register(id, () -> new LocationValueType(codec));
        }
    }

    public record Simple(class_5863 value) implements LocationValueWithType
    {
        public static final Codec<Simple> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5863.field_29007.fieldOf("value").forGetter(Simple::value)).apply((Applicative)instance, Simple::new));

        @Override
        public float value(Location location, class_5819 source) {
            return this.value.method_33920(source);
        }

        @Override
        public LocationValueType<? extends LocationValueWithType> type() {
            return (LocationValueType)LocationValueType.SIMPLE.get();
        }
    }

    public record Complex(List<LocationCondition> conditions, class_5863 value, class_5863 fallback) implements LocationValueWithType
    {
        public static final Codec<Complex> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LocationCondition.LIST_CODEC.fieldOf("conditions").forGetter(Complex::conditions), (App)class_5863.field_29007.fieldOf("value").forGetter(Complex::value), (App)class_5863.field_29007.fieldOf("fallback").forGetter(Complex::value)).apply((Applicative)instance, Complex::new));

        @Override
        public float value(Location location, class_5819 source) {
            return (this.conditions.stream().allMatch(a -> a.test(location)) ? this.value : this.fallback).method_33920(source);
        }

        @Override
        public LocationValueType<? extends LocationValueWithType> type() {
            return (LocationValueType)LocationValueType.COMPLEX.get();
        }
    }
}

