/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.effect;

import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class DietEffectsInfo {
    private final List<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
    private final List<StatusEffect> effects = new ArrayList<StatusEffect>();

    public void addModifier(Attribute attribute, AttributeModifier.Operation operation, float amount) {
        this.modifiers.add(new AttributeModifier(attribute, operation, amount));
    }

    public void addModifier(Attribute attribute, net.minecraft.world.entity.ai.attributes.AttributeModifier modifier) {
        this.modifiers.add(new AttributeModifier(attribute, modifier));
    }

    public void addEffect(MobEffect effect, int amplifier) {
        this.effects.add(new StatusEffect(effect, amplifier));
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.effects.add(new StatusEffect(effectInstance));
    }

    public List<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public List<StatusEffect> getEffects() {
        return this.effects;
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        ListTag modifiersList = new ListTag();
        for (AttributeModifier modifier : this.modifiers) {
            CompoundTag modifierTag = new CompoundTag();
            modifierTag.m_128359_("AttributeName", Objects.requireNonNull(Services.REGISTRY.getAttributeKey(modifier.attribute)).toString());
            modifierTag.m_128350_("Amount", modifier.amount);
            modifierTag.m_128405_("Operation", modifier.operation.m_22235_());
            modifiersList.add((Object)modifierTag);
        }
        ListTag effectsList = new ListTag();
        for (StatusEffect effect : this.effects) {
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128359_("EffectName", Objects.requireNonNull(Services.REGISTRY.getStatusEffectKey(effect.effect)).toString());
            effectTag.m_128405_("Amplifier", effect.amplifier);
            effectsList.add((Object)effectTag);
        }
        tag.m_128365_("Modifiers", (Tag)modifiersList);
        tag.m_128365_("Effects", (Tag)effectsList);
        return tag;
    }

    public static DietEffectsInfo read(CompoundTag tag) {
        DietEffectsInfo info = new DietEffectsInfo();
        ListTag modifiersList = tag.m_128437_("Modifiers", 10);
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundTag modifierTag = modifiersList.m_128728_(i);
            String name = modifierTag.m_128461_("AttributeName");
            Attribute attribute = Services.REGISTRY.getAttribute(new ResourceLocation(name)).orElse(null);
            if (attribute == null) continue;
            float amount = modifierTag.m_128457_("Amount");
            AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)modifierTag.m_128451_("Operation"));
            info.addModifier(attribute, operation, amount);
        }
        ListTag effectsList = tag.m_128437_("Effects", 10);
        for (int i = 0; i < effectsList.size(); ++i) {
            CompoundTag effectTag = effectsList.m_128728_(i);
            String name = effectTag.m_128461_("EffectName");
            MobEffect effect = Services.REGISTRY.getStatusEffect(new ResourceLocation(name)).orElse(null);
            if (effect == null) continue;
            int amplifier = effectTag.m_128451_("Amplifier");
            info.addEffect(effect, amplifier);
        }
        return info;
    }

    public static final class AttributeModifier {
        private final Attribute attribute;
        private final AttributeModifier.Operation operation;
        private final float amount;

        private AttributeModifier(Attribute attributeIn, AttributeModifier.Operation operationIn, float amountIn) {
            this.attribute = attributeIn;
            this.operation = operationIn;
            this.amount = amountIn;
        }

        private AttributeModifier(Attribute attributeIn, net.minecraft.world.entity.ai.attributes.AttributeModifier modifier) {
            this.attribute = attributeIn;
            this.operation = modifier.m_22217_();
            this.amount = (float)modifier.m_22218_();
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    public static final class StatusEffect {
        private final MobEffect effect;
        private final int amplifier;

        private StatusEffect(MobEffect effectIn, int amplifierIn) {
            this.effect = effectIn;
            this.amplifier = amplifierIn;
        }

        private StatusEffect(MobEffectInstance effectInstance) {
            this.effect = effectInstance.m_19544_();
            this.amplifier = effectInstance.m_19564_();
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        public int getAmplifier() {
            return this.amplifier;
        }
    }
}

