/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.group;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.util.DietColor;
import com.illusivesoulworks.diet.common.data.group.DietGroup;
import com.illusivesoulworks.diet.common.util.DietValueGenerator;
import com.illusivesoulworks.diet.platform.Services;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class DietGroups
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final DietGroups SERVER = Services.CAPABILITY.getGroupsListener();
    public static final DietGroups CLIENT = Services.CAPABILITY.getGroupsListener();
    private Map<String, IDietGroup> groups = new HashMap<String, IDietGroup>();

    public DietGroups() {
        super(GSON, "diet/groups");
    }

    public static Set<IDietGroup> getGroups(class_1937 level) {
        DietGroups instance = level.method_8608() ? CLIENT : SERVER;
        return ImmutableSet.copyOf(instance.groups.values());
    }

    public static Optional<IDietGroup> getGroup(class_1937 level, String name) {
        DietGroups instance = level.method_8608() ? CLIENT : SERVER;
        return Optional.ofNullable(instance.groups.get(name));
    }

    public Set<IDietGroup> getGroups() {
        return ImmutableSet.copyOf(this.groups.values());
    }

    public Optional<IDietGroup> getGroup(String name) {
        return Optional.ofNullable(this.groups.get(name));
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, IDietGroup> entry : this.groups.entrySet()) {
            tag.method_10566(entry.getKey(), (class_2520)entry.getValue().save());
        }
        return tag;
    }

    public void load(class_2487 tag) {
        HashMap<String, IDietGroup> loaded = new HashMap<String, IDietGroup>();
        for (String key : tag.method_10541()) {
            loaded.put(key, DietGroup.load((class_2487)Objects.requireNonNull(tag.method_10580(key))));
        }
        this.groups = loaded;
    }

    public void sync(class_3222 player) {
        HashMap<class_1792, Set<String>> items = new HashMap<class_1792, Set<String>>();
        for (Map.Entry<class_1792, Set<IDietGroup>> entry : DietValueGenerator.getAll().entrySet()) {
            HashSet<String> groups = new HashSet<String>();
            for (IDietGroup group : entry.getValue()) {
                groups.add(group.getName());
            }
            items.put(entry.getKey(), groups);
        }
        Services.NETWORK.sendDietGroupsS2C(player, this.save(), items);
    }

    protected void apply(@Nonnull Map<class_2960, JsonElement> object, @Nonnull class_3300 resourceManager, @Nonnull class_3695 profilerFiller) {
        class_2960 resourcelocation;
        HashMap<String, DietGroup.Builder> map = new HashMap<String, DietGroup.Builder>();
        for (Map.Entry<class_2960, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (!resourcelocation.method_12836().equals("diet")) continue;
            try {
                this.buildGroup(map.computeIfAbsent(resourcelocation.method_12832(), DietGroup.Builder::new), class_3518.method_15295((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet group {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (Map.Entry<class_2960, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (resourcelocation.method_12832().startsWith("_") || resourcelocation.method_12836().equals("diet")) continue;
            try {
                this.buildGroup(map.computeIfAbsent(resourcelocation.method_12832(), DietGroup.Builder::new), class_3518.method_15295((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet group {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.groups = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DietGroup.Builder)entry.getValue()).build()));
        DietConstants.LOG.info("Loaded {} diet groups", (Object)map.size());
    }

    private void buildGroup(DietGroup.Builder builder, JsonObject topElement) {
        if (topElement.has("icon")) {
            String icon = class_3518.method_15265((JsonObject)topElement, (String)"icon");
            Services.REGISTRY.getItem(new class_2960(icon)).ifPresent(builder::icon);
        }
        if (topElement.has("color")) {
            String color = class_3518.method_15265((JsonObject)topElement, (String)"color");
            int col = color.startsWith("#") ? Integer.parseInt(color.substring(1), 16) : Integer.parseInt(color);
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col & 0xFF;
            builder.color(new DietColor(r, g, b));
        }
        if (topElement.has("order")) {
            builder.order(class_3518.method_15260((JsonObject)topElement, (String)"order"));
        }
        if (topElement.has("default_value")) {
            builder.defaultValue(class_3518.method_15259((JsonObject)topElement, (String)"default_value"));
        }
        if (topElement.has("gain_multiplier")) {
            builder.gainMultiplier(class_3518.method_15259((JsonObject)topElement, (String)"gain_multiplier"));
        }
        if (topElement.has("decay_multiplier")) {
            builder.decayMultiplier(class_3518.method_15259((JsonObject)topElement, (String)"decay_multiplier"));
        }
        if (topElement.has("beneficial")) {
            builder.beneficial(class_3518.method_15270((JsonObject)topElement, (String)"beneficial"));
        }
    }
}

