/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.effect;

import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class DietEffectsInfo {
    private final List<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
    private final List<StatusEffect> effects = new ArrayList<StatusEffect>();

    public void addModifier(class_1320 attribute, class_1322.class_1323 operation, float amount) {
        this.modifiers.add(new AttributeModifier(attribute, operation, amount));
    }

    public void addModifier(class_1320 attribute, class_1322 modifier) {
        this.modifiers.add(new AttributeModifier(attribute, modifier));
    }

    public void addEffect(class_1291 effect, int amplifier) {
        this.effects.add(new StatusEffect(effect, amplifier));
    }

    public void addEffect(class_1293 effectInstance) {
        this.effects.add(new StatusEffect(effectInstance));
    }

    public List<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public List<StatusEffect> getEffects() {
        return this.effects;
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        class_2499 modifiersList = new class_2499();
        for (AttributeModifier modifier : this.modifiers) {
            class_2487 modifierTag = new class_2487();
            modifierTag.method_10582("AttributeName", Objects.requireNonNull(Services.REGISTRY.getAttributeKey(modifier.attribute)).toString());
            modifierTag.method_10548("Amount", modifier.amount);
            modifierTag.method_10569("Operation", modifier.operation.method_6191());
            modifiersList.add((Object)modifierTag);
        }
        class_2499 effectsList = new class_2499();
        for (StatusEffect effect : this.effects) {
            class_2487 effectTag = new class_2487();
            effectTag.method_10582("EffectName", Objects.requireNonNull(Services.REGISTRY.getStatusEffectKey(effect.effect)).toString());
            effectTag.method_10569("Amplifier", effect.amplifier);
            effectsList.add((Object)effectTag);
        }
        tag.method_10566("Modifiers", (class_2520)modifiersList);
        tag.method_10566("Effects", (class_2520)effectsList);
        return tag;
    }

    public static DietEffectsInfo read(class_2487 tag) {
        DietEffectsInfo info = new DietEffectsInfo();
        class_2499 modifiersList = tag.method_10554("Modifiers", 10);
        for (int i = 0; i < modifiersList.size(); ++i) {
            class_2487 modifierTag = modifiersList.method_10602(i);
            String name = modifierTag.method_10558("AttributeName");
            class_1320 attribute = Services.REGISTRY.getAttribute(new class_2960(name)).orElse(null);
            if (attribute == null) continue;
            float amount = modifierTag.method_10583("Amount");
            class_1322.class_1323 operation = class_1322.class_1323.method_6190((int)modifierTag.method_10550("Operation"));
            info.addModifier(attribute, operation, amount);
        }
        class_2499 effectsList = tag.method_10554("Effects", 10);
        for (int i = 0; i < effectsList.size(); ++i) {
            class_2487 effectTag = effectsList.method_10602(i);
            String name = effectTag.method_10558("EffectName");
            class_1291 effect = Services.REGISTRY.getStatusEffect(new class_2960(name)).orElse(null);
            if (effect == null) continue;
            int amplifier = effectTag.method_10550("Amplifier");
            info.addEffect(effect, amplifier);
        }
        return info;
    }

    public static final class AttributeModifier {
        private final class_1320 attribute;
        private final class_1322.class_1323 operation;
        private final float amount;

        private AttributeModifier(class_1320 attributeIn, class_1322.class_1323 operationIn, float amountIn) {
            this.attribute = attributeIn;
            this.operation = operationIn;
            this.amount = amountIn;
        }

        private AttributeModifier(class_1320 attributeIn, class_1322 modifier) {
            this.attribute = attributeIn;
            this.operation = modifier.method_6182();
            this.amount = (float)modifier.method_6186();
        }

        public class_1320 getAttribute() {
            return this.attribute;
        }

        public class_1322.class_1323 getOperation() {
            return this.operation;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    public static final class StatusEffect {
        private final class_1291 effect;
        private final int amplifier;

        private StatusEffect(class_1291 effectIn, int amplifierIn) {
            this.effect = effectIn;
            this.amplifier = amplifierIn;
        }

        private StatusEffect(class_1293 effectInstance) {
            this.effect = effectInstance.method_5579();
            this.amplifier = effectInstance.method_5578();
        }

        public class_1291 getEffect() {
            return this.effect;
        }

        public int getAmplifier() {
            return this.amplifier;
        }
    }
}

