/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.command;

import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.common.command.DietCsv;
import com.illusivesoulworks.diet.common.command.DietGroupArgument;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DietCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder dietCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"diet").requires(player -> player.method_9259(2));
        dietCommand.then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"group", (ArgumentType)DietGroupArgument.group()).executes(ctx -> DietCommand.get((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), DietGroupArgument.getGroup((CommandContext<class_2168>)ctx, "group"))))));
        dietCommand.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"group", (ArgumentType)DietGroupArgument.group()).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.set((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<class_2168>)ctx, "group")))))));
        dietCommand.then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"group", (ArgumentType)DietGroupArgument.group()).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.modify((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<class_2168>)ctx, "group")))))));
        dietCommand.then(class_2170.method_9247((String)"subtract").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"group", (ArgumentType)DietGroupArgument.group()).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.modify((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), -1.0f * FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<class_2168>)ctx, "group")))))));
        dietCommand.then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> DietCommand.reset((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player")))));
        dietCommand.then(class_2170.method_9247((String)"pause").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> DietCommand.active((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), false))));
        dietCommand.then(class_2170.method_9247((String)"resume").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> DietCommand.active((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), true))));
        dietCommand.then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> DietCommand.clear((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player")))));
        LiteralArgumentBuilder exportArg = (LiteralArgumentBuilder)class_2170.method_9247((String)"export").executes(ctx -> DietCommand.export((class_2168)ctx.getSource(), DietCsv.ExportMode.ALL, new String[0]));
        exportArg.then(class_2170.method_9247((String)"group").then(class_2170.method_9244((String)"group", (ArgumentType)DietGroupArgument.group()).executes(ctx -> DietCommand.export((class_2168)ctx.getSource(), DietGroupArgument.getGroup((CommandContext<class_2168>)ctx, "group")))));
        exportArg.then(class_2170.method_9247((String)"mod_id").then(class_2170.method_9244((String)"mod_id", Services.REGISTRY.getModIdArgument()).executes(ctx -> DietCommand.export((class_2168)ctx.getSource(), DietCsv.ExportMode.MOD_ID, StringArgumentType.getString((CommandContext)ctx, (String)"mod_id")))));
        exportArg.then(class_2170.method_9247((String)"uncategorized").executes(ctx -> DietCommand.export((class_2168)ctx.getSource(), DietCsv.ExportMode.UNCATEGORIZED, new String[0])));
        exportArg.then(class_2170.method_9247((String)"trails").executes(ctx -> DietCommand.export((class_2168)ctx.getSource(), DietCsv.ExportMode.TRAILS, new String[0])));
        dietCommand.then((ArgumentBuilder)exportArg);
        dispatcher.register(dietCommand);
    }

    private static int get(class_2168 sender, class_3222 player, IDietGroup group) {
        Services.CAPABILITY.get((class_1657)player).ifPresent(diet -> {
            float amount = diet.getValue(group.getName());
            sender.method_9226(() -> class_2561.method_43469((String)"commands.diet.get.success", (Object[])new Object[]{class_2561.method_43471((String)("groups.diet." + group.getName() + ".name")), Float.valueOf(amount * 100.0f), player.method_5477()}), true);
        });
        return 1;
    }

    private static int set(class_2168 sender, class_3222 player, float value, IDietGroup group) {
        Services.CAPABILITY.get((class_1657)player).ifPresent(diet -> {
            if (diet.getValues().containsKey(group.getName())) {
                diet.setValue(group.getName(), value);
                diet.sync();
                sender.method_9226(() -> class_2561.method_43469((String)"commands.diet.set.success", (Object[])new Object[]{class_2561.method_43471((String)("groups.diet." + group.getName() + ".name")), Float.valueOf(value * 100.0f), player.method_5477()}), true);
            }
        });
        return 1;
    }

    private static int modify(class_2168 sender, class_3222 player, float amount, IDietGroup group) {
        if (amount != 0.0f) {
            Services.CAPABILITY.get((class_1657)player).ifPresent(diet -> {
                if (diet.getValues().containsKey(group.getName())) {
                    diet.setValue(group.getName(), diet.getValue(group.getName()) + amount);
                    diet.sync();
                    String arg = amount > 0.0f ? "add" : "remove";
                    sender.method_9226(() -> class_2561.method_43469((String)("commands.diet." + arg + ".success"), (Object[])new Object[]{class_2561.method_43471((String)("groups.diet." + group.getName() + ".name")), Float.valueOf(amount * 100.0f), player.method_5477()}), true);
                }
            });
        }
        return 1;
    }

    private static int reset(class_2168 sender, class_3222 player) {
        Services.CAPABILITY.get((class_1657)player).ifPresent(diet -> {
            DietSuites.getSuite(player.method_37908(), diet.getSuite()).ifPresent(suite -> {
                for (IDietGroup group : suite.getGroups()) {
                    diet.setValue(group.getName(), group.getDefaultValue());
                }
            });
            diet.sync();
            sender.method_9226(() -> class_2561.method_43469((String)"commands.diet.reset.success", (Object[])new Object[]{player.method_5477()}), true);
        });
        return 1;
    }

    private static int active(class_2168 sender, class_3222 player, boolean flag) {
        Services.CAPABILITY.get((class_1657)player).ifPresent(diet -> {
            diet.setActive(flag);
            diet.sync();
            String arg = flag ? "resume" : "pause";
            sender.method_9226(() -> class_2561.method_43469((String)("commands.diet." + arg + ".success"), (Object[])new Object[]{player.method_5477()}), true);
        });
        return 1;
    }

    private static int clear(class_2168 sender, class_3222 player) {
        for (class_1324 instance : player.method_6127().method_26841()) {
            for (class_1322 attributeModifier : instance.method_6195()) {
                if (!attributeModifier.method_6185().equals("Diet group effect")) continue;
                instance.method_6200(attributeModifier.method_6189());
            }
        }
        sender.method_9226(() -> class_2561.method_43469((String)"commands.diet.clear.success", (Object[])new Object[]{player.method_5477()}), true);
        return 1;
    }

    private static int export(class_2168 sender, IDietGroup group) {
        if (sender.method_9228() instanceof class_1657) {
            sender.method_9226(() -> class_2561.method_43471((String)"commands.diet.export.started"), true);
            DietCsv.writeGroup((class_1657)sender.method_9228(), group);
            sender.method_9226(() -> class_2561.method_43471((String)"commands.diet.export.finished"), true);
        }
        return 1;
    }

    private static int export(class_2168 sender, DietCsv.ExportMode mode, String ... args) {
        class_1297 class_12972 = sender.method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            sender.method_9226(() -> class_2561.method_43471((String)"commands.diet.export.started"), true);
            if (mode == DietCsv.ExportMode.ALL) {
                DietCsv.write(player, "");
            } else if (mode == DietCsv.ExportMode.MOD_ID) {
                DietCsv.write(player, args[0]);
            } else if (mode == DietCsv.ExportMode.UNCATEGORIZED) {
                DietCsv.writeUncategorized(player);
            } else if (mode == DietCsv.ExportMode.TRAILS) {
                DietCsv.writeTrails(player);
            }
            sender.method_9226(() -> class_2561.method_43471((String)"commands.diet.export.finished"), true);
        }
        return 1;
    }
}

