/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client.screen;

import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.client.screen.DietScreen;
import com.illusivesoulworks.diet.common.data.effect.DietEffectsInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class DietTooltip {
    public static List<class_2561> getEffects() {
        List<DietEffectsInfo.AttributeModifier> modifiers = DietScreen.tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = DietScreen.tooltip.getEffects();
        if (modifiers.isEmpty() && effects.isEmpty()) {
            return new ArrayList<class_2561>();
        }
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        tooltips.add((class_2561)class_2561.method_43471((String)"tooltip.diet.effects"));
        tooltips.add((class_2561)class_2561.method_43473());
        HashMap<class_1320, AttributeTooltip> mergedAttributes = new HashMap<class_1320, AttributeTooltip>();
        for (DietEffectsInfo.AttributeModifier attributeModifier : modifiers) {
            mergedAttributes.computeIfAbsent(attributeModifier.getAttribute(), k -> new AttributeTooltip()).merge(attributeModifier);
        }
        for (Map.Entry entry : mergedAttributes.entrySet()) {
            AttributeTooltip attributeTooltip = (AttributeTooltip)entry.getValue();
            class_1320 key = (class_1320)entry.getKey();
            if (key == DietApi.getInstance().getNaturalRegeneration()) {
                float val = (attributeTooltip.added + attributeTooltip.added * attributeTooltip.baseMultiplier) * attributeTooltip.totalMultiplier;
                if (!(val < 1.0f)) continue;
                tooltips.add((class_2561)class_2561.method_43469((String)"attribute.diet.modifier.disabled", (Object[])new Object[]{class_2561.method_43471((String)key.method_26830())}).method_27692(class_124.field_1061));
                continue;
            }
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.added, class_1322.class_1323.field_6328, key);
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.baseMultiplier, class_1322.class_1323.field_6330, key);
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.totalMultiplier - 1.0f, class_1322.class_1323.field_6331, key);
        }
        HashMap<class_1291, Integer> mergedEffects = new HashMap<class_1291, Integer>();
        for (DietEffectsInfo.StatusEffect statusEffect : effects) {
            mergedEffects.compute(statusEffect.getEffect(), (k, v) -> v == null ? statusEffect.getAmplifier() : Math.max(v, statusEffect.getAmplifier()));
        }
        for (Map.Entry entry : mergedEffects.entrySet()) {
            class_1291 effect1 = (class_1291)entry.getKey();
            class_5250 iformattabletextcomponent = class_2561.method_43471((String)effect1.method_5567());
            if ((Integer)entry.getValue() > 0) {
                iformattabletextcomponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, class_2561.method_43471((String)("potion.potency." + entry.getValue()))});
            }
            tooltips.add((class_2561)iformattabletextcomponent.method_27692(effect1.method_18792().method_18793()));
        }
        return tooltips;
    }

    private static void addAttributeTooltip(List<class_2561> tooltips, float amount, class_1322.class_1323 operation, class_1320 attribute) {
        double formattedAmount = operation != class_1322.class_1323.field_6330 && operation != class_1322.class_1323.field_6331 ? (attribute.equals(class_5134.field_23718) ? (double)amount * 10.0 : (double)amount) : (double)amount * 100.0;
        if ((double)amount > 0.0) {
            tooltips.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + operation.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(formattedAmount), class_2561.method_43471((String)attribute.method_26830())}).method_27692(class_124.field_1078));
        } else if ((double)amount < 0.0) {
            tooltips.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + operation.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(formattedAmount *= -1.0), class_2561.method_43471((String)attribute.method_26830())}).method_27692(class_124.field_1061));
        }
    }

    private static class AttributeTooltip {
        float added = 0.0f;
        float baseMultiplier = 0.0f;
        float totalMultiplier = 1.0f;

        private AttributeTooltip() {
        }

        void merge(DietEffectsInfo.AttributeModifier modifier) {
            float amount = modifier.getAmount();
            if (modifier.getOperation() == class_1322.class_1323.field_6330) {
                this.baseMultiplier += amount;
            } else if (modifier.getOperation() == class_1322.class_1323.field_6331) {
                this.totalMultiplier *= 1.0f + amount;
            } else {
                this.added += amount;
            }
        }
    }
}

