/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.network;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.network.IPacketHandler;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_638;

public record ClientboundSilkLeashStatePacket(List<LeashData> leashDataList) {
    public ClientboundSilkLeashStatePacket(LeashData ... leashData) {
        this(Arrays.asList(leashData));
    }

    public static class Handler
    implements IPacketHandler<ClientboundSilkLeashStatePacket> {
        @Override
        public ClientboundSilkLeashStatePacket read(class_2540 byteBuf) {
            int size = byteBuf.readInt();
            ArrayList<LeashData> leashDataList = new ArrayList<LeashData>(size);
            for (int i = 0; i < size; ++i) {
                int leashOwner = byteBuf.readInt();
                IntList leashingEntities = byteBuf.method_34059();
                IntList leashedByEntities = byteBuf.method_34059();
                leashDataList.add(new LeashData(leashOwner, leashingEntities, leashedByEntities));
            }
            return new ClientboundSilkLeashStatePacket(leashDataList);
        }

        @Override
        public void write(ClientboundSilkLeashStatePacket packet, class_2540 byteBuf) {
            byteBuf.writeInt(packet.leashDataList.size());
            for (LeashData data : packet.leashDataList) {
                byteBuf.writeInt(data.leashOwner);
                byteBuf.method_34060(data.leashingEntities);
                byteBuf.method_34060(data.leashedByEntities);
            }
        }

        @Override
        public void handle(ClientboundSilkLeashStatePacket packet) {
            class_638 level = class_310.method_1551().field_1687;
            for (LeashData data : packet.leashDataList) {
                class_1297 entity = level.method_8469(data.leashOwner());
                if (!(entity instanceof ISilkLeashState)) continue;
                ISilkLeashState leashState = (ISilkLeashState)entity;
                leashState.getLeashingEntities().clear();
                leashState.getLeashedByEntities().clear();
                data.leashingEntities().forEach(id -> {
                    class_1297 leashingEntity = level.method_8469(id);
                    if (leashingEntity instanceof class_1309) {
                        leashState.getLeashingEntities().add((class_1309)leashingEntity);
                    }
                });
                data.leashedByEntities().forEach(id -> {
                    class_1297 leashedByEntity = level.method_8469(id);
                    if (leashedByEntity instanceof class_1309) {
                        leashState.getLeashedByEntities().add((class_1309)leashedByEntity);
                    }
                });
            }
        }
    }

    public record LeashData(int leashOwner, IntList leashingEntities, IntList leashedByEntities) {
    }
}

