/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.data;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

public class CreateRegistrateTags {
    public static void addGenerators() {
        Create.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, CreateRegistrateTags::genBlockTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CreateRegistrateTags::genItemTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, CreateRegistrateTags::genFluidTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, CreateRegistrateTags::genEntityTags);
    }

    private static void genBlockTags(RegistrateTagsProvider<Block> provIn) {
        TagGen.CreateTagsProvider<Block> prov = new TagGen.CreateTagsProvider<Block>(provIn, Block::m_204297_);
        prov.tag(AllTags.AllBlockTags.BRITTLE.tag).add((Block[])new Block[]{Blocks.f_50680_, Blocks.f_50262_, Blocks.f_50276_, Blocks.f_152543_, Blocks.f_50570_, Blocks.f_152545_, Blocks.f_50191_, Blocks.f_50653_, Blocks.f_50704_, Blocks.f_50703_, Blocks.f_50702_, Blocks.f_50145_}).m_206428_(AllTags.AllBlockTags.CORALS.tag).m_206428_(BlockTags.f_144275_).m_206428_(BlockTags.f_13028_).m_206428_(BlockTags.f_13038_).m_206428_(BlockTags.f_13103_);
        prov.tag(AllTags.AllBlockTags.COPYCAT_ALLOW.tag).add(Blocks.f_50618_);
        prov.tag(AllTags.AllBlockTags.COPYCAT_DENY.tag).m_206428_(BlockTags.f_144269_).m_206428_(BlockTags.f_13104_).m_206428_(BlockTags.f_13082_);
        prov.tag(AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_HAUNTING.tag).add(Blocks.f_50084_).add(Blocks.f_50684_);
        prov.tag(AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SMOKING.tag).add(Blocks.f_50083_).add(Blocks.f_50683_);
        prov.tag(AllTags.AllBlockTags.FAN_TRANSPARENT.tag).add(Blocks.f_50183_).add(Blocks.f_220833_).m_206428_(BlockTags.f_13087_).m_206428_(BlockTags.f_13039_).m_206428_(BlockTags.f_13035_);
        prov.tag(AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag).add((Block[])new Block[]{Blocks.f_50033_, Blocks.f_152499_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50570_, Blocks.f_50191_, Blocks.f_50653_, Blocks.f_50704_, Blocks.f_50703_, Blocks.f_50702_}).m_206428_(AllTags.AllBlockTags.CORALS.tag).m_206428_(BlockTags.f_144275_).m_206428_(BlockTags.f_13055_).m_206428_(BlockTags.f_13028_);
        prov.tag(AllTags.AllBlockTags.ORE_OVERRIDE_STONE.tag).m_206428_(BlockTags.f_144266_);
        prov.tag(AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.tag).add((Block[])new Block[]{Blocks.f_50450_, Blocks.f_49991_}).m_206428_(BlockTags.f_13087_).m_206428_(BlockTags.f_13076_);
        prov.tag(AllTags.AllBlockTags.SAFE_NBT.tag).m_206428_(BlockTags.f_13028_).m_206428_(BlockTags.f_260523_);
        prov.tag(AllTags.AllBlockTags.TREE_ATTACHMENTS.tag).add((Block[])new Block[]{Blocks.f_50717_, Blocks.f_50262_, Blocks.f_220831_, Blocks.f_152543_, Blocks.f_50701_, Blocks.f_50191_});
        prov.tag(AllTags.AllBlockTags.WINDMILL_SAILS.tag).m_206428_(BlockTags.f_13089_);
        prov.tag(AllTags.AllBlockTags.WRENCH_PICKUP.tag).add((Block[])new Block[]{Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50146_, Blocks.f_50164_, Blocks.f_50328_, Blocks.f_50455_, Blocks.f_50123_, Blocks.f_50039_, Blocks.f_50032_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50329_, Blocks.f_50716_, Blocks.f_50332_}).m_206428_(BlockTags.f_13093_).m_206428_(BlockTags.f_13099_).m_206428_(BlockTags.f_13034_);
        prov.tag(AllTags.AllBlockTags.ROOTS.tag).add(Blocks.f_220833_);
        prov.tag(AllTags.AllBlockTags.CORALS.tag).add((Block[])new Block[]{Blocks.f_50589_, Blocks.f_50590_, Blocks.f_50591_, Blocks.f_50592_, Blocks.f_50593_, Blocks.f_50594_, Blocks.f_50595_, Blocks.f_50596_, Blocks.f_50597_, Blocks.f_50598_, Blocks.f_50547_, Blocks.f_50548_, Blocks.f_50549_, Blocks.f_50550_, Blocks.f_50551_, Blocks.f_50552_, Blocks.f_50553_, Blocks.f_50554_, Blocks.f_50555_, Blocks.f_50556_, Blocks.f_50557_, Blocks.f_50558_, Blocks.f_50559_, Blocks.f_50560_, Blocks.f_50561_, Blocks.f_50562_, Blocks.f_50563_, Blocks.f_50564_, Blocks.f_50565_, Blocks.f_50566_});
        TagGen.addOptional(prov.tag(AllTags.AllBlockTags.NON_MOVABLE.tag), Mods.IE, List.of("connector_lv", "connector_lv_relay", "connector_mv", "connector_mv_relay", "connector_hv", "connector_hv_relay", "connector_bundled", "connector_structural", "connector_redstone", "connector_probe", "breaker_switch"));
        TagGen.addOptional(prov.tag(AllTags.AllBlockTags.ROOTS.tag), Mods.TF, List.of("root", "liveroot_block", "mangrove_root"));
        for (AllTags.AllBlockTags tag : AllTags.AllBlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genItemTags(RegistrateTagsProvider<Item> provIn) {
        TagGen.CreateTagsProvider<Item> prov = new TagGen.CreateTagsProvider<Item>(provIn, Item::m_204114_);
        prov.tag(AllTags.AllItemTags.SLEEPERS.tag).add((Item[])new Item[]{Items.f_41922_, Items.f_41923_, Items.f_42336_});
        prov.tag(AllTags.AllItemTags.STRIPPED_LOGS.tag).m_206428_(AllTags.AllItemTags.VANILLA_STRIPPED_LOGS.tag).m_206428_(AllTags.AllItemTags.MODDED_STRIPPED_LOGS.tag);
        prov.tag(AllTags.AllItemTags.STRIPPED_WOOD.tag).m_206428_(AllTags.AllItemTags.VANILLA_STRIPPED_WOOD.tag).m_206428_(AllTags.AllItemTags.MODDED_STRIPPED_WOOD.tag);
        prov.tag(AllTags.AllItemTags.DEPLOYABLE_DRINK.tag).add((Item[])new Item[]{Items.f_42455_, Items.f_42589_});
        prov.tag(AllTags.AllItemTags.UPRIGHT_ON_BELT.tag).add((Item[])new Item[]{Items.f_42590_, Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42787_, Items.f_42502_});
        prov.tag(AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag).add((Item[])new Item[]{Items.f_42777_, Items.f_42781_, Items.f_42782_, Items.f_41855_, Items.f_42162_});
        prov.tag(AllTags.AllItemTags.VANILLA_STRIPPED_LOGS.tag).add((Item[])new Item[]{Items.f_41849_, Items.f_41847_, Items.f_41851_, Items.f_41850_, Items.f_41848_, Items.f_220182_, Items.f_41845_, Items.f_41846_, Items.f_41879_, Items.f_271164_, Items.f_256923_});
        prov.tag(AllTags.AllItemTags.VANILLA_STRIPPED_WOOD.tag).add((Item[])new Item[]{Items.f_41884_, Items.f_41882_, Items.f_41886_, Items.f_41885_, Items.f_41883_, Items.f_220176_, Items.f_41880_, Items.f_41881_, Items.f_41887_, Items.f_271182_});
        prov.tag((TagKey<Item>)ItemTags.f_13164_).m_206428_(AllTags.AllItemTags.CREATE_INGOTS.tag);
        prov.tag((TagKey<Item>)Tags.Items.INGOTS).m_206428_(AllTags.AllItemTags.CREATE_INGOTS.tag);
        prov.tag(AllTags.AllItemTags.OBSIDIAN_DUST.tag).add((Item)AllItems.POWDERED_OBSIDIAN.get());
        CreateRegistrateTags.genStrippedWoodItemTags(prov);
        prov.tag(AllTags.AllItemTags.CURIOS_HEAD.tag).add((Item)AllItems.GOGGLES.get());
        TagGen.addOptional(prov.tag(AllTags.AllItemTags.ALLURITE.tag), Mods.GS, CreateRegistrateTags.gsPalette("allurite"));
        TagGen.addOptional(prov.tag(AllTags.AllItemTags.LUMIERE.tag), Mods.GS, CreateRegistrateTags.gsPalette("lumiere"));
        TagGen.addOptional(prov.tag(AllTags.AllItemTags.AMETHYST.tag), Mods.GS, CreateRegistrateTags.gsPalette("amethyst"));
        TagGen.addOptional(prov.tag(AllTags.AllItemTags.UA_CORAL.tag), Mods.UA, List.of("acan_coral", "finger_coral", "star_coral", "moss_coral", "petal_coral", "branch_coral", "rock_coral", "pillow_coral", "chrome_coral", "silk_coral"));
        for (AllTags.AllItemTags tag : AllTags.AllItemTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static ArrayList<String> gsPalette(String material) {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add(material + "_block");
        toReturn.add(material + "_stairs");
        toReturn.add(material + "_slab");
        toReturn.add("smooth_" + material);
        toReturn.add("smooth_" + material + "_stairs");
        toReturn.add("smooth_" + material + "_slab");
        toReturn.add(material + "_bricks");
        toReturn.add(material + "_brick_stairs");
        toReturn.add(material + "_brick_slab");
        toReturn.add("chiseled_" + material);
        return toReturn;
    }

    private static void genStrippedWoodItemTags(TagGen.CreateTagsProvider<Item> prov) {
        TagGen.CreateTagAppender<Item> logAppender = prov.tag(AllTags.AllItemTags.MODDED_STRIPPED_LOGS.tag);
        TagGen.CreateTagAppender<Item> woodAppender = prov.tag(AllTags.AllItemTags.MODDED_STRIPPED_WOOD.tag);
        StrippedWoodHelper helper = new StrippedWoodHelper(logAppender, woodAppender);
        helper.add(Mods.ARS_N, "blue_archwood", "purple_archwood", "green_archwood", "red_archwood");
        helper.add(Mods.BTN, "livingwood", "dreamwood");
        helper.add(Mods.FA, "mysterywood");
        helper.add(Mods.HEX, "akashic");
        helper.add(Mods.ID, "menril");
        helper.add(Mods.BYG, "aspen", "baobab", "enchanted", "cika", "cypress", "ebony", "ether", "fir", "green_enchanted", "holly", "jacaranda", "lament", "mahogany", "mangrove", "maple", "nightshade", "palm", "palo_verde", "pine", "rainbow_eucalyptus", "redwood", "skyris", "willow", "witch_hazel", "zelkova");
        helper.add(Mods.SG, "netherwood");
        helper.add(Mods.TF, "twilight_oak", "canopy", "mangrove", "dark", "time", "transformation", "mining", "sorting");
        helper.add(Mods.TIC, "greenheart", "skyroot", "bloodshroom");
        helper.add(Mods.AP, "twisted");
        helper.add(Mods.Q, "azalea", "blossom");
        helper.add(Mods.ECO, "coconut", "walnut", "azalea");
        helper.add(Mods.BOP, "fir", "redwood", "mahogany", "jacaranda", "palm", "willow", "dead", "magic", "umbran", "hellbark");
        helper.add(Mods.BSK, "bluebright", "starlit", "frostbright", "lunar", "dusk", "maple");
        helper.add(Mods.ENV, "willow", "wisteria");
        helper.add(Mods.ATM, "aspen", "kousa", "yucca", "morado");
        helper.add(Mods.ATM_2, "rosewood", "grimwood");
        helper.add(Mods.GOOD, "muddy_oak", "cypress");
        helper.add(Mods.BMK, "blighted_balsa", "willow", "swamp_cypress", "ancient_oak");
        helper.add(Mods.RU, "alpha", "ashen", "baobab", "blackwood", "brimwood", "cobalt", "cypress", "dead", "eucalyptus", "joshua", "kapok", "larch", "magnolia", "maple", "mauve", "palm", "pine", "redwood", "socotra", "willow");
        TagGen.addOptional(logAppender, Mods.AUTUM, "maple");
        TagGen.addOptional(logAppender, Mods.IX, "stripped_luminous_stem");
        TagGen.addOptional(woodAppender, Mods.IX, "stripped_luminous_hyphae");
        TagGen.addOptional(logAppender, Mods.BYG, "stripped_bulbis_stem");
        TagGen.addOptional(woodAppender, Mods.BYG, "stripped_bulbis_wood");
        TagGen.addOptional(logAppender, Mods.RU, "stripped_blue_bioshroom_stem");
        TagGen.addOptional(woodAppender, Mods.RU, "stripped_blue_bioshroom_hyphae");
        TagGen.addOptional(logAppender, Mods.RU, "stripped_green_bioshroom_stem");
        TagGen.addOptional(woodAppender, Mods.RU, "stripped_green_bioshroom_hyphae");
        TagGen.addOptional(logAppender, Mods.RU, "stripped_pink_bioshroom_stem");
        TagGen.addOptional(woodAppender, Mods.RU, "stripped_pink_bioshroom_hyphae");
        TagGen.addOptional(logAppender, Mods.RU, "stripped_yellow_bioshroom_stem");
        TagGen.addOptional(woodAppender, Mods.RU, "stripped_yellow_bioshroom_hyphae");
        TagGen.addOptional(logAppender, Mods.RU, "brimwood_log_magma");
    }

    private static void genFluidTags(RegistrateTagsProvider<Fluid> provIn) {
        TagGen.CreateTagsProvider<Fluid> prov = new TagGen.CreateTagsProvider<Fluid>(provIn, Fluid::m_205069_);
        prov.tag(AllTags.AllFluidTags.BOTTOMLESS_ALLOW.tag).add((Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76195_});
        prov.tag(AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_BLASTING.tag).add((Fluid[])new Fluid[]{Fluids.f_76195_, Fluids.f_76194_});
        prov.tag(AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SPLASHING.tag).add((Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_});
        for (AllTags.AllFluidTags tag : AllTags.AllFluidTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genEntityTags(RegistrateTagsProvider<EntityType<?>> provIn) {
        TagGen.CreateTagsProvider<EntityType> prov = new TagGen.CreateTagsProvider<EntityType>(provIn, EntityType::m_204041_);
        prov.tag(AllTags.AllEntityTags.BLAZE_BURNER_CAPTURABLE.tag).add(EntityType.f_20551_);
        for (AllTags.AllEntityTags tag : AllTags.AllEntityTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static class StrippedWoodHelper {
        protected final TagsProvider.TagAppender<Item> logAppender;
        protected final TagsProvider.TagAppender<Item> woodAppender;

        public StrippedWoodHelper(TagsProvider.TagAppender<Item> logAppender, TagsProvider.TagAppender<Item> woodAppender) {
            this.logAppender = logAppender;
            this.woodAppender = woodAppender;
        }

        public void add(Mods mod, String ... woodTypes) {
            for (String type : woodTypes) {
                String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
                String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
                TagGen.addOptional(this.logAppender, mod, strippedPre + type + "_log" + strippedPost);
                TagGen.addOptional(this.woodAppender, mod, strippedPre + type + (mod.omitWoodSuffix ? "" : "_wood") + strippedPost);
            }
        }
    }
}

