/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public class SchematicEditScreen
extends AbstractSimiScreen {
    private final List<Component> rotationOptions = Lang.translatedOptions("schematic.rotation", "none", "cw90", "cw180", "cw270");
    private final List<Component> mirrorOptions = Lang.translatedOptions("schematic.mirror", "none", "leftRight", "frontBack");
    private final Component rotationLabel = Lang.translateDirect("schematic.rotation", new Object[0]);
    private final Component mirrorLabel = Lang.translateDirect("schematic.mirror", new Object[0]);
    private AllGuiTextures background = AllGuiTextures.SCHEMATIC;
    private EditBox xInput;
    private EditBox yInput;
    private EditBox zInput;
    private IconButton confirmButton;
    private ScrollInput rotationArea;
    private ScrollInput mirrorArea;
    private SchematicHandler handler = CreateClient.SCHEMATIC_HANDLER;

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-6, 0);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.xInput = new EditBox(this.f_96547_, x + 50, y + 26, 34, 10, Components.immutableEmpty());
        this.yInput = new EditBox(this.f_96547_, x + 90, y + 26, 34, 10, Components.immutableEmpty());
        this.zInput = new EditBox(this.f_96547_, x + 130, y + 26, 34, 10, Components.immutableEmpty());
        BlockPos anchor = this.handler.getTransformation().getAnchor();
        if (this.handler.isDeployed()) {
            this.xInput.m_94144_("" + anchor.m_123341_());
            this.yInput.m_94144_("" + anchor.m_123342_());
            this.zInput.m_94144_("" + anchor.m_123343_());
        } else {
            EditBox[] alt = this.f_96541_.f_91074_.m_20183_();
            this.xInput.m_94144_("" + alt.m_123341_());
            this.yInput.m_94144_("" + alt.m_123342_());
            this.zInput.m_94144_("" + alt.m_123343_());
        }
        for (EditBox widget : new EditBox[]{this.xInput, this.yInput, this.zInput}) {
            widget.m_94199_(6);
            widget.m_94182_(false);
            widget.m_94202_(0xFFFFFF);
            widget.m_93692_(false);
            widget.m_6375_(0.0, 0.0, 0);
            widget.m_94153_(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
        StructurePlaceSettings settings = this.handler.getTransformation().toSettings();
        Label labelR = new Label(x + 50, y + 48, Components.immutableEmpty()).withShadow();
        this.rotationArea = new SelectionScrollInput(x + 45, y + 43, 118, 18).forOptions(this.rotationOptions).titled(this.rotationLabel.m_6879_()).setState(settings.m_74404_().ordinal()).writingTo(labelR);
        Label labelM = new Label(x + 50, y + 70, Components.immutableEmpty()).withShadow();
        this.mirrorArea = new SelectionScrollInput(x + 45, y + 65, 118, 18).forOptions(this.mirrorOptions).titled(this.mirrorLabel.m_6879_()).setState(settings.m_74401_().ordinal()).writingTo(labelM);
        this.addRenderableWidgets((GuiEventListener[])new EditBox[]{this.xInput, this.yInput, this.zInput});
        this.addRenderableWidgets(new AbstractSimiWidget[]{labelR, labelM, this.rotationArea, this.mirrorArea});
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.m_7379_());
        this.m_142416_(this.confirmButton);
    }

    @Override
    public boolean m_7933_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        String coords;
        if (SchematicEditScreen.m_96630_((int)code) && (coords = this.f_96541_.f_91068_.m_90876_()) != null && !coords.isEmpty()) {
            coords.replaceAll(" ", "");
            String[] split = coords.split(",");
            if (split.length == 3) {
                boolean valid = true;
                for (String s : split) {
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                }
                if (valid) {
                    this.xInput.m_94144_(split[0]);
                    this.yInput.m_94144_(split[1]);
                    this.zInput.m_94144_(split[2]);
                    return true;
                }
            }
        }
        return super.m_7933_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        String title = this.handler.getCurrentSchematicName();
        graphics.m_280137_(this.f_96547_, title, x + (this.background.width - 8) / 2, y + 3, 0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(AllItems.SCHEMATIC.asStack()).at(x + this.background.width + 6, y + this.background.height - 40, -200.0f)).scale(3.0).render(graphics);
    }

    public void m_7861_() {
        boolean validCoords = true;
        BlockPos newLocation = null;
        try {
            newLocation = new BlockPos(Integer.parseInt(this.xInput.m_94155_()), Integer.parseInt(this.yInput.m_94155_()), Integer.parseInt(this.zInput.m_94155_()));
        }
        catch (NumberFormatException e) {
            validCoords = false;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74379_(Rotation.values()[this.rotationArea.getState()]);
        settings.m_74377_(Mirror.values()[this.mirrorArea.getState()]);
        if (validCoords && newLocation != null) {
            ItemStack item = this.handler.getActiveSchematicItem();
            if (item != null) {
                item.m_41783_().m_128379_("Deployed", true);
                item.m_41783_().m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)newLocation));
            }
            this.handler.getTransformation().init(newLocation, settings, this.handler.getBounds());
            this.handler.markDirty();
            this.handler.deploy();
        }
    }
}

