/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;

public class FilterItemStack {
    private ItemStack filterItemStack;
    private boolean fluidExtracted;
    private FluidStack filterFluidStack;

    public static FilterItemStack of(ItemStack filter) {
        if (filter.m_41782_()) {
            CompoundTag stackTag = filter.m_41783_();
            stackTag.m_128473_("Enchantments");
            stackTag.m_128473_("AttributeModifiers");
            if (AllItems.FILTER.isIn(filter)) {
                return new ListFilterItemStack(filter);
            }
            if (AllItems.ATTRIBUTE_FILTER.isIn(filter)) {
                return new AttributeFilterItemStack(filter);
            }
        }
        return new FilterItemStack(filter);
    }

    public static FilterItemStack of(CompoundTag tag) {
        return FilterItemStack.of(ItemStack.m_41712_((CompoundTag)tag));
    }

    public static FilterItemStack empty() {
        return FilterItemStack.of(ItemStack.f_41583_);
    }

    public boolean isEmpty() {
        return this.filterItemStack.m_41619_();
    }

    public CompoundTag serializeNBT() {
        return this.filterItemStack.serializeNBT();
    }

    public ItemStack item() {
        return this.filterItemStack;
    }

    public FluidStack fluid(Level level) {
        this.resolveFluid(level);
        return this.filterFluidStack;
    }

    public boolean isFilterItem() {
        return this.filterItemStack.m_41720_() instanceof FilterItem;
    }

    public boolean test(Level world, ItemStack stack) {
        return this.test(world, stack, false);
    }

    public boolean test(Level world, FluidStack stack) {
        return this.test(world, stack, true);
    }

    public boolean test(Level world, ItemStack stack, boolean matchNBT) {
        if (this.isEmpty()) {
            return true;
        }
        return FilterItem.testDirect(this.filterItemStack, stack, matchNBT);
    }

    public boolean test(Level world, FluidStack stack, boolean matchNBT) {
        if (this.isEmpty()) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        this.resolveFluid(world);
        if (this.filterFluidStack.isEmpty()) {
            return false;
        }
        if (!matchNBT) {
            return this.filterFluidStack.getFluid().m_6212_(stack.getFluid());
        }
        return this.filterFluidStack.isFluidEqual(stack);
    }

    private void resolveFluid(Level world) {
        if (!this.fluidExtracted) {
            this.fluidExtracted = true;
            if (GenericItemEmptying.canItemBeEmptied(world, this.filterItemStack)) {
                this.filterFluidStack = GenericItemEmptying.emptyItem(world, this.filterItemStack, true).getFirst();
            }
        }
    }

    protected FilterItemStack(ItemStack filter) {
        this.filterItemStack = filter;
        this.filterFluidStack = FluidStack.EMPTY;
        this.fluidExtracted = false;
    }

    public static class ListFilterItemStack
    extends FilterItemStack {
        public List<FilterItemStack> containedItems;
        public boolean shouldRespectNBT;
        public boolean isBlacklist;

        protected ListFilterItemStack(ItemStack filter) {
            super(filter);
            boolean defaults = !filter.m_41782_();
            this.containedItems = new ArrayList<FilterItemStack>();
            ItemStackHandler items = FilterItem.getFilterItems(filter);
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stackInSlot = items.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                this.containedItems.add(FilterItemStack.of(stackInSlot));
            }
            this.shouldRespectNBT = defaults ? false : filter.m_41783_().m_128471_("RespectNBT");
            this.isBlacklist = defaults ? false : filter.m_41783_().m_128471_("Blacklist");
        }

        @Override
        public boolean test(Level world, ItemStack stack, boolean matchNBT) {
            if (this.containedItems.isEmpty()) {
                return super.test(world, stack, matchNBT);
            }
            for (FilterItemStack filterItemStack : this.containedItems) {
                if (!filterItemStack.test(world, stack, this.shouldRespectNBT)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }

        @Override
        public boolean test(Level world, FluidStack stack, boolean matchNBT) {
            for (FilterItemStack filterItemStack : this.containedItems) {
                if (!filterItemStack.test(world, stack, this.shouldRespectNBT)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }
    }

    public static class AttributeFilterItemStack
    extends FilterItemStack {
        public WhitelistMode whitelistMode;
        public List<Pair<ItemAttribute, Boolean>> attributeTests;

        protected AttributeFilterItemStack(ItemStack filter) {
            super(filter);
            boolean defaults = !filter.m_41782_();
            this.attributeTests = new ArrayList<Pair<ItemAttribute, Boolean>>();
            this.whitelistMode = WhitelistMode.values()[defaults ? 0 : filter.m_41783_().m_128451_("WhitelistMode")];
            ListTag attributes = defaults ? new ListTag() : filter.m_41783_().m_128437_("MatchedAttributes", 10);
            for (Tag inbt : attributes) {
                CompoundTag compound = (CompoundTag)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                if (attribute == null) continue;
                this.attributeTests.add(Pair.of(attribute, compound.m_128471_("Inverted")));
            }
        }

        @Override
        public boolean test(Level world, FluidStack stack, boolean matchNBT) {
            return false;
        }

        @Override
        public boolean test(Level world, ItemStack stack, boolean matchNBT) {
            if (this.attributeTests.isEmpty()) {
                return super.test(world, stack, matchNBT);
            }
            block15: for (Pair<ItemAttribute, Boolean> test : this.attributeTests) {
                boolean matches;
                ItemAttribute attribute = test.getFirst();
                boolean inverted = test.getSecond();
                boolean bl = matches = attribute.appliesTo(stack, world) != inverted;
                if (matches) {
                    switch (this.whitelistMode) {
                        case BLACKLIST: {
                            return false;
                        }
                        case WHITELIST_CONJ: {
                            continue block15;
                        }
                        case WHITELIST_DISJ: {
                            return true;
                        }
                    }
                    continue;
                }
                switch (this.whitelistMode) {
                    case BLACKLIST: {
                        continue block15;
                    }
                    case WHITELIST_CONJ: {
                        return false;
                    }
                    case WHITELIST_DISJ: {
                        continue block15;
                    }
                }
            }
            switch (this.whitelistMode) {
                case BLACKLIST: {
                    return true;
                }
                case WHITELIST_CONJ: {
                    return true;
                }
                case WHITELIST_DISJ: {
                    return false;
                }
            }
            return false;
        }

        public static enum WhitelistMode {
            WHITELIST_DISJ,
            WHITELIST_CONJ,
            BLACKLIST;

        }
    }
}

