/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.extendoGrip;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripInteractionPacket;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItemRenderer;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExtendoGripItem
extends Item {
    public static final int MAX_DAMAGE = 200;
    public static final AttributeModifier singleRangeAttributeModifier = new AttributeModifier(UUID.fromString("7f7dbdb2-0d0d-458a-aa40-ac7633691f66"), "Range modifier", 3.0, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier doubleRangeAttributeModifier = new AttributeModifier(UUID.fromString("8f7dbdb2-0d0d-458a-aa40-ac7633691f66"), "Range modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final Supplier<Multimap<Attribute, AttributeModifier>> rangeModifier = Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)singleRangeAttributeModifier));
    private static final Supplier<Multimap<Attribute, AttributeModifier>> doubleRangeModifier = Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)doubleRangeAttributeModifier));
    private static DamageSource lastActiveDamageSource;
    public static final String EXTENDO_MARKER = "createExtendo";
    public static final String DUAL_EXTENDO_MARKER = "createDualExtendo";

    public ExtendoGripItem(Item.Properties properties) {
        super(properties.m_41499_(200));
    }

    @SubscribeEvent
    public static void holdingExtendoGripIncreasesRange(LivingEvent.LivingTickEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        CompoundTag persistentData = player.getPersistentData();
        boolean inOff = AllItems.EXTENDO_GRIP.isIn(player.m_21206_());
        boolean inMain = AllItems.EXTENDO_GRIP.isIn(player.m_21205_());
        boolean holdingDualExtendo = inOff && inMain;
        boolean holdingExtendo = inOff ^ inMain;
        boolean bl = !holdingDualExtendo;
        boolean wasHoldingExtendo = persistentData.m_128441_(EXTENDO_MARKER);
        boolean wasHoldingDualExtendo = persistentData.m_128441_(DUAL_EXTENDO_MARKER);
        if ((holdingExtendo &= bl) != wasHoldingExtendo) {
            if (!holdingExtendo) {
                player.m_21204_().m_22161_(rangeModifier.get());
                persistentData.m_128473_(EXTENDO_MARKER);
            } else {
                AllAdvancements.EXTENDO_GRIP.awardTo(player);
                player.m_21204_().m_22178_(rangeModifier.get());
                persistentData.m_128379_(EXTENDO_MARKER, true);
            }
        }
        if (holdingDualExtendo != wasHoldingDualExtendo) {
            if (!holdingDualExtendo) {
                player.m_21204_().m_22161_(doubleRangeModifier.get());
                persistentData.m_128473_(DUAL_EXTENDO_MARKER);
            } else {
                AllAdvancements.EXTENDO_GRIP_DUAL.awardTo(player);
                player.m_21204_().m_22178_(doubleRangeModifier.get());
                persistentData.m_128379_(DUAL_EXTENDO_MARKER, true);
            }
        }
    }

    @SubscribeEvent
    public static void addReachToJoiningPlayersHoldingExtendo(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_(DUAL_EXTENDO_MARKER)) {
            player.m_21204_().m_22178_(doubleRangeModifier.get());
        } else if (persistentData.m_128441_(EXTENDO_MARKER)) {
            player.m_21204_().m_22178_(rangeModifier.get());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void dontMissEntitiesWhenYouHaveHighReachDistance(InputEvent.InteractionKeyMappingTriggered event) {
        AABB AABB2;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91073_ == null || player == null) {
            return;
        }
        if (!ExtendoGripItem.isHoldingExtendoGrip((Player)player)) {
            return;
        }
        if (mc.f_91077_ instanceof BlockHitResult && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
            return;
        }
        double d0 = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        if (!player.m_7500_()) {
            d0 -= 0.5;
        }
        Vec3 Vector3d = player.m_20299_(AnimationTickHolder.getPartialTicks());
        Vec3 Vector3d1 = player.m_20252_(1.0f);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * d0, Vector3d1.f_82480_ * d0, Vector3d1.f_82481_ * d0);
        EntityHitResult entityraytraceresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)Vector3d, (Vec3)Vector3d2, (AABB)(AABB2 = player.m_20191_().m_82369_(Vector3d1.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0)), e -> !e.m_5833_() && e.m_6087_(), (double)(d0 * d0));
        if (entityraytraceresult != null) {
            Entity entity1 = entityraytraceresult.m_82443_();
            Vec3 Vector3d3 = entityraytraceresult.m_82450_();
            double d2 = Vector3d.m_82557_(Vector3d3);
            if (d2 < d0 * d0 || mc.f_91077_ == null || mc.f_91077_.m_6662_() == HitResult.Type.MISS) {
                mc.f_91077_ = entityraytraceresult;
                if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrame) {
                    mc.f_91076_ = entity1;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnBlockBreak(BlockEvent.BreakEvent event) {
        ExtendoGripItem.findAndDamageExtendoGrip(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            ExtendoGripItem.findAndDamageExtendoGrip((Player)entity);
        }
    }

    private static void findAndDamageExtendoGrip(Player player) {
        if (player == null) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack extendo = player.m_21205_();
        if (!AllItems.EXTENDO_GRIP.isIn(extendo)) {
            extendo = player.m_21206_();
            hand = InteractionHand.OFF_HAND;
        }
        if (!AllItems.EXTENDO_GRIP.isIn(extendo)) {
            return;
        }
        InteractionHand h = hand;
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, ExtendoGripItem.maxUses())) {
            extendo.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(h));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible(stack, ExtendoGripItem.maxUses());
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth(stack, ExtendoGripItem.maxUses());
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor(stack, ExtendoGripItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxExtendoGripActions.get();
    }

    @SubscribeEvent
    public static void bufferLivingAttackEvent(LivingAttackEvent event) {
        lastActiveDamageSource = event.getSource();
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity trueSource = source.m_7639_();
        if (trueSource instanceof Player) {
            ExtendoGripItem.findAndDamageExtendoGrip((Player)trueSource);
        }
    }

    @SubscribeEvent
    public static void attacksByExtendoGripHaveMoreKnockback(LivingKnockBackEvent event) {
        if (lastActiveDamageSource == null) {
            return;
        }
        Entity entity = lastActiveDamageSource.m_7640_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!ExtendoGripItem.isHoldingExtendoGrip(player)) {
            return;
        }
        event.setStrength(event.getStrength() + 2.0f);
    }

    private static boolean isUncaughtClientInteraction(Entity entity, Entity target) {
        if (entity.m_20280_(target) < 36.0) {
            return false;
        }
        if (!entity.m_9236_().f_46443_) {
            return false;
        }
        return entity instanceof Player;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeAttacks(AttackEntityEvent event) {
        Entity target;
        Player entity = event.getEntity();
        if (!ExtendoGripItem.isUncaughtClientInteraction((Entity)entity, target = event.getTarget())) {
            return;
        }
        Player player = entity;
        if (ExtendoGripItem.isHoldingExtendoGrip(player)) {
            AllPackets.getChannel().sendToServer((Object)new ExtendoGripInteractionPacket(target));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeInteractions(PlayerInteractEvent.EntityInteract event) {
        Entity target;
        Player entity = event.getEntity();
        if (!ExtendoGripItem.isUncaughtClientInteraction((Entity)entity, target = event.getTarget())) {
            return;
        }
        Player player = entity;
        if (ExtendoGripItem.isHoldingExtendoGrip(player)) {
            AllPackets.getChannel().sendToServer((Object)new ExtendoGripInteractionPacket(target, event.getHand()));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeSpecificInteractions(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target;
        Player entity = event.getEntity();
        if (!ExtendoGripItem.isUncaughtClientInteraction((Entity)entity, target = event.getTarget())) {
            return;
        }
        Player player = entity;
        if (ExtendoGripItem.isHoldingExtendoGrip(player)) {
            AllPackets.getChannel().sendToServer((Object)new ExtendoGripInteractionPacket(target, event.getHand(), event.getLocalPos()));
        }
    }

    public static boolean isHoldingExtendoGrip(Player player) {
        boolean inOff = AllItems.EXTENDO_GRIP.isIn(player.m_21206_());
        boolean inMain = AllItems.EXTENDO_GRIP.isIn(player.m_21205_());
        boolean holdingGrip = inOff || inMain;
        return holdingGrip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new ExtendoGripItemRenderer()));
    }
}

