/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.behaviour.BellMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.CampfireMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.dispenser.DispenserMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.dispenser.DropperMovementBehaviour;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AllMovementBehaviours {
    private static final AttachedRegistry<Block, MovementBehaviour> BLOCK_BEHAVIOURS = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final List<BehaviourProvider> GLOBAL_BEHAVIOURS = new ArrayList<BehaviourProvider>();

    public static void registerBehaviour(ResourceLocation block, MovementBehaviour behaviour) {
        BLOCK_BEHAVIOURS.register((Block)block, behaviour);
    }

    public static void registerBehaviour(Block block, MovementBehaviour behaviour) {
        BLOCK_BEHAVIOURS.register(block, behaviour);
    }

    public static void registerBehaviourProvider(BehaviourProvider provider) {
        GLOBAL_BEHAVIOURS.add(provider);
    }

    @Nullable
    public static MovementBehaviour getBehaviour(BlockState state) {
        MovementBehaviour behaviour = BLOCK_BEHAVIOURS.get(state.m_60734_());
        if (behaviour != null) {
            return behaviour;
        }
        for (BehaviourProvider provider : GLOBAL_BEHAVIOURS) {
            behaviour = provider.getBehaviour(state);
            if (behaviour == null) continue;
            return behaviour;
        }
        return null;
    }

    public static <B extends Block> NonNullConsumer<? super B> movementBehaviour(MovementBehaviour behaviour) {
        return b -> AllMovementBehaviours.registerBehaviour(b, behaviour);
    }

    static void registerDefaults() {
        AllMovementBehaviours.registerBehaviour(Blocks.f_50680_, (MovementBehaviour)new BellMovementBehaviour());
        AllMovementBehaviours.registerBehaviour(Blocks.f_50683_, (MovementBehaviour)new CampfireMovementBehaviour());
        AllMovementBehaviours.registerBehaviour(Blocks.f_50684_, (MovementBehaviour)new CampfireMovementBehaviour());
        DispenserMovementBehaviour.gatherMovedDispenseItemBehaviours();
        AllMovementBehaviours.registerBehaviour(Blocks.f_50061_, (MovementBehaviour)new DispenserMovementBehaviour());
        AllMovementBehaviours.registerBehaviour(Blocks.f_50286_, (MovementBehaviour)new DropperMovementBehaviour());
    }

    public static interface BehaviourProvider {
        @Nullable
        public MovementBehaviour getBehaviour(BlockState var1);
    }
}

