/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix3f;

public abstract class Outline {
    protected OutlineParams params = new OutlineParams();
    protected Matrix3f transformNormals;

    public abstract void render(class_4587 var1, SuperRenderTypeBuffer var2, float var3);

    public void tick() {
    }

    public OutlineParams getParams() {
        return this.params;
    }

    public void renderCuboidLine(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 start, class_243 end) {
        class_243 diff = end.method_1020(start);
        float hAngle = AngleHelper.deg(class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350));
        float hDistance = (float)diff.method_18805(1.0, 0.0, 1.0).method_1033();
        float vAngle = AngleHelper.deg(class_3532.method_15349((double)hDistance, (double)diff.field_1351)) - 90.0f;
        ms.method_22903();
        ((TransformStack)((TransformStack)TransformStack.cast((class_4587)ms).translate(start)).rotateY((double)hAngle)).rotateX((double)vAngle);
        this.renderAACuboidLine(ms, buffer, class_243.field_1353, new class_243(0.0, 0.0, diff.method_1033()));
        ms.method_22909();
    }

    public void renderAACuboidLine(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 start, class_243 end) {
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        class_4588 builder = buffer.getBuffer(RenderTypes.getOutlineSolid());
        class_243 diff = end.method_1020(start);
        if (diff.field_1352 + diff.field_1351 + diff.field_1350 < 0.0) {
            class_243 temp = start;
            start = end;
            end = temp;
            diff = diff.method_1021(-1.0);
        }
        class_243 extension = diff.method_1029().method_1021((double)(lineWidth / 2.0f));
        class_243 plane = VecHelper.axisAlingedPlaneOf(diff);
        class_2350 face = class_2350.method_10142((double)diff.field_1352, (double)diff.field_1351, (double)diff.field_1350);
        class_2350.class_2351 axis = face.method_10166();
        start = start.method_1020(extension);
        end = end.method_1019(extension);
        plane = plane.method_1021((double)(lineWidth / 2.0f));
        class_243 a1 = plane.method_1019(start);
        class_243 b1 = plane.method_1019(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        class_243 a2 = plane.method_1019(start);
        class_243 b2 = plane.method_1019(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        class_243 a3 = plane.method_1019(start);
        class_243 b3 = plane.method_1019(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        class_243 a4 = plane.method_1019(start);
        class_243 b4 = plane.method_1019(end);
        if (this.params.disableNormals) {
            face = class_2350.field_11036;
            this.putQuad(ms, builder, b4, b3, b2, b1, face);
            this.putQuad(ms, builder, a1, a2, a3, a4, face);
            this.putQuad(ms, builder, a1, b1, b2, a2, face);
            this.putQuad(ms, builder, a2, b2, b3, a3, face);
            this.putQuad(ms, builder, a3, b3, b4, a4, face);
            this.putQuad(ms, builder, a4, b4, b1, a1, face);
            return;
        }
        this.putQuad(ms, builder, b4, b3, b2, b1, face);
        this.putQuad(ms, builder, a1, a2, a3, a4, face.method_10153());
        class_243 vec = a1.method_1020(a4);
        face = class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
        this.putQuad(ms, builder, a1, b1, b2, a2, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
        this.putQuad(ms, builder, a2, b2, b3, a3, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
        this.putQuad(ms, builder, a3, b3, b4, a4, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
        this.putQuad(ms, builder, a4, b4, b1, a1, face);
    }

    public void putQuad(class_4587 ms, class_4588 builder, class_243 v1, class_243 v2, class_243 v3, class_243 v4, class_2350 normal) {
        this.putQuadUV(ms, builder, v1, v2, v3, v4, 0.0f, 0.0f, 1.0f, 1.0f, normal);
    }

    public void putQuadUV(class_4587 ms, class_4588 builder, class_243 v1, class_243 v2, class_243 v3, class_243 v4, float minU, float minV, float maxU, float maxV, class_2350 normal) {
        this.putVertex(ms, builder, v1, minU, minV, normal);
        this.putVertex(ms, builder, v2, maxU, minV, normal);
        this.putVertex(ms, builder, v3, maxU, maxV, normal);
        this.putVertex(ms, builder, v4, minU, maxV, normal);
    }

    protected void putVertex(class_4587 ms, class_4588 builder, class_243 pos, float u, float v, class_2350 normal) {
        this.putVertex(ms.method_23760(), builder, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350, u, v, normal);
    }

    protected void putVertex(class_4587.class_4665 pose, class_4588 builder, float x, float y, float z, float u, float v, class_2350 normal) {
        Color rgb = this.params.rgb;
        if (this.transformNormals == null) {
            this.transformNormals = pose.method_23762();
        }
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        if (normal != null) {
            xOffset = normal.method_10148();
            yOffset = normal.method_10164();
            zOffset = normal.method_10165();
        }
        builder.method_22918(pose.method_23761(), x, y, z).method_22915(rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), rgb.getAlphaAsFloat() * this.params.alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(this.params.lightMap).method_23763(pose.method_23762(), (float)xOffset, (float)yOffset, (float)zOffset).method_1344();
        this.transformNormals = null;
    }

    public static class OutlineParams {
        protected Optional<AllSpecialTextures> faceTexture;
        protected Optional<AllSpecialTextures> hightlightedFaceTexture = Optional.empty();
        protected class_2350 highlightedFace;
        protected boolean fadeLineWidth = true;
        protected boolean disableCull;
        protected boolean disableNormals;
        protected float alpha = 1.0f;
        protected int lightMap = 0xF000F0;
        protected Color rgb;
        private float lineWidth = 0.03125f;

        public OutlineParams() {
            this.faceTexture = this.hightlightedFaceTexture;
            this.rgb = Color.WHITE;
        }

        public OutlineParams colored(int color) {
            this.rgb = new Color(color, false);
            return this;
        }

        public OutlineParams colored(Color c) {
            this.rgb = c.copy();
            return this;
        }

        public OutlineParams lightMap(int light) {
            this.lightMap = light;
            return this;
        }

        public OutlineParams lineWidth(float width) {
            this.lineWidth = width;
            return this;
        }

        public OutlineParams withFaceTexture(AllSpecialTextures texture) {
            this.faceTexture = Optional.ofNullable(texture);
            return this;
        }

        public OutlineParams clearTextures() {
            return this.withFaceTextures(null, null);
        }

        public OutlineParams withFaceTextures(AllSpecialTextures texture, AllSpecialTextures highlightTexture) {
            this.faceTexture = Optional.ofNullable(texture);
            this.hightlightedFaceTexture = Optional.ofNullable(highlightTexture);
            return this;
        }

        public OutlineParams highlightFace(@Nullable class_2350 face) {
            this.highlightedFace = face;
            return this;
        }

        public OutlineParams disableNormals() {
            this.disableNormals = true;
            return this;
        }

        public OutlineParams disableCull() {
            this.disableCull = true;
            return this;
        }

        public float getLineWidth() {
            return this.fadeLineWidth ? this.alpha * this.lineWidth : this.lineWidth;
        }

        public class_2350 getHighlightedFace() {
            return this.highlightedFace;
        }
    }
}

