/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour;

import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.outliner.ChasingAABBOutline;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Components;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_918;

public class ValueBox
extends ChasingAABBOutline {
    protected class_2561 label;
    protected class_2561 sublabel = Components.immutableEmpty();
    protected class_2561 scrollTooltip = Components.immutableEmpty();
    protected class_243 labelOffset = class_243.field_1353;
    public int overrideColor = -1;
    public boolean isPassive;
    protected class_2338 pos;
    protected ValueBoxTransform transform;
    protected class_2680 blockState;
    protected AllIcons outline = AllIcons.VALUE_BOX_HOVER_4PX;

    public ValueBox(class_2561 label, class_238 bb, class_2338 pos) {
        this(label, bb, pos, class_310.method_1551().field_1687.method_8320(pos));
    }

    public ValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2680 state) {
        super(bb);
        this.label = label;
        this.pos = pos;
        this.blockState = state;
    }

    public ValueBox transform(ValueBoxTransform transform) {
        this.transform = transform;
        return this;
    }

    public ValueBox wideOutline() {
        this.outline = AllIcons.VALUE_BOX_HOVER_6PX;
        return this;
    }

    public ValueBox passive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    public ValueBox withColor(int color) {
        this.overrideColor = color;
        return this;
    }

    @Override
    public void render(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        boolean hasTransform;
        boolean bl = hasTransform = this.transform != null;
        if (this.transform instanceof ValueBoxTransform.Sided && this.params.getHighlightedFace() != null) {
            ((ValueBoxTransform.Sided)this.transform).fromSide(this.params.getHighlightedFace());
        }
        if (hasTransform && !this.transform.shouldRender(this.blockState)) {
            return;
        }
        ms.method_22903();
        ms.method_22904((double)this.pos.method_10263() - camera.field_1352, (double)this.pos.method_10264() - camera.field_1351, (double)this.pos.method_10260() - camera.field_1350);
        if (hasTransform) {
            this.transform.transform(this.blockState, ms);
        }
        if (!this.isPassive) {
            ms.method_22903();
            ms.method_22905(-2.01f, -2.01f, 2.01f);
            ms.method_22904(-0.5, -0.5, -0.03125);
            this.getOutline().render(ms, buffer, 0xFFFFFF);
            ms.method_22909();
        }
        float fontScale = hasTransform ? -this.transform.getFontScale() : -0.015625f;
        ms.method_22905(fontScale, fontScale, fontScale);
        this.renderContents(ms, buffer);
        ms.method_22909();
    }

    public AllIcons getOutline() {
        return this.outline;
    }

    public void renderContents(class_4587 ms, class_4597 buffer) {
    }

    protected void renderHoveringText(class_4587 ms, class_4597 buffer, class_2561 text, int color) {
        ms.method_22903();
        ValueBox.drawString(ms, buffer, text, 0.0f, 0.0f, color);
        ms.method_22909();
    }

    private static void drawString(class_4587 ms, class_4597 buffer, class_2561 text, float x, float y, int color) {
        class_310.method_1551().field_1772.method_30882(text, x, y, color, false, ms.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public static class IconValueBox
    extends ValueBox {
        AllIcons icon;

        public IconValueBox(class_2561 label, INamedIconOptions iconValue, class_238 bb, class_2338 pos) {
            super(label, bb, pos);
            this.icon = iconValue.getIcon();
        }

        @Override
        public void renderContents(class_4587 ms, class_4597 buffer) {
            super.renderContents(ms, buffer);
            float scale = 32.0f;
            ms.method_22905(scale, scale, scale);
            ms.method_46416(-0.5f, -0.5f, 0.15625f);
            int overrideColor = this.transform.getOverrideColor();
            this.icon.render(ms, buffer, overrideColor != -1 ? overrideColor : 0xFFFFFF);
        }
    }

    public static class TextValueBox
    extends ValueBox {
        class_2561 text;

        public TextValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2561 text) {
            super(label, bb, pos);
            this.text = text;
        }

        public TextValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2680 state, class_2561 text) {
            super(label, bb, pos, state);
            this.text = text;
        }

        @Override
        public void renderContents(class_4587 ms, class_4597 buffer) {
            boolean singleDigit;
            super.renderContents(ms, buffer);
            class_327 font = class_310.method_1551().field_1772;
            float scale = 3.0f;
            ms.method_22905(scale, scale, 1.0f);
            ms.method_22904(-4.0, -3.75, 5.0);
            int stringWidth = font.method_27525((class_5348)this.text);
            Objects.requireNonNull(font);
            float numberScale = 9.0f / (float)stringWidth;
            boolean bl = singleDigit = stringWidth < 10;
            if (singleDigit) {
                numberScale /= 2.0f;
            }
            Objects.requireNonNull(font);
            float verticalMargin = (float)(stringWidth - 9) / 2.0f;
            ms.method_22905(numberScale, numberScale, numberScale);
            ms.method_46416(singleDigit ? (float)(stringWidth / 2) : 0.0f, singleDigit ? -verticalMargin : verticalMargin, 0.0f);
            int overrideColor = this.transform.getOverrideColor();
            this.renderHoveringText(ms, buffer, this.text, overrideColor != -1 ? overrideColor : 0xEDEDED);
        }
    }

    public static class ItemValueBox
    extends ValueBox {
        class_1799 stack;
        int count;
        boolean upTo;

        public ItemValueBox(class_2561 label, class_238 bb, class_2338 pos, class_1799 stack, int count, boolean upTo) {
            super(label, bb, pos);
            this.stack = stack;
            this.count = count;
            this.upTo = upTo;
        }

        @Override
        public AllIcons getOutline() {
            if (!this.stack.method_7960()) {
                return AllIcons.VALUE_BOX_HOVER_6PX;
            }
            return super.getOutline();
        }

        @Override
        public void renderContents(class_4587 ms, class_4597 buffer) {
            super.renderContents(ms, buffer);
            if (this.count == -1) {
                return;
            }
            class_327 font = class_310.method_1551().field_1772;
            boolean wildcard = this.count == 0 || this.upTo && this.count >= this.stack.method_7914();
            class_5250 countString = Components.literal((String)(wildcard ? "*" : "" + this.count));
            ms.method_46416(17.5f, -5.0f, 7.0f);
            boolean isFilter = this.stack.method_7909() instanceof FilterItem;
            boolean isEmpty = this.stack.method_7960();
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1087 modelWithOverrides = itemRenderer.method_4019(this.stack, null, null, 0);
            boolean blockItem = modelWithOverrides.method_4712();
            float scale = 1.5f;
            ms.method_46416((float)(-font.method_27525((class_5348)countString)), 0.0f, 0.0f);
            if (isFilter) {
                ms.method_46416(-5.0f, 8.0f, 7.25f);
            } else if (isEmpty) {
                ms.method_46416(-15.0f, -1.0f, -2.75f);
                scale = 1.65f;
            } else {
                ms.method_46416(-7.0f, 10.0f, blockItem ? 10.25f : 0.0f);
            }
            if (wildcard) {
                ms.method_46416(-1.0f, 3.0f, 0.0f);
            }
            ms.method_22905(scale, scale, scale);
            ValueBox.drawString(ms, buffer, (class_2561)countString, 0.0f, 0.0f, isFilter ? 0xFFFFFF : 0xEDEDED);
            ms.method_46416(0.0f, 0.0f, -0.0625f);
            ValueBox.drawString(ms, buffer, (class_2561)countString, 0.875f, 0.875f, 0x4F4F4F);
        }
    }
}

