/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectedTextureBehaviour {
    @Nullable
    public abstract CTSpriteShiftEntry getShift(class_2680 var1, class_2350 var2, @NotNull class_1058 var3);

    @Nullable
    public abstract CTType getDataType(class_1920 var1, class_2338 var2, class_2680 var3, class_2350 var4);

    public boolean buildContextForOccludedDirections() {
        return false;
    }

    protected boolean isBeingBlocked(class_2680 state, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        class_2338 blockingPos = otherPos.method_10093(face);
        class_2680 blockState = reader.method_8320(pos);
        class_2680 blockingState = reader.method_8320(blockingPos);
        if (!class_2248.method_9501((class_265)blockingState.method_26218((class_1922)reader, blockingPos), (class_2350)face.method_10153())) {
            return false;
        }
        if (face.method_10166().method_10173(pos.method_10263(), pos.method_10264(), pos.method_10260()) != face.method_10166().method_10173(otherPos.method_10263(), otherPos.method_10264(), otherPos.method_10260())) {
            return false;
        }
        return this.connectsTo(state, this.getCTBlockState(reader, blockState, face.method_10153(), pos.method_10093(face), blockingPos), reader, pos, blockingPos, face);
    }

    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face, class_2350 primaryOffset, class_2350 secondaryOffset) {
        return this.connectsTo(state, other, reader, pos, otherPos, face);
    }

    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        return !this.isBeingBlocked(state, reader, pos, otherPos, face) && state.method_26204() == other.method_26204();
    }

    private boolean testConnection(class_1920 reader, class_2338 currentPos, class_2680 connectiveCurrentState, class_2350 textureSide, class_2350 horizontal, class_2350 vertical, int sh, int sv) {
        class_2680 trueCurrentState = reader.method_8320(currentPos);
        class_2338 targetPos = currentPos.method_10079(horizontal, sh).method_10079(vertical, sv);
        class_2680 connectiveTargetState = this.getCTBlockState(reader, trueCurrentState, textureSide, currentPos, targetPos);
        return this.connectsTo(connectiveCurrentState, connectiveTargetState, reader, currentPos, targetPos, textureSide, sh == 0 ? null : (sh == -1 ? horizontal.method_10153() : horizontal), sv == 0 ? null : (sv == -1 ? vertical.method_10153() : vertical));
    }

    public class_2680 getCTBlockState(class_1920 reader, class_2680 reference, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        class_2680 blockState = reader.method_8320(toPos);
        return blockState.getAppearance(reader, toPos, face, reference, fromPos);
    }

    protected boolean reverseUVs(class_2680 state, class_2350 face) {
        return false;
    }

    protected boolean reverseUVsHorizontally(class_2680 state, class_2350 face) {
        return this.reverseUVs(state, face);
    }

    protected boolean reverseUVsVertically(class_2680 state, class_2350 face) {
        return this.reverseUVs(state, face);
    }

    protected class_2350 getUpDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = face.method_10166();
        return axis.method_10179() ? class_2350.field_11036 : class_2350.field_11043;
    }

    protected class_2350 getRightDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = face.method_10166();
        return axis == class_2350.class_2351.field_11048 ? class_2350.field_11035 : class_2350.field_11039;
    }

    public CTContext buildContext(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face, ContextRequirement requirement) {
        boolean positive = face.method_10171() == class_2350.class_2352.field_11056;
        class_2350 h = this.getRightDirection(reader, pos, state, face);
        class_2350 v = this.getUpDirection(reader, pos, state, face);
        class_2350 class_23502 = h = positive ? h.method_10153() : h;
        if (face == class_2350.field_11033) {
            v = v.method_10153();
            h = h.method_10153();
        }
        class_2350 horizontal = h;
        class_2350 vertical = v;
        boolean flipH = this.reverseUVsHorizontally(state, face);
        boolean flipV = this.reverseUVsVertically(state, face);
        int sh = flipH ? -1 : 1;
        int sv = flipV ? -1 : 1;
        CTContext context = new CTContext();
        if (requirement.up) {
            context.up = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, sv);
        }
        if (requirement.down) {
            context.down = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, -sv);
        }
        if (requirement.left) {
            context.left = this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, 0);
        }
        if (requirement.right) {
            context.right = this.testConnection(reader, pos, state, face, horizontal, vertical, sh, 0);
        }
        if (requirement.topLeft) {
            boolean bl = context.topLeft = context.up && context.left && this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, sv);
        }
        if (requirement.topRight) {
            boolean bl = context.topRight = context.up && context.right && this.testConnection(reader, pos, state, face, horizontal, vertical, sh, sv);
        }
        if (requirement.bottomLeft) {
            boolean bl = context.bottomLeft = context.down && context.left && this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, -sv);
        }
        if (requirement.bottomRight) {
            context.bottomRight = context.down && context.right && this.testConnection(reader, pos, state, face, horizontal, vertical, sh, -sv);
        }
        return context;
    }

    public static class CTContext {
        public static final CTContext EMPTY = new CTContext();
        public boolean up;
        public boolean down;
        public boolean left;
        public boolean right;
        public boolean topLeft;
        public boolean topRight;
        public boolean bottomLeft;
        public boolean bottomRight;
    }

    public static class ContextRequirement {
        public final boolean up;
        public final boolean down;
        public final boolean left;
        public final boolean right;
        public final boolean topLeft;
        public final boolean topRight;
        public final boolean bottomLeft;
        public final boolean bottomRight;

        public ContextRequirement(boolean up, boolean down, boolean left, boolean right, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            this.up = up;
            this.down = down;
            this.left = left;
            this.right = right;
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private boolean up;
            private boolean down;
            private boolean left;
            private boolean right;
            private boolean topLeft;
            private boolean topRight;
            private boolean bottomLeft;
            private boolean bottomRight;

            public Builder up() {
                this.up = true;
                return this;
            }

            public Builder down() {
                this.down = true;
                return this;
            }

            public Builder left() {
                this.left = true;
                return this;
            }

            public Builder right() {
                this.right = true;
                return this;
            }

            public Builder topLeft() {
                this.topLeft = true;
                return this;
            }

            public Builder topRight() {
                this.topRight = true;
                return this;
            }

            public Builder bottomLeft() {
                this.bottomLeft = true;
                return this;
            }

            public Builder bottomRight() {
                this.bottomRight = true;
                return this;
            }

            public Builder horizontal() {
                this.left();
                this.right();
                return this;
            }

            public Builder vertical() {
                this.up();
                this.down();
                return this;
            }

            public Builder axisAligned() {
                this.horizontal();
                this.vertical();
                return this;
            }

            public Builder corners() {
                this.topLeft();
                this.topRight();
                this.bottomLeft();
                this.bottomRight();
                return this;
            }

            public Builder all() {
                this.axisAligned();
                this.corners();
                return this;
            }

            public ContextRequirement build() {
                return new ContextRequirement(this.up, this.down, this.left, this.right, this.topLeft, this.topRight, this.bottomLeft, this.bottomRight);
            }
        }
    }

    public static abstract class Base
    extends ConnectedTextureBehaviour {
        @Override
        @Nullable
        public abstract CTSpriteShiftEntry getShift(class_2680 var1, class_2350 var2, @Nullable class_1058 var3);

        @Override
        @Nullable
        public CTType getDataType(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            CTSpriteShiftEntry shift = this.getShift(state, direction, null);
            if (shift == null) {
                return null;
            }
            return shift.getType();
        }
    }
}

