/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.Create;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.betterend.BetterEndPortalCompat;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.entity.ITeleporter;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class AllPortalTracks {
    private static final AttachedRegistry<class_2248, PortalTrackProvider> PORTAL_BEHAVIOURS = new AttachedRegistry(class_7923.field_41175);

    public static void registerIntegration(class_2960 block, PortalTrackProvider provider) {
        PORTAL_BEHAVIOURS.register((class_2248)block, provider);
    }

    public static void registerIntegration(class_2248 block, PortalTrackProvider provider) {
        PORTAL_BEHAVIOURS.register(block, provider);
    }

    public static boolean isSupportedPortal(class_2680 state) {
        return PORTAL_BEHAVIOURS.get(state.method_26204()) != null;
    }

    public static Pair<class_3218, BlockFace> getOtherSide(class_3218 level, BlockFace inboundTrack) {
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        PortalTrackProvider provider = PORTAL_BEHAVIOURS.get(portalState.method_26204());
        return provider == null ? null : (Pair)provider.apply(Pair.of(level, inboundTrack));
    }

    public static void registerDefaults() {
        AllPortalTracks.registerIntegration(class_2246.field_10316, AllPortalTracks::nether);
        if (Mods.AETHER.isLoaded()) {
            AllPortalTracks.registerIntegration(Mods.AETHER.rl("aether_portal"), AllPortalTracks::aether);
        }
        if (Mods.BETTEREND.isLoaded()) {
            AllPortalTracks.registerIntegration(Mods.BETTEREND.rl("end_portal_block"), AllPortalTracks::betterend);
        }
    }

    private static Pair<class_3218, BlockFace> nether(Pair<class_3218, BlockFace> inbound) {
        class_3218 level = inbound.getFirst();
        MinecraftServer minecraftServer = level.method_8503();
        if (!minecraftServer.method_3839()) {
            return null;
        }
        return AllPortalTracks.standardPortalProvider(inbound, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)class_1937.field_25180, AllPortalTracks::getTeleporter);
    }

    private static Pair<class_3218, BlockFace> aether(Pair<class_3218, BlockFace> inbound) {
        class_5321 aetherLevelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)Mods.AETHER.rl("the_aether"));
        return AllPortalTracks.standardPortalProvider(inbound, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)aetherLevelKey, level -> {
            try {
                return (ITeleporter)Class.forName("com.aetherteam.aether.block.portal.AetherPortalForcer").getDeclaredConstructor(class_3218.class, Boolean.TYPE).newInstance(level, true);
            }
            catch (Exception e) {
                Create.LOGGER.error("Failed to create Aether teleporter: ", (Throwable)e);
                return AllPortalTracks.getTeleporter(level);
            }
        });
    }

    private static Pair<class_3218, BlockFace> betterend(Pair<class_3218, BlockFace> inbound) {
        return AllPortalTracks.portalProvider(inbound, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)class_1937.field_25181, BetterEndPortalCompat::getBetterEndPortalInfo);
    }

    private static ITeleporter getTeleporter(class_3218 level) {
        return (ITeleporter)level.method_14173();
    }

    public static Pair<class_3218, BlockFace> standardPortalProvider(Pair<class_3218, BlockFace> inbound, class_5321<class_1937> firstDimension, class_5321<class_1937> secondDimension, Function<class_3218, ITeleporter> customPortalForcer) {
        return AllPortalTracks.portalProvider(inbound, firstDimension, secondDimension, (otherLevel, probe) -> {
            ITeleporter teleporter = (ITeleporter)customPortalForcer.apply((class_3218)otherLevel);
            return teleporter.getPortalInfo((class_1297)probe, otherLevel, probe::method_30329);
        });
    }

    public static Pair<class_3218, BlockFace> portalProvider(Pair<class_3218, BlockFace> inbound, class_5321<class_1937> firstDimension, class_5321<class_1937> secondDimension, BiFunction<class_3218, SuperGlueEntity, class_5454> portalInfoProvider) {
        class_3218 level = inbound.getFirst();
        class_5321<class_1937> resourceKey = level.method_27983() == secondDimension ? firstDimension : secondDimension;
        MinecraftServer minecraftServer = level.method_8503();
        class_3218 otherLevel = minecraftServer.method_3847(resourceKey);
        if (otherLevel == null) {
            return null;
        }
        BlockFace inboundTrack = inbound.getSecond();
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        SuperGlueEntity probe = new SuperGlueEntity((class_1937)level, new class_238(portalPos));
        probe.method_36456(inboundTrack.getFace().method_10144());
        probe.setPortalEntrancePos();
        class_5454 portalInfo = portalInfoProvider.apply(otherLevel, probe);
        if (portalInfo == null) {
            return null;
        }
        class_2338 otherPortalPos = class_2338.method_49638((class_2374)portalInfo.field_25879);
        class_2680 otherPortalState = otherLevel.method_8320(otherPortalPos);
        if (!otherPortalState.method_27852(portalState.method_26204())) {
            return null;
        }
        class_2350 targetDirection = inboundTrack.getFace();
        if (targetDirection.method_10166() == otherPortalState.method_11654((class_2769)class_2741.field_12529)) {
            targetDirection = targetDirection.method_10170();
        }
        class_2338 otherPos = otherPortalPos.method_10093(targetDirection);
        return Pair.of(otherLevel, new BlockFace(otherPos, targetDirection.method_10153()));
    }

    @FunctionalInterface
    public static interface PortalTrackProvider
    extends UnaryOperator<Pair<class_3218, BlockFace>> {
    }
}

